/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.autagent;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jubula.app.autagent.i18n.Messages;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.desktop.DesktopIntegration;
import org.eclipse.jubula.communication.connection.ConnectionState;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutAgentApplication
implements IApplication {
    private static final String HOSTNAME = "hostname";
    private static final String COMMANDLINE_PORT = "port";
    private static final String AUTAGENT_LAUNCHER = "autagent";
    private static final String DEFAULT_HOSTNAME_LOCALHOST = "localhost";
    private static final Logger LOG = LoggerFactory.getLogger(AutAgentApplication.class);
    private static final int TIMEOUT_SEND_STOP_CMD = 10000;
    private static final String COMMANDLINE_OPTION_STOP = "stop";
    private static final String COMMANDLINE_OPTION_PORT = "p";
    private static final String COMMANDLINE_OPTION_HELP = "h";
    private static final String COMMANDLINE_OPTION_LENIENT = "l";
    private static final String COMMANDLINE_OPTION_VERBOSE = "v";
    private static final String COMMANDLINE_OPTION_QUIET = "q";
    private static final String COMMANDLINE_OPTION_START = "start";
    private static final int EXIT_INVALID_OPTIONS = -1;
    private static final int EXIT_HELP_OPTION = 0;
    private static final int EXIT_SECURITY_VIOLATION = 1;
    private static final int EXIT_IO_EXCEPTION = 2;
    private static final int EXIT_CLIENT_SERVER_VERSION_ERROR = 4;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null) {
            args = new String[]{};
        }
        AutStarter server = AutStarter.getInstance();
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(AutAgentApplication.createOptions(), args);
            if (cmd.hasOption(COMMANDLINE_OPTION_HELP)) {
                this.printHelp();
                return 0;
            }
            int port = this.getPortNumber(cmd);
            if (cmd.hasOption(COMMANDLINE_OPTION_STOP)) {
                String hostname = DEFAULT_HOSTNAME_LOCALHOST;
                if (cmd.getOptionValue(COMMANDLINE_OPTION_STOP) != null) {
                    hostname = cmd.getOptionValue(COMMANDLINE_OPTION_STOP);
                }
                this.stopAutAgent(hostname, port);
            } else {
                boolean killDuplicateAuts = !cmd.hasOption(COMMANDLINE_OPTION_LENIENT);
                AutStarter.Verbosity verbosity = AutStarter.Verbosity.NORMAL;
                if (cmd.hasOption(COMMANDLINE_OPTION_VERBOSE)) {
                    verbosity = AutStarter.Verbosity.VERBOSE;
                } else if (cmd.hasOption(COMMANDLINE_OPTION_QUIET)) {
                    verbosity = AutStarter.Verbosity.QUIET;
                }
                DesktopIntegration di = new DesktopIntegration(server.getAgent());
                di.setPort(port);
                server.getAgent().addPropertyChangeListener("auts", (PropertyChangeListener)di);
                server.start(port, killDuplicateAuts, verbosity, true);
            }
        }
        catch (ParseException pe) {
            String message = Messages.ParseExceptionInvalidOption;
            LOG.error(message, (Throwable)pe);
            this.printHelp();
            return -1;
        }
        catch (SecurityException se) {
            LOG.error(Messages.SecurityExceptionViolation, (Throwable)se);
            return 1;
        }
        catch (IOException ioe) {
            String message = Messages.IOExceptionNotOpenSocket;
            LOG.error(message, (Throwable)ioe);
            return 2;
        }
        catch (NumberFormatException nfe) {
            String message = Messages.NumberFormatExceptionInvalidValue;
            LOG.error(message, (Throwable)nfe);
            return -1;
        }
        catch (NullPointerException npe) {
            LOG.error(Messages.NullPointerExceptionNoCommandLine, (Throwable)npe);
            this.printHelp();
            return -1;
        }
        catch (JBVersionException ve) {
            LOG.error(ve.getMessage(), (Throwable)ve);
            return 4;
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private static Options createOptions() {
        Options options = new Options();
        Option portOption = new Option(COMMANDLINE_OPTION_PORT, true, Messages.CommandlineOptionPort);
        portOption.setArgName(COMMANDLINE_PORT);
        options.addOption(portOption);
        options.addOption(COMMANDLINE_OPTION_LENIENT, false, Messages.CommandlineOptionLenient);
        options.addOption(COMMANDLINE_OPTION_HELP, false, Messages.CommandlineOptionHelp);
        OptionGroup verbosityOptions = new OptionGroup();
        verbosityOptions.addOption(new Option(COMMANDLINE_OPTION_QUIET, false, Messages.CommandlineOptionQuiet));
        verbosityOptions.addOption(new Option(COMMANDLINE_OPTION_VERBOSE, false, Messages.CommandlineOptionVerbose));
        options.addOptionGroup(verbosityOptions);
        OptionGroup startStopOptions = new OptionGroup();
        startStopOptions.addOption(new Option(COMMANDLINE_OPTION_START, false, Messages.CommandlineOptionStart));
        OptionBuilder.hasOptionalArg();
        Option stopOption = OptionBuilder.create((String)COMMANDLINE_OPTION_STOP);
        stopOption.setDescription(NLS.bind((String)Messages.OptionStopDescription, (Object)DEFAULT_HOSTNAME_LOCALHOST));
        stopOption.setArgName(HOSTNAME);
        startStopOptions.addOption(stopOption);
        options.addOptionGroup(startStopOptions);
        return options;
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(AUTAGENT_LAUNCHER, AutAgentApplication.createOptions(), true);
    }

    private void waitForAgentToTerminate(BufferedReader br) {
        boolean socketAlive = true;
        while (socketAlive) {
            try {
                if (br.readLine() != null) continue;
                socketAlive = false;
            }
            catch (IOException iOException) {
                socketAlive = false;
            }
        }
    }

    private int getPortNumber(CommandLine cmd) {
        int port = 60000;
        if (cmd.hasOption(COMMANDLINE_OPTION_PORT)) {
            port = Integer.valueOf(cmd.getOptionValue(COMMANDLINE_OPTION_PORT));
        } else {
            int envPort = EnvironmentUtils.getAUTAgentEnvironmentPortNo();
            if (envPort > 0) {
                port = envPort;
            }
            LOG.info(NLS.bind((String)Messages.InfoDefaultPort, (Object)port));
        }
        return port;
    }

    private void stopAutAgent(String hostname, int port) throws UnknownHostException, IOException, JBVersionException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Socket commandSocket = new Socket(hostname, port);){
                InputStream inputStream = commandSocket.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                ConnectionState.respondToTypeRequest((long)10000L, (BufferedReader)br, (InputStream)inputStream, (PrintStream)new PrintStream(commandSocket.getOutputStream()), (String)"ClientType.Command.ShutDown");
                this.waitForAgentToTerminate(br);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ConnectException connectException) {
            System.out.println(NLS.bind((String)Messages.AUTAgentNotFound, (Object)hostname, (Object)port));
        }
    }
}

