/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.autagent.handlers;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectToEmbeddedAutAgentHandler
extends AbstractHandler
implements IHandler {
    public static final String CONNECT_TO_EMBEDDED_AGENT_CMD_ID = "org.eclipse.jubula.client.autagent.commands.ConnectToEmbeddedAutAgent";
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectToEmbeddedAutAgentHandler.class);
    private static final String EMBEDDED_AGENT_HOSTNAME = "localhost";

    public Object execute(ExecutionEvent event) {
        AutStarter autAgentInstance = AutStarter.getInstance();
        if (autAgentInstance.getCommunicator() == null) {
            int port = Platform.getPreferencesService().getInt("org.eclipse.jubula.client.autagent", "org.eclipse.jubula.autagent.preference.port", 60000, null);
            try {
                autAgentInstance.start(port, false, AutStarter.Verbosity.QUIET, false);
            }
            catch (Exception e) {
                String message = I18n.getString((String)"AUTAgent.StartCommErrorText", (Object[])new String[]{String.valueOf(port)});
                LOG.error(message, (Throwable)e);
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.jubula.client.autagent", message, (Throwable)e), 2);
                return null;
            }
        }
        String hostname = EMBEDDED_AGENT_HOSTNAME;
        int port = autAgentInstance.getCommunicator().getLocalPort();
        Command connectToAutAgentCommand = CommandHelper.getCommandService().getCommand("org.eclipse.jubula.client.ui.rcp.commands.ConnectToAUTAgentCommand");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.eclipse.jubula.client.ui.rcp.commands.ConnectToAUTAgentCommand.parameter.name", hostname);
        parameters.put("org.eclipse.jubula.client.ui.rcp.commands.ConnectToAUTAgentCommand.parameter.port", String.valueOf(port));
        CommandHelper.executeParameterizedCommand((ParameterizedCommand)ParameterizedCommand.generateCommand((Command)connectToAutAgentCommand, parameters));
        return null;
    }
}

