/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public final class FormateDateEvaluator
extends AbstractFunctionEvaluator {
    public String evaluate(String[] arguments) throws InvalidDataException {
        this.validateParamCount(arguments, 2);
        try {
            Long dateTime = Long.valueOf(arguments[0]);
            if (dateTime < 0L) {
                throw new InvalidDataException("value to small: " + dateTime, MessageIDs.E_TOO_SMALL_VALUE);
            }
            Date date = new Date(dateTime);
            return DateFormatUtils.format((Date)date, (String)arguments[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataException("not an integer: " + arguments[0], MessageIDs.E_BAD_INT);
        }
    }
}

