/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinAutConfigComponent
extends AutConfigComponent {
    protected static final int COMPOSITE_WIDTH = 250;
    private static boolean isExecFieldEmpty = true;
    private static String executablePath;
    private boolean m_isExecFieldValid = true;
    private Text m_execTextField;
    private Button m_execButton;
    private Text m_autArgsTextField;
    private WidgetModifyListener m_modifyListener;
    private WidgetSelectionListener m_selectionListener;

    public WinAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName, false);
    }

    @Override
    protected void initState() {
        this.m_execTextField.setEnabled(true);
        this.m_execButton.setEnabled(true);
        this.m_autArgsTextField.setEnabled(true);
        this.checkLocalhostServer();
        RemoteFileBrowserBP.clearCache();
    }

    @Override
    protected boolean checkLocalhostServer() {
        boolean enable = super.checkLocalhostServer();
        boolean browseEnabled = enable || this.isRemoteRequest();
        this.m_execButton.setEnabled(browseEnabled && this.m_execButton.isEnabled());
        return enable;
    }

    @Override
    protected void createBasicArea(Composite basicAreaComposite) {
        super.createBasicArea(basicAreaComposite);
        UIComponentHelper.createLabel((Composite)basicAreaComposite, (String)"AUTConfigComponent.exec");
        this.m_execTextField = UIComponentHelper.createTextField((Composite)basicAreaComposite, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_execTextField, (int)4000);
        this.m_execButton = new Button(UIComponentHelper.createLayoutComposite((Composite)basicAreaComposite), 8);
        this.m_execButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_execButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_execButton.setEnabled(Utils.isLocalhost());
        ControlDecorator.createInfo((Control)UIComponentHelper.createLabel((Composite)basicAreaComposite, (String)"AUTConfigComponent.autArguments"), Messages.AUTConfigComponentArgumentsControlDecorator, false);
        this.m_autArgsTextField = UIComponentHelper.createTextField((Composite)basicAreaComposite, (int)2);
    }

    @Override
    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        this.m_execTextField.setText(StringUtils.defaultString((String)data.get("EXECUTABLE")));
        this.m_autArgsTextField.setText(StringUtils.defaultString((String)data.get("AUT_ARGUMENTS")));
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
    }

    @Override
    protected void populateExpertArea(Map<String, String> data) {
    }

    @Override
    protected void populateAdvancedArea(Map<String, String> data) {
    }

    void handleExecButtonEvent(FileDialog fileDialog) {
        fileDialog.setText(Messages.AUTConfigComponentSelectExecutable);
        String filterPath = Utils.getLastDirPath();
        File path = new File(this.getConfigValue("EXECUTABLE"));
        String[] filterExe = new String[]{"*.exe"};
        fileDialog.setFilterExtensions(filterExe);
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), this.getConfigValue("EXECUTABLE"));
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            this.m_execTextField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue("EXECUTABLE", directory);
            executablePath = directory;
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    private void setWorkingDirToExecFilePath(String directory) {
        if ((StringUtils.isEmpty((String)this.getAutWorkingDirField().getText()) || this.isBasicMode()) && WinAutConfigComponent.isFilePathAbsolute(directory) && this.m_isExecFieldValid) {
            File wd = new File(directory);
            if ((wd = wd.getParentFile()) != null) {
                String execPath = wd.getAbsolutePath();
                this.getAutWorkingDirField().setText(execPath);
                this.putConfigValue("WORKING_DIR", execPath);
            }
        }
    }

    private static boolean isFilePathAbsolute(String filename) {
        File execFile = new File(filename);
        return execFile.isAbsolute();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        WidgetModifyListener modifyListener = this.getModifyListener();
        this.getServerCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_execButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_execTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.addModifyListener((ModifyListener)modifyListener);
    }

    @Override
    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        WidgetModifyListener modifyListener = this.getModifyListener();
        this.getServerCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_execButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_execTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.removeModifyListener((ModifyListener)modifyListener);
    }

    private WidgetSelectionListener getSelectionListener() {
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new WidgetSelectionListener();
        }
        return this.m_selectionListener;
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyExecTextField());
        this.addError(paramList, this.modifyAutParamFieldAction());
    }

    DialogStatusParameter modifyExecTextField() {
        DialogStatusParameter error = null;
        this.m_isExecFieldValid = true;
        isExecFieldEmpty = this.m_execTextField.getText().length() == 0;
        String filename = this.m_execTextField.getText();
        if (this.isValid((Widget)this.m_execTextField, true) && !isExecFieldEmpty) {
            if (this.checkLocalhostServer()) {
                String workingDirString;
                File file = new File(filename);
                if (!file.isAbsolute() && (workingDirString = this.getConfigValue("WORKING_DIR")) != null && workingDirString.length() != 0) {
                    filename = String.valueOf(workingDirString) + "/" + filename;
                    file = new File(filename);
                }
                try {
                    if (!file.isFile()) {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)file.getCanonicalPath()));
                    }
                }
                catch (IOException iOException) {
                    error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)filename));
                }
            }
        } else if (!isExecFieldEmpty) {
            error = this.createErrorStatus(Messages.AUTConfigComponentWrongExecutable);
        }
        if (error != null) {
            this.m_isExecFieldValid = false;
        }
        this.putConfigValue("EXECUTABLE", this.m_execTextField.getText());
        executablePath = filename;
        return error;
    }

    DialogStatusParameter modifyAutParamFieldAction() {
        String params = this.m_autArgsTextField.getText();
        this.putConfigValue("AUT_ARGUMENTS", params);
        return null;
    }

    public static boolean isExecFieldEmpty() {
        return isExecFieldEmpty;
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source.equals(WinAutConfigComponent.this.m_execTextField) || source.equals(WinAutConfigComponent.this.m_autArgsTextField)) {
                if (source.equals(WinAutConfigComponent.this.m_execTextField)) {
                    WinAutConfigComponent.this.checkAll();
                } else if (source.equals(WinAutConfigComponent.this.m_autArgsTextField)) {
                    WinAutConfigComponent.this.checkAll();
                }
            } else if (source.equals(WinAutConfigComponent.this.getServerCombo())) {
                WinAutConfigComponent.this.checkLocalhostServer();
                WinAutConfigComponent.this.checkAll();
            }
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(WinAutConfigComponent.this.m_execButton)) {
                WinAutConfigComponent.this.handleExecButtonEvent(new FileDialog(Plugin.getShell(), 81920));
                return;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

