/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTStartStateMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendAUTListOfSupportedComponentsCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(SendAUTListOfSupportedComponentsCommand.class);
    private SendAUTListOfSupportedComponentsMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (SendAUTListOfSupportedComponentsMessage)message;
    }

    public Message execute() {
        log.info("Entering method " + this.getClass().getName() + ".execute().");
        ArrayList componentIds = new ArrayList();
        AUTServerConfiguration.getInstance().setProfile(this.m_message.getProfile());
        for (Component component : this.m_message.getComponents()) {
            if (!component.isConcrete()) continue;
            ConcreteComponent concrete = (ConcreteComponent)component;
            try {
                String testerClass = concrete.getTesterClass();
                String componentClass = concrete.getComponentClass();
                if (StringUtils.isEmpty((String)testerClass) && StringUtils.isEmpty((String)componentClass)) continue;
                AUTServerConfiguration.getInstance().registerComponent(concrete);
            }
            catch (IllegalArgumentException e) {
                log.error("An error occurred while registering a component.", (Throwable)e);
            }
        }
        log.info("Exiting method " + this.getClass().getName() + ".execute().");
        return new AUTStartStateMessage(componentIds);
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

