/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.ServerShowDialogResponseMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDialogResultCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(ShowDialogResultCommand.class);
    private ServerShowDialogResponseMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (ServerShowDialogResponseMessage)message;
    }

    public Message execute() {
        AUTServer.getInstance().setObservingDialogOpen(this.m_message.isOpen());
        if (this.m_message.belongsToDialog()) {
            this.changeCheckModeState(this.m_message.getMode());
        } else {
            this.changeCheckModeState(AUTServer.getInstance().getMode());
        }
        return null;
    }

    private void changeCheckModeState(int mode) {
        ChangeAUTModeMessage msg = new ChangeAUTModeMessage();
        msg.setMode(mode);
        msg.setKey(AUTServerConfiguration.getInstance().getKey());
        msg.setKeyModifier(AUTServerConfiguration.getInstance().getKeyMod());
        msg.setKey2(AUTServerConfiguration.getInstance().getKey2());
        msg.setKey2Modifier(AUTServerConfiguration.getInstance().getKey2Mod());
        msg.setCheckModeKey(AUTServerConfiguration.getInstance().getCheckModeKey());
        msg.setCheckModeKeyModifier(AUTServerConfiguration.getInstance().getCheckModeKeyMod());
        msg.setCheckCompKey(AUTServerConfiguration.getInstance().getCheckCompKey());
        msg.setCheckCompKeyModifier(AUTServerConfiguration.getInstance().getCheckCompKeyMod());
        msg.setSingleLineTrigger(AUTServerConfiguration.getInstance().getSingleLineTrigger());
        msg.setMultiLineTrigger(AUTServerConfiguration.getInstance().getMultiLineTrigger());
        ChangeAUTModeCommand cmd = new ChangeAUTModeCommand();
        cmd.setMessage((Message)msg);
        try {
            Communicator clientCommunicator = AUTServer.getInstance().getCommunicator();
            if (clientCommunicator != null && clientCommunicator.getConnection() != null) {
                AUTServer.getInstance().getCommunicator().send(cmd.execute());
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

