/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.driver;

import java.awt.Robot;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jubula.rc.common.exception.RobotException;

public class EventFlusher {
    private static final String TOOLKIT_CLASS_NAME = "sun.awt.SunToolkit";
    private Method m_syncNativeQueue;
    private boolean m_isSyncNativeQueueZeroArguments;
    private final Robot m_robot;
    private final Long m_flushTimeout;
    private boolean m_isCompatibleToolkit = false;

    public EventFlusher(Robot robot, long flushTimeout) {
        this.m_robot = robot;
        this.m_flushTimeout = new Long(flushTimeout);
        this.m_syncNativeQueue = null;
        this.m_isSyncNativeQueueZeroArguments = true;
        try {
            Class<?> sunToolkitClass = Class.forName(TOOLKIT_CLASS_NAME);
            if (sunToolkitClass.isAssignableFrom(Toolkit.getDefaultToolkit().getClass())) {
                this.m_isCompatibleToolkit = true;
            }
            Method[] methods = sunToolkitClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                block8: {
                    Method method;
                    block10: {
                        List<Class<?>> parameterTypes;
                        block9: {
                            method = methods[i];
                            String name = method.getName();
                            if (!"syncNativeQueue".equals(name)) break block8;
                            parameterTypes = Arrays.asList(method.getParameterTypes());
                            if (!Arrays.asList(Long.class).equals(parameterTypes)) break block9;
                            this.m_isSyncNativeQueueZeroArguments = false;
                            break block10;
                        }
                        if (!parameterTypes.isEmpty() || this.m_syncNativeQueue != null) break block8;
                        this.m_isSyncNativeQueueZeroArguments = true;
                    }
                    this.m_syncNativeQueue = method;
                    this.m_syncNativeQueue.setAccessible(true);
                }
                ++i;
            }
        }
        catch (SecurityException e) {
            throw new RobotException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RobotException((Throwable)e);
        }
    }

    public void flush() {
        if (this.m_isCompatibleToolkit && this.m_syncNativeQueue != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            try {
                if (this.m_isSyncNativeQueueZeroArguments) {
                    this.m_syncNativeQueue.invoke((Object)toolkit, ArrayUtils.EMPTY_OBJECT_ARRAY);
                } else {
                    this.m_syncNativeQueue.invoke((Object)toolkit, this.m_flushTimeout);
                }
            }
            catch (IllegalArgumentException e) {
                throw new RobotException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RobotException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new RobotException((Throwable)e);
            }
        }
        this.m_robot.waitForIdle();
    }
}

