/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils;

import java.awt.AWTError;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtils {
    private static final String AWT_MULTI_CLICK_INTERVAL_PROPERTY_NAME = "awt.multiClickInterval";
    private static final String OS_NAME_KEY = "os.name";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_NAME_LOWER_CASE = OS_NAME.toLowerCase();
    private static final String OS_NAME_DOS = "dos";
    private static final String OS_NAME_SOLARIS = "sunos";
    private static final String OS_NAME_WIN = "windows";
    private static final String OS_NAME_MAC = "mac";
    private static final String ENV_CMD_WIN = "cmd.exe /c set";
    private static final String ENV_CMD_WIN9X = "command.com /c set";
    private static final String ENV_CMD_LINUX = "env";
    private static Logger log = LoggerFactory.getLogger(EnvironmentUtils.class);

    private EnvironmentUtils() {
    }

    public static boolean isWindowsOS() {
        return OS_NAME_LOWER_CASE.indexOf(OS_NAME_WIN) != -1;
    }

    public static boolean isDosOS() {
        return OS_NAME_LOWER_CASE.indexOf(OS_NAME_DOS) != -1;
    }

    public static boolean isWin9xOS() {
        return EnvironmentUtils.isWindowsOS() && (OS_NAME_LOWER_CASE.indexOf("95") != -1 || OS_NAME_LOWER_CASE.indexOf("98") != -1 || OS_NAME_LOWER_CASE.indexOf("ME") != -1);
    }

    public static boolean isSolarisOS() {
        return OS_NAME_LOWER_CASE.indexOf(OS_NAME_SOLARIS) != -1;
    }

    public static boolean isMacOS() {
        return OS_NAME_LOWER_CASE.indexOf(OS_NAME_MAC) != -1;
    }

    public static Properties getProcessEnvironment() {
        Properties env = new Properties();
        try {
            String consoleCmd = ENV_CMD_LINUX;
            if (EnvironmentUtils.isWin9xOS()) {
                consoleCmd = ENV_CMD_WIN9X;
            } else if (EnvironmentUtils.isWindowsOS()) {
                consoleCmd = ENV_CMD_WIN;
            }
            Process process = Runtime.getRuntime().exec(consoleCmd);
            InputStream in = process.getInputStream();
            byte[] buff = new byte[1024];
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(1024);
            int k = -1;
            while ((k = in.read(buff)) != -1) {
                ((OutputStream)outStream).write(buff, 0, k);
            }
            String envString = ((Object)outStream).toString();
            StringTokenizer tok = new StringTokenizer(envString, "\r\n");
            while (tok.hasMoreElements()) {
                String pair = tok.nextToken();
                String key = "";
                String value = "";
                StringTokenizer tok2 = new StringTokenizer(pair, "=");
                if (tok2.hasMoreElements()) {
                    key = tok2.nextToken();
                }
                if (tok2.hasMoreElements()) {
                    value = tok2.nextToken();
                }
                env.setProperty(key, value);
            }
        }
        catch (IOException ioe) {
            log.error("Error while getting process environmentin EnvironmentUtils.getProcessEnvironment() ", (Throwable)ioe);
        }
        return env;
    }

    public static Properties strArrayToProp(String[] strArray, String separator) {
        Properties prop = new Properties();
        String key = null;
        String value = null;
        String tmpStr = null;
        int i = 0;
        while (i < strArray.length) {
            tmpStr = strArray[i];
            int index = tmpStr.indexOf(separator);
            if (index > -1) {
                key = tmpStr.substring(0, index);
                value = tmpStr.substring(index + 1, tmpStr.length());
                prop.put(key, value);
            }
            ++i;
        }
        return prop;
    }

    public static Properties setEnvironment(Properties oldProp, Properties newProp) {
        Enumeration<Object> enum1 = newProp.keys();
        while (enum1.hasMoreElements()) {
            String key = enum1.nextElement().toString();
            String value = newProp.getProperty(key);
            oldProp.setProperty(key, value);
        }
        return oldProp;
    }

    public static String[] propToStrArray(Properties prop, String separator) {
        Enumeration<Object> enumVal = prop.elements();
        Enumeration<Object> enumKey = prop.keys();
        int keyCount = prop.size();
        String[] strArray = new String[keyCount];
        int i = 0;
        while (enumKey.hasMoreElements()) {
            strArray[i++] = enumKey.nextElement().toString();
        }
        i = 0;
        while (enumVal.hasMoreElements()) {
            strArray[i] = String.valueOf(strArray[i]) + separator + enumVal.nextElement().toString();
            ++i;
        }
        return strArray;
    }

    public static String[] strToStrArray(String str, String separators) {
        StringTokenizer tokenizer = new StringTokenizer(str, separators);
        int count = tokenizer.countTokens();
        String[] strArray = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            strArray[i++] = tokenizer.nextToken().trim();
        }
        return strArray;
    }

    public static int getPlatformDoubleClickSpeed() {
        int doubleClickSpeed = -1;
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (tk != null) {
                Object value = tk.getDesktopProperty(AWT_MULTI_CLICK_INTERVAL_PROPERTY_NAME);
                doubleClickSpeed = Integer.valueOf(String.valueOf(value));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (AWTError aWTError) {}
        return doubleClickSpeed;
    }

    public static int getAUTAgentEnvironmentPortNo() {
        int port = -1;
        String portStr = EnvironmentUtils.getProcessEnvironment().getProperty("TEST_AUT_AGENT_PORT");
        if (portStr != null && !portStr.trim().equals("")) {
            try {
                port = Integer.valueOf(portStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return port;
    }

    public static String getProcessOrSystemProperty(String key) {
        String value = EnvironmentUtils.getProcessEnvironment().getProperty(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }
}

