/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils;

import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtil.class);

    private NetUtil() {
    }

    public static int getFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LOG.error("Error occurred while searching for available port. Invalid port will be returned.", (Throwable)e);
            return -1;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.error("Error occurred while searching for available port.", (Throwable)e);
                }
            }
        }
    }
}

