/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import java.awt.Toolkit;
import javax.swing.JComponent;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IWidgetComponent;
import org.eclipse.jubula.rc.swing.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swing.tester.JMenuBarTester;
import org.eclipse.jubula.rc.swing.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.rc.swing.tester.util.EventListener;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class JComponentAdapter
extends AbstractComponentAdapter
implements IWidgetComponent {
    private JComponent m_component;

    public JComponentAdapter(Object objectToAdapt) {
        this.m_component = (JComponent)objectToAdapt;
    }

    public Object getRealComponent() {
        return this.m_component;
    }

    protected IRobot getRobot() throws RobotException {
        return this.getRobotFactory().getRobot();
    }

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public String getPropteryValue(final String propertyname) {
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", new IRunnable(){

            public Object run() throws StepExecutionException {
                try {
                    return JComponentAdapter.this.getRobot().getPropertyValue(JComponentAdapter.this.getRealComponent(), propertyname);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    public boolean isShowing() {
        Boolean returnvalue = (Boolean)this.getEventThreadQueuer().invokeAndWait("isShowing", new IRunnable(){

            public Object run() {
                return JComponentAdapter.this.m_component.isShowing() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return returnvalue;
    }

    public boolean hasFocus() {
        Boolean returnvalue = (Boolean)this.getEventThreadQueuer().invokeAndWait("hasFocus", new IRunnable(){

            public Object run() {
                return JComponentAdapter.this.m_component.hasFocus() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return returnvalue;
    }

    public boolean isEnabled() {
        Boolean returnvalue = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", new IRunnable(){

            public Object run() {
                return JComponentAdapter.this.m_component.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return returnvalue;
    }

    public AbstractMenuTester showPopup(final int button) {
        final JComponent component = this.m_component;
        Runnable showPopup = new Runnable(){

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(component.getClass().getClassLoader());
                if (JComponentAdapter.this.getRobot().isMouseInComponent(component)) {
                    JComponentAdapter.this.getRobot().clickAtCurrentPosition(component, 1, button);
                } else {
                    JComponentAdapter.this.getRobot().click(component, null, ClickOptions.create().setClickCount(1).setMouseButton(button));
                }
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        };
        return this.showPopup(showPopup);
    }

    public AbstractMenuTester showPopup(final int xPos, final String xUnits, final int yPos, final String yUnits, final int button) throws StepExecutionException {
        final JComponent component = this.m_component;
        Runnable showPopup = new Runnable(){

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                boolean isAbsoluteCoordinatesX = xUnits.equalsIgnoreCase("Pixel");
                boolean isAbsoluteCoordinatesY = yUnits.equalsIgnoreCase("Pixel");
                JComponentAdapter.this.getRobot().click(component, null, ClickOptions.create().setMouseButton(button), xPos, isAbsoluteCoordinatesX, yPos, isAbsoluteCoordinatesY);
            }
        };
        return this.showPopup(showPopup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMenuTester showPopup(Runnable showPopupOperation) {
        TesterUtil.PopupShownCondition cond = new TesterUtil.PopupShownCondition();
        EventLock lock = new EventLock();
        EventListener listener = new EventListener(lock, cond);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 2L);
        showPopupOperation.run();
        EventLock eventLock = lock;
        synchronized (eventLock) {
            block10: {
                try {
                    try {
                        long timeout = 10000L;
                        long done = System.currentTimeMillis() + timeout;
                        while (!(lock.isReleased() && cond.getPopup() != null && cond.getPopup().isShowing() || timeout <= 0L)) {
                            lock.wait(timeout);
                            long now = System.currentTimeMillis();
                            timeout = done - now;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
                    throw throwable;
                }
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        }
        if (!lock.isReleased() || cond.getPopup() == null || !cond.getPopup().isShowing()) {
            throw new StepExecutionException("popup not shown", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
        JMenuBarTester menuCAPs = new JMenuBarTester();
        menuCAPs.setComponent(cond.getPopup());
        return menuCAPs;
    }

    public void showToolTip(String text, int textSize, int timePerWord, int windowWidth) {
        throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.UnsupportedOperation"), EventFactory.createActionError((String)"TestErrorEvent.UnsupportedOperation"));
    }

    public void rcDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        IRobot robot = this.getRobot();
        this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
        TesterUtil.pressOrReleaseModifiers(modifier, true);
        robot.mousePress(null, null, mouseButton);
    }

    public void rcDrop(int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        String modifier = dndHelper.getModifier();
        int mouseButton = dndHelper.getMouseButton();
        try {
            this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
            TimeUtil.delay((long)delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, mouseButton);
            TesterUtil.pressOrReleaseModifiers(modifier, false);
        }
    }

    private void clickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click((Object)this.m_component, null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase("Pixel"), yPos, yUnits.equalsIgnoreCase("Pixel"));
    }

    public int getKeyCode(String mod) {
        return KeyCodeConverter.getKeyCode(mod);
    }
}

