/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.util;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.adaptable.ITextRendererAdapter;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.swing.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swing.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swing.tester.util.EventListener;
import org.eclipse.jubula.rc.swing.tester.util.HighLighter;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class TesterUtil {
    public static final String RENDERER_FALLBACK_TEXT_GETTER_METHOD_1 = "getTestableText";
    public static final String RENDERER_FALLBACK_TEXT_GETTER_METHOD_2 = "getText";
    private static AutServerLogger log = new AutServerLogger(TesterUtil.class);
    private static final HighLighter HIGHLIGHTER = new HighLighter();
    private static IRobotFactory robotFactory;

    private TesterUtil() {
    }

    public static IRobot getRobot() {
        return AUTServer.getInstance().getRobot();
    }

    protected static IRobotFactory getRobotFactory() {
        if (robotFactory == null) {
            robotFactory = new RobotFactoryConfig().getRobotFactory();
        }
        return robotFactory;
    }

    protected static IEventThreadQueuer getEventThreadQueuer() {
        return TesterUtil.getRobotFactory().getEventThreadQueuer();
    }

    public static void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = TesterUtil.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    public static String getRenderedText(final Component renderer, boolean queueInEventThread) throws StepExecutionException {
        if (queueInEventThread) {
            return (String)TesterUtil.getEventThreadQueuer().invokeAndWait("getRenderedText", new IRunnable(){

                public Object run() {
                    return TesterUtil.getRenderedText(renderer);
                }
            });
        }
        return TesterUtil.getRenderedText(renderer);
    }

    public static String getRenderedText(Component renderer) throws StepExecutionException {
        String renderedText = TesterUtil.resolveRenderedText(renderer);
        if (renderedText != null) {
            return renderedText;
        }
        throw new StepExecutionException("Renderer not supported: " + renderer.getClass(), EventFactory.createActionError((String)"TestErrorEvent.RendererNotSupported"));
    }

    private static String resolveRenderedText(Component renderer) {
        if (renderer instanceof JLabel) {
            return ((JLabel)renderer).getText();
        }
        if (renderer instanceof JToggleButton) {
            return ((JToggleButton)renderer).isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        if (renderer instanceof AbstractButton) {
            return ((AbstractButton)renderer).getText();
        }
        if (renderer instanceof JTextComponent) {
            return ((JTextComponent)renderer).getText();
        }
        ITextRendererAdapter textRendererAdapter = (ITextRendererAdapter)AdapterFactoryRegistry.getInstance().getAdapter(ITextRendererAdapter.class, (Object)renderer);
        if (textRendererAdapter != null) {
            return textRendererAdapter.getText();
        }
        if (renderer != null) {
            String[] methodNames = new String[]{RENDERER_FALLBACK_TEXT_GETTER_METHOD_1, RENDERER_FALLBACK_TEXT_GETTER_METHOD_2};
            int i = 0;
            while (i < methodNames.length) {
                String text = TesterUtil.getTextFromComponent(renderer, methodNames[i]);
                if (text != null) {
                    return text;
                }
                ++i;
            }
        }
        return null;
    }

    private static String getTextFromComponent(Object obj, String getterName) {
        String text = null;
        try {
            Method getter = null;
            Class<?> objClass = obj.getClass();
            try {
                getter = objClass.getDeclaredMethod(getterName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {}
            if (getter == null) {
                try {
                    getter = objClass.getMethod(getterName, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return text;
                }
                catch (SecurityException securityException) {
                    return text;
                }
            }
            getter.setAccessible(true);
            Object returnValue = getter.invoke(obj, null);
            if (returnValue instanceof String) {
                text = (String)returnValue;
            }
            return text;
        }
        catch (SecurityException securityException) {
            return text;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return text;
        }
        catch (IllegalAccessException illegalAccessException) {
            return text;
        }
        catch (InvocationTargetException invocationTargetException) {
            return text;
        }
    }

    public static void highLight(Component component, Color border) {
        try {
            final Component comp = component;
            final Color col = border;
            TesterUtil.getEventThreadQueuer().invokeLater("highLight", new Runnable(){

                public void run() {
                    HIGHLIGHTER.highLight(comp, col);
                }
            });
        }
        catch (StepExecutionException bsee) {
            log.error((Object)bsee);
        }
    }

    public static void lowLight(Component component) {
        try {
            final Component comp = component;
            TesterUtil.getEventThreadQueuer().invokeLater("lowLight", new Runnable(){

                public void run() {
                    HIGHLIGHTER.lowLight(comp);
                }
            });
        }
        catch (StepExecutionException bsee) {
            log.error((Object)bsee);
        }
    }

    public static class PopupShownCondition
    implements EventListener.Condition {
        private JPopupMenu m_popup = null;

        public JPopupMenu getPopup() {
            return this.m_popup;
        }

        public boolean isTrue(AWTEvent event) {
            if (event.getID() != 300) {
                return false;
            }
            ContainerEvent ce = (ContainerEvent)event;
            if (ce.getChild() instanceof JPopupMenu) {
                this.m_popup = (JPopupMenu)ce.getChild();
                return true;
            }
            if (ce.getChild() instanceof Container) {
                Container popupContainer = (Container)ce.getChild();
                int length = popupContainer.getComponents().length;
                int i = 0;
                while (i < length) {
                    if (popupContainer.getComponents()[i] instanceof JPopupMenu) {
                        this.m_popup = (JPopupMenu)popupContainer.getComponents()[i];
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

