/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.bp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.model.CommentEntry;
import org.eclipse.jubula.client.alm.mylyn.core.utils.ALMAccess;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.businessprocess.TestresultSummaryBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IALMReportingProperties;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TestResultNodeTraverser;
import org.eclipse.osgi.util.NLS;

public class CommentReporter
implements DataEventDispatcher.ITestresultSummaryEventListener {
    private static CommentReporter instance;
    private IProgressConsole m_console;
    private IALMReportingProperties m_reportProps = null;

    private CommentReporter() {
        DataEventDispatcher.getInstance().addTestresultSummaryEventListener((DataEventDispatcher.ITestresultSummaryEventListener)this);
    }

    public static CommentReporter getInstance() {
        if (instance == null) {
            instance = new CommentReporter();
        }
        return instance;
    }

    private IStatus processResultTree(IProgressMonitor monitor, boolean reportSuccess, boolean reportFailure, ITestResultSummaryPO summary, TestResultNode rootResultNode) {
        HashMap<String, List<CommentEntry>> taskIdToComment = new HashMap<String, List<CommentEntry>>();
        CommentEntryCreationOperation operation = new CommentEntryCreationOperation(taskIdToComment, reportFailure, reportSuccess, this.m_reportProps.getDashboardURL(), summary.getId().toString());
        TestResultNodeTraverser traverser = new TestResultNodeTraverser(rootResultNode, (ITreeNodeOperation)operation);
        traverser.traverse();
        IStatus reportStatus = this.reportToALM(monitor, taskIdToComment);
        if (reportStatus.isOK()) {
            TestresultSummaryBP.getInstance().setALMReportStatus(summary, ITestResultSummaryPO.AlmReportStatus.REPORTED);
        }
        return reportStatus;
    }

    private IStatus reportToALM(IProgressMonitor monitor, Map<String, List<CommentEntry>> taskIdToComment) {
        String repoLabel = this.m_reportProps.getALMRepositoryName();
        boolean failed = false;
        Set<String> taskIds = taskIdToComment.keySet();
        int taskAmount = taskIds.size();
        IProgressConsole c = this.getConsole();
        if (taskAmount > 0) {
            String out = NLS.bind((String)Messages.ReportToALMJob, (Object)taskAmount, (Object)repoLabel);
            monitor.beginTask(out, taskAmount);
            c.writeLine(out);
            int successCount = 0;
            int overallCommentCount = 0;
            for (String taskId : taskIds) {
                List<CommentEntry> comments = taskIdToComment.get(taskId);
                int commentAmount = comments.size();
                if (commentAmount > 1) {
                    c.writeLine(NLS.bind((String)Messages.ReportingResults, (Object)commentAmount, (Object)taskId));
                } else {
                    c.writeLine(NLS.bind((String)Messages.ReportingResult, (Object)taskId));
                }
                boolean succeeded = ALMAccess.createComment(repoLabel, taskId, comments, monitor);
                if (!succeeded) {
                    failed = true;
                    c.writeErrorLine(NLS.bind((String)Messages.ReportingTaskFailed, (Object)taskId));
                } else {
                    ++successCount;
                    overallCommentCount += commentAmount;
                }
                monitor.worked(1);
            }
            c.writeLine(NLS.bind((String)Messages.ReportToALMJobDone, (Object[])new Integer[]{overallCommentCount, successCount, taskAmount}));
            monitor.done();
        } else {
            c.writeLine(Messages.NothingToReport);
        }
        if (!failed) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", "Reporting comments performed with errors...");
    }

    private IProgressConsole getConsole() {
        return this.m_console;
    }

    public void setConsole(IProgressConsole console) {
        this.m_console = console;
    }

    public void handleTestresultSummaryChanged(ITestResultSummaryPO summary, DataEventDispatcher.DataState state) {
        if (state != DataEventDispatcher.DataState.Added) {
            return;
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        TestResult resultTestModel = TestResultBP.getInstance().getResultTestModel();
        TestResultNode rootResultNode = resultTestModel.getRootResultNode();
        Job job = this.gatherInformationAndCreateReportToALMJob(summary, (IALMReportingProperties)project.getProjectProperties(), rootResultNode);
        if (job != null) {
            job.schedule();
        }
    }

    public Job gatherInformationAndCreateReportToALMJob(final ITestResultSummaryPO summary, IALMReportingProperties properties, final TestResultNode rootResultNode) {
        this.m_reportProps = properties;
        final boolean reportSuccess = properties.getIsReportOnSuccess();
        final boolean reportFailure = properties.getIsReportOnFailure();
        final String almRepositoryName = properties.getALMRepositoryName();
        if (!StringUtils.isBlank((String)almRepositoryName) && (reportSuccess || reportFailure)) {
            Job reportToALMOperation = new Job(NLS.bind((String)Messages.ReportToALMJobName, (Object)almRepositoryName)){

                protected IStatus run(IProgressMonitor monitor) {
                    CommentReporter.this.getConsole().writeLine(NLS.bind((String)Messages.TaskRepositoryConnectionTest, (Object)almRepositoryName));
                    IStatus connectionStatus = ALMAccess.testConnection(almRepositoryName);
                    if (connectionStatus.isOK()) {
                        CommentReporter.this.getConsole().writeLine(NLS.bind((String)Messages.TaskRepositoryConnectionTestSucceeded, (Object)almRepositoryName));
                        return CommentReporter.this.processResultTree(monitor, reportSuccess, reportFailure, summary, rootResultNode);
                    }
                    CommentReporter.this.getConsole().writeErrorLine(NLS.bind((String)Messages.TaskRepositoryConnectionTestFailed, (Object)connectionStatus.getMessage()));
                    return connectionStatus;
                }
            };
            return reportToALMOperation;
        }
        return null;
    }

    private static class CommentEntryCreationOperation
    implements ITreeNodeOperation<TestResultNode> {
        private Map<String, List<CommentEntry>> m_taskIdToComment;
        private final boolean m_reportFailure;
        private final boolean m_reportSuccess;
        private String m_dashboardURL;
        private String m_summaryIdString;
        private long m_nodeCount = 0L;

        public CommentEntryCreationOperation(Map<String, List<CommentEntry>> taskIdToComment, boolean reportFailure, boolean reportSuccess, String dashboardURL, String summaryId) {
            this.m_taskIdToComment = taskIdToComment;
            this.m_reportFailure = reportFailure;
            this.m_reportSuccess = reportSuccess;
            this.m_dashboardURL = dashboardURL;
            this.m_summaryIdString = summaryId;
        }

        public boolean operate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode resultNode, boolean alreadyVisited) {
            boolean writeCommentForNode;
            ++this.m_nodeCount;
            boolean didNodePass = CommentEntry.hasPassed(resultNode.getStatus());
            String taskIdforNode = resultNode.getTaskId();
            boolean hasTaskId = taskIdforNode != null;
            boolean bl = writeCommentForNode = hasTaskId && (this.m_reportSuccess && didNodePass || this.m_reportFailure && !didNodePass);
            if (writeCommentForNode) {
                CommentEntry c = new CommentEntry(resultNode, this.m_dashboardURL, this.m_summaryIdString, this.m_nodeCount);
                List<CommentEntry> comments = this.m_taskIdToComment.get(taskIdforNode);
                if (comments != null) {
                    comments.add(c);
                } else {
                    LinkedList<CommentEntry> cs = new LinkedList<CommentEntry>();
                    cs.add(c);
                    this.m_taskIdToComment.put(taskIdforNode, cs);
                }
            }
            return true;
        }

        public void postOperate(ITreeTraverserContext<TestResultNode> ctx, TestResultNode parent, TestResultNode node, boolean alreadyVisited) {
        }
    }
}

