/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.contributionitems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jubula.client.analyze.ExtensionRegistry;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.Category;
import org.eclipse.jubula.client.analyze.ui.internal.helper.ContextHelper;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ContextMenuContributionItem
extends CompoundContributionItem {
    private String m_label;
    private String m_currentID;

    public ContextMenuContributionItem() {
    }

    public ContextMenuContributionItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        for (Map.Entry e : ExtensionRegistry.getCategory().entrySet()) {
            Category c = (Category)e.getValue();
            this.createMenuEntry(c, contributionItems, null);
        }
        return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
    }

    private void createMenuEntry(Category c, List<IContributionItem> contributionItems, MenuManager mm) {
        if (c.getParentCatID() == null || c.getParentCatID().length() == 0) {
            contributionItems.add((IContributionItem)this.createSubMenuEntry(c));
        } else {
            for (Map.Entry e : ExtensionRegistry.getCategory().entrySet()) {
                Category cat = (Category)e.getValue();
                if (!cat.getID().equals(c.getParentCatID())) continue;
                MenuManager mgr = new MenuManager(cat.getName());
                mgr.add((IContributionItem)this.createSubMenuEntry(c));
                contributionItems.add((IContributionItem)mgr);
                contributionItems.add((IContributionItem)new Separator());
            }
        }
    }

    private MenuManager createSubMenuEntry(Category c) {
        String command = "org.eclipse.jubula.client.analyze.ui.RunSelection";
        String idParam = "org.eclipse.jubula.client.analyze.ui.RunSelection.IDParam";
        MenuManager mgr = new MenuManager(c.getName());
        for (Map.Entry f : ExtensionRegistry.getAnalyze().entrySet()) {
            Analyze analyze = (Analyze)f.getValue();
            if (!analyze.getCategoryID().equals(c.getID()) || !ContextHelper.isEnabled(analyze)) continue;
            this.m_label = analyze.getName();
            this.m_currentID = analyze.getID();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(idParam, this.m_currentID);
            IContributionItem item = CommandHelper.createContributionItem((String)command, params, (String)this.m_label, (int)8);
            mgr.add(item);
        }
        return mgr;
    }
}

