/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.AbstractComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectComponentNameMapper
extends AbstractComponentNameMapper {
    public ProjectComponentNameMapper(IWritableComponentNameCache componentNameCache, IProjectPO project) {
        super(componentNameCache, project);
    }

    @Override
    protected IProjectPO getContext() {
        return (IProjectPO)super.getContext();
    }

    @Override
    public Set<String> getUsedTypes(String compNameGuid) {
        ComponentTypeCollector operation = new ComponentTypeCollector(compNameGuid, this.getCompNameCache());
        new TreeTraverser(this.getContext(), operation, true).traverse(true);
        HashSet<String> usedTypes = new HashSet<String>(operation.getTypes());
        for (IAUTMainPO aut : this.getContext().getAutMainList()) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                if (!assoc.getLogicalNames().contains(compNameGuid) || assoc.getTechnicalName() == null) continue;
                usedTypes.add(assoc.getTechnicalName().getSupportedClassName());
            }
        }
        return usedTypes;
    }

    @Override
    public void handleExistingNames(Map<String, String> guidToCompNameMap) {
        ExistingCompTypeHandler operation = new ExistingCompTypeHandler(guidToCompNameMap);
        new TreeTraverser(this.getContext(), operation, true).traverse(true);
        for (IAUTMainPO aut : this.getContext().getAutMainList()) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                HashSet guidIntersection = new HashSet();
                guidIntersection.retainAll(assoc.getLogicalNames());
                for (String guid : guidIntersection) {
                    assoc.removeLogicalName(guid);
                    assoc.addLogicalName(guidToCompNameMap.get(guid));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentTypeCollector
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private String m_compNameGuid;
        private IWritableComponentNameCache m_compNameCache;
        private Set<String> m_typeSet = new HashSet<String>();

        public ComponentTypeCollector(String componentNameGuid, IWritableComponentNameCache componentNameCache) {
            this.m_compNameGuid = componentNameGuid;
            this.m_compNameCache = componentNameCache;
        }

        public Set<String> getTypes() {
            return this.m_typeSet;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            ICapPO capPo;
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                    if (!this.m_compNameGuid.equals(pair.getSecondName())) continue;
                    this.m_typeSet.add(this.m_compNameCache.getCompNamePo(pair.getFirstName()).getComponentType());
                }
            } else if (node instanceof ICapPO && this.m_compNameGuid.equals((capPo = (ICapPO)node).getComponentName())) {
                this.m_typeSet.add(capPo.getComponentType());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExistingCompTypeHandler
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private Map<String, String> m_guidToCompNameMap;

        public ExistingCompTypeHandler(Map<String, String> guidToCompNameMap) {
            this.m_guidToCompNameMap = guidToCompNameMap;
        }

        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            ICapPO capPo;
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTc = (IExecTestCasePO)node;
                for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                    if (this.m_guidToCompNameMap.containsKey(pair.getFirstName())) {
                        pair.setFirstName(this.m_guidToCompNameMap.get(pair.getFirstName()));
                    }
                    if (!this.m_guidToCompNameMap.containsKey(pair.getSecondName())) continue;
                    pair.setSecondName(this.m_guidToCompNameMap.get(pair.getSecondName()));
                }
            } else if (node instanceof ICapPO && this.m_guidToCompNameMap.containsKey((capPo = (ICapPO)node).getComponentName())) {
                capPo.setComponentName(this.m_guidToCompNameMap.get(capPo.getComponentName()));
            }
            return true;
        }
    }
}

