/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.ActiveProjectSourceProvider;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleTCBTracker {
    private static MultipleTCBTracker instance = null;
    private List<TestCaseBrowser> m_tcb = new ArrayList<TestCaseBrowser>();
    private TestCaseBrowser m_mainTCB = null;
    private ActiveProjectSourceProvider m_provider = null;

    private MultipleTCBTracker() {
    }

    public static MultipleTCBTracker getInstance() {
        if (instance == null) {
            instance = new MultipleTCBTracker();
        }
        return instance;
    }

    public void addTCB(TestCaseBrowser testCaseBrowser) {
        if (testCaseBrowser != null) {
            this.m_tcb.add(testCaseBrowser);
            this.setMainTCB(this.getOpenTCBs().get(0));
            this.fireStateChanged();
        }
    }

    public void removeTCB(TestCaseBrowser testCaseBrowser) {
        this.m_tcb.remove((Object)testCaseBrowser);
        this.setMainTCB(this.getOpenTCBs().size() > 0 ? this.getOpenTCBs().get(0) : null);
        this.fireStateChanged();
    }

    public List<TestCaseBrowser> getOpenTCBs() {
        ArrayList<TestCaseBrowser> tcbs = new ArrayList<TestCaseBrowser>();
        for (TestCaseBrowser tcb : this.m_tcb) {
            tcbs.add(tcb);
        }
        return tcbs;
    }

    public TestCaseBrowser getMainTCB() {
        if (this.m_mainTCB == null) {
            this.m_mainTCB = this.getOpenTCBs().size() > 0 ? this.getOpenTCBs().get(0) : null;
        }
        return this.m_mainTCB;
    }

    public void setMainTCB(TestCaseBrowser mainTCB) {
        int tcbCount;
        TestCaseBrowser oldMainTCB = this.m_mainTCB;
        TestCaseBrowser newMainTCB = mainTCB;
        this.m_mainTCB = mainTCB;
        if (newMainTCB == null) {
            return;
        }
        String tcbTitle = Messages.TestCaseBrowser;
        String mainTcbTitle = String.valueOf(Messages.TestCaseBrowserMainPrefix) + tcbTitle;
        if (oldMainTCB != null) {
            oldMainTCB.setViewTitle(tcbTitle);
        }
        if ((tcbCount = this.getOpenTCBs().size()) == 1) {
            newMainTCB.setViewTitle(tcbTitle);
        } else if (tcbCount > 1) {
            newMainTCB.setViewTitle(mainTcbTitle);
        }
    }

    private void fireStateChanged() {
        if (this.m_provider != null) {
            this.m_provider.handleProjectLoaded();
        }
    }

    public void setProvider(ActiveProjectSourceProvider provider) {
        this.m_provider = provider;
    }
}

