/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.Locale;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.controllers.propertysources.IPropertyController;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertySource<GUINODE_TYPE>
extends org.eclipse.jubula.client.ui.controllers.propertysources.AbstractPropertySource {
    public static final Image DEFAULT_IMAGE = null;
    public static final Image DEPRECATED_IMAGE = IconConstants.DEPRECATED_IMAGE;
    public static final Image READONLY_IMAGE = IconConstants.READ_ONLY_IMAGE;
    public static final Image INCOMPL_DATA_IMAGE = IconConstants.INCOMPLETE_DATA_IMAGE;
    public static final Image WARNING_IMAGE = IconConstants.WARNING_IMAGE;
    private GUINODE_TYPE m_guiNode;

    public AbstractPropertySource(GUINODE_TYPE guiNode) {
        this.m_guiNode = guiNode;
    }

    protected IPropertyDescriptor getPropertyDescriptorById(IPropertyController id) {
        for (IPropertyDescriptor descriptor : this.getPropertyDescriptorList()) {
            if (id != descriptor.getId()) continue;
            return descriptor;
        }
        return null;
    }

    public Object getEditableValue() {
        return this;
    }

    public void resetPropertyValue(Object id) {
    }

    protected void checkEntrySets(IParamNodePO nodePo) {
        Locale locale = WorkingLanguageBP.getInstance().getWorkingLanguage();
        boolean bool = nodePo.isTestDataComplete(locale);
        CompletenessGuard.setCompletenessTestData((INodePO)nodePo, (Locale)locale, (boolean)bool);
    }

    protected GUINODE_TYPE getGuiNode() {
        return this.m_guiNode;
    }

    public static abstract class AbstractPropertyController
    implements IPropertyController {
        private AbstractNodePropertySource m_propertySource;

        public AbstractPropertyController(AbstractNodePropertySource s) {
            this.setPropertySource(s);
        }

        public AbstractPropertyController() {
        }

        public Image getImage(Object value) {
            if (value == null || "".equals(value)) {
                return INCOMPL_DATA_IMAGE;
            }
            return DEFAULT_IMAGE;
        }

        public Image getImage() {
            return this.getImage(this.getProperty());
        }

        public AbstractNodePropertySource getPropertySource() {
            return this.m_propertySource;
        }

        public void setPropertySource(AbstractNodePropertySource propertySource) {
            this.m_propertySource = propertySource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DummyController
    extends AbstractPropertyController {
        protected DummyController() {
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }
}

