/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ProblemsBP;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static Locale getDefaultLocale() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project.getDefaultLanguage() != null) {
            return project.getDefaultLanguage();
        }
        return Locale.getDefault();
    }

    public static boolean isLocalhost() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        String serverPort = prefStore.getString("AUT_AGENT_SETTINGS_KEY");
        String server = serverPort.split(":")[0];
        return server.equals(Messages.UtilsLocalhost1) || server.equals(Messages.UtilsLocalhost3) || server.startsWith(Messages.UtilsLocalhost2);
    }

    private static IPerspectiveDescriptor getActivePerspective(IWorkbenchPage activePage) {
        if (activePage != null) {
            return activePage.getPerspective();
        }
        return null;
    }

    public static boolean openPerspective(String perspectiveID) {
        IWorkbenchWindow activeWindow;
        IWorkbench worbench;
        block11: {
            MessageDialogWithToggle dialog;
            block10: {
                IPreferenceStore preferenceStore;
                block9: {
                    int value;
                    block8: {
                        block7: {
                            worbench = PlatformUI.getWorkbench();
                            activeWindow = worbench.getActiveWorkbenchWindow();
                            try {
                                IPerspectiveDescriptor activePerspective = Utils.getActivePerspective(activeWindow.getActivePage());
                                if (activePerspective == null || !activePerspective.getId().equals(perspectiveID)) break block7;
                                return true;
                            }
                            catch (WorkbenchException e) {
                                StringBuilder msg = new StringBuilder();
                                msg.append(Messages.CannotOpenThePerspective).append(":").append(" ").append(perspectiveID).append("(").append((Object)e).append(")").append(".");
                                log.error(msg.toString());
                                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_PERSPECTIVE);
                                return false;
                            }
                        }
                        preferenceStore = Plugin.getDefault().getPreferenceStore();
                        value = preferenceStore.getInt("PERSP_CHANGE_KEY");
                        if (value != 0) break block8;
                        worbench.showPerspective(perspectiveID, activeWindow);
                        return true;
                    }
                    if (value != 1) break block9;
                    return true;
                }
                String perspectiveName = "";
                perspectiveName = perspectiveID.equals("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective") ? Messages.UtilsSpecPerspective : Messages.UtilsExecPerspective;
                dialog = new MessageDialogWithToggle(Plugin.getShell(), Messages.UtilsTitle, null, NLS.bind((String)Messages.UtilsQuestion, (Object)perspectiveName), 3, new String[]{Messages.UtilsYes, Messages.UtilsNo}, 0, Messages.UtilsRemember, false){

                    protected void buttonPressed(int buttonId) {
                        super.buttonPressed(buttonId);
                        preferenceStore.setValue("REMEMBER_KEY", this.getToggleState());
                        int val = 2;
                        if (this.getToggleState() && this.getReturnCode() == 257) {
                            val = 1;
                        } else if (this.getToggleState() && this.getReturnCode() == 256) {
                            val = 0;
                        }
                        preferenceStore.setValue("PERSP_CHANGE_KEY", val);
                    }
                };
                dialog.create();
                DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                dialog.open();
                if (dialog.getReturnCode() != 257) break block10;
                return true;
            }
            if (dialog.getReturnCode() != -1) break block11;
            return false;
        }
        worbench.showPerspective(perspectiveID, activeWindow);
        return true;
    }

    public static List<Object> getExpandedTreeItems(TreeViewer tv) {
        Object[] expandedElems = tv.getExpandedElements();
        return new ArrayList<Object>(Arrays.asList(expandedElems));
    }

    public static String getLastDirPath() {
        return Plugin.getDefault().getPreferenceStore().getString("START_BROWSE_PATH_KEY");
    }

    public static void storeLastDirPath(String path) {
        Plugin.getDefault().getPreferenceStore().setValue("START_BROWSE_PATH_KEY", path);
    }

    public static List<String> getAvailableLanguages() {
        Languages langUtil = Languages.getInstance();
        ArrayList<String> list = new ArrayList<String>();
        for (Locale locale : langUtil.getSuppLangList()) {
            list.add(langUtil.getDisplayString(locale));
        }
        return list;
    }

    public static void clearClient() {
        Utils.clearClient(false);
    }

    public static void clearClient(final boolean alsoProjectIndependent) {
        final DataEventDispatcher ded = DataEventDispatcher.getInstance();
        TestExecution.getInstance().stopExecution();
        GeneralStorage gs = GeneralStorage.getInstance();
        if (gs != null && Persistor.instance() != null) {
            IProjectPO currProj = gs.getProject();
            if (currProj != null) {
                gs.setProject(null);
            }
            gs.reset();
        }
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                ProblemsBP problemsBP = ProblemsBP.getInstance();
                problemsBP.clearOldProblems();
                problemsBP.cleanupProblems();
                TestExecutionContributor.getInstance().getClientTest().resetToTesting();
                ded.fireRecordModeStateChanged(DataEventDispatcher.RecordModeState.notRunning);
                ded.fireOMStateChanged(DataEventDispatcher.OMState.notRunning);
                ded.fireProjectStateChanged(DataEventDispatcher.ProjectState.closed);
                Plugin.closeAllOpenedJubulaEditors(alsoProjectIndependent);
                ded.fireTestresultChanged(DataEventDispatcher.TestresultState.Clear);
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.rcp.views.TestResultTreeView");
                for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
                    tcb.getTreeViewer().setInput(null);
                }
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser");
                Utils.setTreeViewerInputNull("org.eclipse.jubula.client.ui.rcp.views.ComponentNameBrowser");
                Utils.clearAnalyzeResultPage();
            }
        });
        ded.fireProjectLoadedListener((IProgressMonitor)new NullProgressMonitor());
    }

    private static void clearAnalyzeResultPage() {
        ISearchQuery[] querry = NewSearchUI.getQueries();
        int i = 0;
        while (i < querry.length) {
            NewSearchUI.removeQuery((ISearchQuery)querry[i]);
            ++i;
        }
    }

    private static void setTreeViewerInputNull(String viewID) {
        IViewPart view = Plugin.getView(viewID);
        if (view instanceof ITreeViewerContainer) {
            ((ITreeViewerContainer)view).getTreeViewer().setInput(null);
        }
    }

    public static IEditorPart getEditorByPO(IPersistentObject po) {
        IEditorReference editorRef = Utils.getEditorRefByPO(po);
        if (editorRef != null) {
            return editorRef.getEditor(false);
        }
        return null;
    }

    public static IEditorReference getEditorRefByPO(IPersistentObject po) {
        for (IEditorReference editorRef : Plugin.getAllEditors()) {
            PersistableEditorInput pei = null;
            try {
                pei = (PersistableEditorInput)editorRef.getEditorInput().getAdapter(PersistableEditorInput.class);
            }
            catch (PartInitException partInitException) {}
            if (pei == null || !pei.getNode().equals(po)) continue;
            return editorRef;
        }
        return null;
    }

    public static String getComponentType(IExecTestCasePO exec, String name) {
        return Utils.getComponentType(exec, name, false);
    }

    private static String getComponentType(IExecTestCasePO exec, String name, boolean checkForPropagate) {
        String type = "";
        ICompNamesPairPO compNamesPair = exec.getCompNamesPair(name);
        if (compNamesPair != null) {
            if (checkForPropagate) {
                if (compNamesPair.isPropagated()) {
                    type = Utils.searchCompTypeInTree(exec, name);
                    compNamesPair.setType(type);
                    return type;
                }
            } else {
                return Utils.searchCompTypeInTree(exec, name);
            }
        }
        if (exec.getCompNamesPairs().isEmpty()) {
            return Utils.searchCompTypeInTree(exec, name);
        }
        for (ICompNamesPairPO pair : exec.getCompNamesPairs()) {
            if (pair.getSecondName() == null || !pair.getSecondName().equals(name)) continue;
            if (checkForPropagate) {
                if (!pair.isPropagated()) continue;
                return Utils.getComponentType(exec, pair.getFirstName(), true);
            }
            return Utils.getComponentType(exec, pair.getFirstName(), true);
        }
        return "";
    }

    private static String searchCompTypeInTree(IExecTestCasePO exec, String name) {
        String type = "";
        if (exec.getSpecTestCase() != null) {
            for (Object node : exec.getSpecTestCase().getUnmodifiableNodeList()) {
                if (node instanceof ICapPO) {
                    ICapPO cap = (ICapPO)node;
                    if (!name.equals(cap.getComponentName())) continue;
                    return cap.getComponentType();
                }
                if (node instanceof IExecTestCasePO && !"".equals(type = Utils.getComponentType((IExecTestCasePO)node, name, true))) break;
            }
        }
        return type;
    }

    public static void makeAutConfigCopy(Map<String, String> autConfigOrig, Map<String, String> autConfigCopy) {
        autConfigCopy.clear();
        Set<String> autConfigKeys = autConfigOrig.keySet();
        for (String key : autConfigKeys) {
            String value = autConfigOrig.get(key);
            if (value == null || value.length() <= 0) continue;
            autConfigCopy.put(key, value);
        }
    }
}

