/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Point;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTester;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class TreeViewTester
extends AbstractTreeTester {
    public void rcVerifyTextAtMousePosition(String txt, String operator) {
        this.checkNodeText(new Object[]{this.getNodeAtMousePosition()}, txt, operator);
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        Point awtPoint = this.getRobot().getCurrentMousePosition();
        final Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeBounds", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((TreeView)TreeViewTester.this.getRealComponent()).layout();
                List<TreeCell> tCells = ComponentHandler.getAssignableFrom(TreeCell.class);
                for (TreeCell cell : tCells) {
                    if (!NodeBounds.checkIfContains(point, (Node)cell)) continue;
                    return cell.getTreeItem();
                }
                throw new StepExecutionException("No tree node found at mouse position: X: " + point.getX() + "Y: " + point.getY(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
        return result;
    }

    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        try {
            this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, "no");
            TreeViewTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        try {
            this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, "no");
            TreeViewTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }
}

