/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.components.AUTSwingHierarchy;
import org.eclipse.jubula.rc.swing.listener.BaseAWTEventListener;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHandler
extends BaseAWTEventListener
implements BaseAUTListener {
    private static AutServerLogger log = new AutServerLogger(ComponentHandler.class);
    private static final long[] EVENT_MASK = new long[]{64L, 2L, 1L};
    private static final String PROP_TRACE_COMPONENT_NOT_FOUND = "org.eclipse.jubula.rc.traceComponentNotFound";
    private static final boolean TRACE_COMPONENT_NOT_FOUND = Boolean.parseBoolean(EnvironmentUtils.getProcessOrSystemProperty((String)"org.eclipse.jubula.rc.traceComponentNotFound"));
    private static AUTSwingHierarchy autHierarchy = new AUTSwingHierarchy();

    public static IComponentIdentifier getIdentifier(Component component) throws NoIdentifierForComponentException {
        try {
            return autHierarchy.getComponentIdentifier(component);
        }
        catch (ComponentNotManagedException cnme) {
            log.warn((Object)cnme);
            throw new NoIdentifierForComponentException("unable to create an identifier for '" + component + "'", MessageIDs.E_COMPONENT_ID_CREATION);
        }
    }

    public static IComponentIdentifier[] getAllComponentId() {
        return autHierarchy.getAllComponentId();
    }

    /*
     * Unable to fully structure code
     */
    public static Component findComponent(IComponentIdentifier componentIdentifier, boolean retry, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        block9: {
            start = System.currentTimeMillis();
            try {
                return ComponentHandler.autHierarchy.findComponent(componentIdentifier);
            }
            catch (ComponentNotManagedException cnme) {
                if (!retry) break block9;
                ** while (System.currentTimeMillis() - start < (long)timeout)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(500L);
                    return ComponentHandler.autHierarchy.findComponent(componentIdentifier);
                }
                catch (InterruptedException v0) {
                }
                catch (ComponentNotManagedException v1) {
                }
                catch (InvalidDataException v2) {}
                continue;
            }
        }
        ComponentHandler.logStacktrace();
        throw new ComponentNotFoundException(cnme.getMessage(), MessageIDs.E_COMPONENT_NOT_FOUND);
        catch (IllegalArgumentException iae) {
            ComponentHandler.log.error((Object)iae);
            throw iae;
        }
        catch (InvalidDataException ide) {
            ComponentHandler.log.error((Object)ide);
            throw new ComponentNotFoundException(ide.getMessage(), MessageIDs.E_COMPONENT_NOT_FOUND);
        }
    }

    public long[] getEventMask() {
        long[] eventMask = EVENT_MASK;
        return eventMask;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)event.paramString());
                }
                int id = event.getID();
                switch (id) {
                    case 200: 
                    case 205: {
                        Window window = ((WindowEvent)event).getWindow();
                        autHierarchy.add(window);
                        break;
                    }
                    case 300: {
                        this.checkContainerListener((ContainerEvent)event);
                        break;
                    }
                    case 103: {
                        ComponentEvent componentEvent = (ComponentEvent)event;
                        if (this.hasListener(componentEvent.getComponent(), ComponentListener.class)) break;
                        autHierarchy.componentHidden(componentEvent);
                        break;
                    }
                    case 102: {
                        ComponentEvent componentEvent = (ComponentEvent)event;
                        if (this.hasListener(componentEvent.getComponent(), ComponentListener.class)) break;
                        autHierarchy.componentShown(componentEvent);
                    }
                }
                if (AUTServer.getInstance().getMode() == 2) {
                    AUTServer.getInstance().updateHighLighter();
                }
            }
            catch (Throwable t) {
                log.error((Object)"exception during ComponentHandler", t);
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private void checkContainerListener(ContainerEvent event) {
        if (!this.hasListener(event.getContainer(), ContainerListener.class) && autHierarchy.getHierarchyContainer(event.getContainer()) != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"ComponentHandler called: autHierarchy.componentAdded");
            }
            autHierarchy.componentAdded(event);
        }
    }

    private boolean hasListener(Component component, Class<? extends EventListener> listenerClass) {
        EventListener[] listener = component.getListeners(listenerClass);
        int length = listener.length;
        int i = 0;
        while (i < length) {
            if (listener[i] instanceof AUTSwingHierarchy) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static AUTSwingHierarchy getAutHierarchy() {
        return autHierarchy;
    }

    private static void logStacktrace() {
        if (TRACE_COMPONENT_NOT_FOUND) {
            StringBuilder builder = new StringBuilder();
            builder.append("Logging stacktrace:" + SystemUtils.LINE_SEPARATOR);
            Thread currentThread = Thread.currentThread();
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> stackTrace : stackTraces.entrySet()) {
                Thread thread = stackTrace.getKey();
                if (thread == currentThread) {
                    builder.append("[current-thread] - ");
                }
                builder.append(String.valueOf(thread.getName()) + ":" + SystemUtils.LINE_SEPARATOR);
                StackTraceElement[] stackTraceElementArray = stackTrace.getValue();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement e = stackTraceElementArray[n2];
                    builder.append("\t" + e + SystemUtils.LINE_SEPARATOR);
                    ++n2;
                }
            }
            builder.append(SystemUtils.LINE_SEPARATOR);
            log.warn((Object)builder);
        }
    }
}

