/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.AbstractComboBoxAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CComboAdapter
extends AbstractComboBoxAdapter {
    private static AutServerLogger log = new AutServerLogger(CComboAdapter.class);
    private CCombo m_combobox;

    public CComboAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_combobox = (CCombo)objectToAdapt;
    }

    public void selectAll() {
        this.selectNone();
        this.getEventThreadQueuer().invokeAndWait("selectAll", new IRunnable(){

            public Object run() throws StepExecutionException {
                CComboAdapter.this.m_combobox.setSelection(new Point(0, CComboAdapter.this.m_combobox.getText().length()));
                return null;
            }
        });
    }

    public int getSelectedIndex() {
        int selectedIndex = (Integer)this.getEventThreadQueuer().invokeAndWait(String.valueOf(CComboAdapter.class.getName()) + "getSelectedIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(CComboAdapter.this.m_combobox.getSelectionIndex());
            }
        });
        return selectedIndex;
    }

    public String getText() {
        Object o = this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return CAPUtil.getWidgetText((Widget)CComboAdapter.this.m_combobox, CComboAdapter.this.m_combobox.getText());
            }
        });
        return o != null ? o.toString() : null;
    }

    protected boolean isComboEnabled() {
        boolean isEnabled = (Boolean)this.getEventThreadQueuer().invokeAndWait(String.valueOf(CComboAdapter.class.getName()) + "isComboEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return CComboAdapter.this.m_combobox.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    protected void selectImpl(final int index) {
        this.scrollIndexToVisible(index);
        Rectangle clickConstraints = (Rectangle)this.getEventThreadQueuer().invokeAndWait("setClickConstraints", new IRunnable(){

            public Object run() throws StepExecutionException {
                Rectangle constraints = SwtUtils.getRelativeWidgetBounds((Widget)CComboAdapter.this.getDropdownList(), (Control)CComboAdapter.this.getDropdownList());
                int displayedItemCount = CComboAdapter.this.getDisplayedItemCount();
                int numberBelowTop = 0;
                numberBelowTop = displayedItemCount >= CComboAdapter.this.getItemCount() ? index : Math.max(0, index - CComboAdapter.this.getItemCount() + displayedItemCount);
                constraints.height = CComboAdapter.this.getDropdownList().getItemHeight();
                constraints.y += numberBelowTop * constraints.height;
                return constraints;
            }
        });
        this.getRobot().click((Object)this.getDropdownList(), (Object)clickConstraints, new ClickOptions().setScrollToVisible(false));
    }

    protected void openDropdownList() {
        if (!this.isDropdownVisible()) {
            this.toggleDropdownList();
        }
        long timeout = 10000L;
        long done = System.currentTimeMillis() + timeout;
        while (!this.isDropdownVisible() && timeout >= 0L) {
            RobotTiming.sleepPreShowPopupDelay();
            long now = System.currentTimeMillis();
            timeout = done - now;
        }
        if (!this.isDropdownVisible()) {
            log.debug((Object)"Dropdown list still not visible, must be an error");
            throw new StepExecutionException("dropdown list not visible", EventFactory.createActionError((String)"TestErrorEvent.DropdownListNotFound"));
        }
    }

    protected int getItemCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getItemCount", new IRunnable(){

            public Object run() {
                return new Integer(CComboAdapter.this.m_combobox.getItemCount());
            }
        });
    }

    protected List getDropdownList() throws StepExecutionException {
        return (List)this.getEventThreadQueuer().invokeAndWait("getDropdownList", new IRunnable(){

            public Object run() throws StepExecutionException {
                Shell mainShell = SwtUtils.getShell((Widget)CComboAdapter.this.m_combobox);
                Display d = Display.getCurrent();
                Shell[] shells = d.getShells();
                int i = 0;
                while (i < shells.length) {
                    List possibleDropdown;
                    Shell curShell = shells[i];
                    if (mainShell == curShell.getParent() && curShell.getChildren().length == 1 && curShell.getChildren()[0] instanceof List && !(possibleDropdown = (List)curShell.getChildren()[0]).isDisposed() && possibleDropdown.isVisible() && CComboAdapter.this.isDropdownList(possibleDropdown)) {
                        return possibleDropdown;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    private boolean isDropdownList(List list) {
        Rectangle comboBounds = SwtUtils.getWidgetBounds((Widget)this.m_combobox);
        Rectangle listBounds = SwtUtils.getWidgetBounds((Widget)list);
        int posFuzz = 5;
        int dimFuzz = posFuzz * 2;
        comboBounds.x -= posFuzz;
        comboBounds.width += dimFuzz;
        comboBounds.y -= posFuzz;
        comboBounds.height += dimFuzz;
        return comboBounds.intersects(listBounds);
    }

    private void scrollIndexToVisible(final int index) {
        this.getEventThreadQueuer().invokeAndWait("scrollIndexToVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                CComboAdapter.this.getDropdownList().setTopIndex(index);
                return null;
            }
        });
    }

    private int getDisplayedItemCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getDisplayedItemCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                List dropdown = CComboAdapter.this.getDropdownList();
                if (dropdown == null) {
                    return new Integer(0);
                }
                int listHeight = SwtUtils.getWidgetBounds((Widget)dropdown).height;
                int itemHeight = dropdown.getItemHeight();
                return new Integer(listHeight / itemHeight);
            }
        });
    }

    protected boolean isDropdownVisible() {
        Boolean visible = (Boolean)this.getEventThreadQueuer().invokeAndWait(String.valueOf(CComboAdapter.class.getName()) + "isDropdownVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                List dropdownList = CComboAdapter.this.getDropdownList();
                return dropdownList != null ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    public String[] getValues() {
        return (String[])this.getEventThreadQueuer().invokeAndWait("getItems", new IRunnable(){

            public Object run() {
                return CComboAdapter.this.m_combobox.getItems();
            }
        });
    }
}

