/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean isValidPath(String path) {
        File dir = new File(path);
        boolean valid = true;
        if (dir.isDirectory() && dir.exists()) {
            File file = new File(String.valueOf(dir.getAbsolutePath()) + "/tmp.xml");
            try {
                boolean created = false;
                if (!file.exists()) {
                    file.createNewFile();
                    created = true;
                }
                if (!file.canWrite()) {
                    valid = false;
                }
                if (created) {
                    file.delete();
                }
            }
            catch (IOException iOException) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public static String resolveAgainstBasePath(String path, String basePath) {
        URI uri = URI.create(path);
        if (!uri.isAbsolute() && !uri.getPath().startsWith("/")) {
            if (StringUtils.isEmpty((String)basePath)) {
                return String.valueOf(-2);
            }
            uri = new File(basePath).toURI().resolve(uri);
        }
        return uri.toString();
    }
}

