/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestExecutionSourceProvider
extends AbstractJBSourceProvider
implements ITestExecutionEventListener {
    public static final String IS_TEST_RUNNING = "org.eclipse.jubula.client.ui.rcp.variable.isTestRunning";
    public static final String IS_TEST_PAUSED = "org.eclipse.jubula.client.ui.rcp.variable.isTestPaused";
    private boolean m_isTestRunning = false;
    private boolean m_isTestPaused = false;

    public TestExecutionSourceProvider() {
        ClientTest.instance().addTestExecutionEventListener((ITestExecutionEventListener)this);
    }

    public void dispose() {
        ClientTest.instance().removeTestExecutionEventListener((ITestExecutionEventListener)this);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> currentState = new HashMap<String, Object>();
        currentState.put(IS_TEST_RUNNING, this.m_isTestRunning);
        currentState.put(IS_TEST_PAUSED, this.m_isTestPaused);
        return currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_TEST_RUNNING, IS_TEST_PAUSED};
    }

    public void endTestExecution() {
        this.m_isTestRunning = false;
        this.m_isTestPaused = false;
        this.gdFireSourceChanged(0, IS_TEST_RUNNING, this.m_isTestRunning);
        this.gdFireSourceChanged(0, IS_TEST_PAUSED, this.m_isTestPaused);
    }

    public void stateChanged(TestExecutionEvent event) {
        switch (event.getState()) {
            case TEST_EXEC_START: 
            case TEST_EXEC_RESTART: {
                this.m_isTestPaused = false;
                this.m_isTestRunning = true;
                break;
            }
            case TEST_EXEC_PAUSED: {
                this.m_isTestRunning = true;
                this.m_isTestPaused = true;
                break;
            }
            case TEST_EXEC_STOP: 
            case TEST_EXEC_FAILED: 
            case TEST_EXEC_ERROR: 
            case TEST_EXEC_OK: 
            case TEST_EXEC_FINISHED: 
            case TEST_EXEC_COMPONENT_FAILED: {
                this.m_isTestRunning = false;
                this.m_isTestPaused = false;
                break;
            }
        }
        this.gdFireSourceChanged(0, IS_TEST_RUNNING, this.m_isTestRunning);
        this.gdFireSourceChanged(0, IS_TEST_PAUSED, this.m_isTestPaused);
    }
}

