/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.JavaAutConfigComponent;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwtAutConfigComponent
extends JavaAutConfigComponent {
    private ComboViewer m_keyboardLayoutCombo;

    public SwtAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName);
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
        super.createAdvancedArea(advancedAreaComposite);
        UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)I18n.getString((String)"SwtAutConfigComponent.KEYBOARD_LAYOUT"));
        this.m_keyboardLayoutCombo = new ComboViewer(advancedAreaComposite, 8);
        this.m_keyboardLayoutCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_keyboardLayoutCombo.setLabelProvider((IBaseLabelProvider)new KeyboardLayoutLabelProvider());
        this.m_keyboardLayoutCombo.setSorter(new ViewerSorter());
        this.m_keyboardLayoutCombo.setInput((Object)Languages.getInstance().getKeyboardLayouts());
        Combo keyboardLayoutCombo = this.m_keyboardLayoutCombo.getCombo();
        GridData comboGrid = new GridData(4, 2, true, false, 2, 1);
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGrid, (Control)keyboardLayoutCombo);
        keyboardLayoutCombo.setLayoutData((Object)comboGrid);
        ((GridData)keyboardLayoutCombo.getLayoutData()).widthHint = 250;
        String keyboardLayout = this.getConfigValue("KEYBOARD_LAYOUT");
        if (StringUtils.isEmpty((String)keyboardLayout)) {
            this.m_keyboardLayoutCombo.setSelection((ISelection)new StructuredSelection((Object)ObjectUtils.toString((Object)Locale.getDefault())));
        } else {
            this.m_keyboardLayoutCombo.setSelection((ISelection)new StructuredSelection((Object)keyboardLayout));
        }
        this.m_keyboardLayoutCombo.addSelectionChangedListener((ISelectionChangedListener)new KeyboardLayoutComboListener());
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyKeyboardLayout());
    }

    DialogStatusParameter modifyKeyboardLayout() {
        String layout = ObjectUtils.toString((Object)((StructuredSelection)this.m_keyboardLayoutCombo.getSelection()).getFirstElement());
        if (StringUtils.isNotEmpty((String)layout)) {
            this.putConfigValue("KEYBOARD_LAYOUT", layout.toString());
        }
        return null;
    }

    protected class KeyboardLayoutComboListener
    implements ISelectionChangedListener {
        protected KeyboardLayoutComboListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SwtAutConfigComponent.this.checkAll();
        }
    }

    private static class KeyboardLayoutLabelProvider
    extends LabelProvider {
        private KeyboardLayoutLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Locale) {
                return ((Locale)element).getDisplayName();
            }
            try {
                Locale locale = LocaleUtils.toLocale((String)ObjectUtils.toString((Object)element));
                if (locale != null) {
                    return this.getText(locale);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return super.getText(element);
        }
    }
}

