/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTHierarchy;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.javafx.components.ChildrenGetter;
import org.eclipse.jubula.rc.javafx.components.FindJavaFXComponentBP;
import org.eclipse.jubula.rc.javafx.components.JavaFXComponent;
import org.eclipse.jubula.rc.javafx.components.JavaFXHierarchyContainer;
import org.eclipse.jubula.rc.javafx.components.ParentGetter;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;

public class AUTJavaFXHierarchy
extends AUTHierarchy {
    private static AutServerLogger log = new AutServerLogger(AUTJavaFXHierarchy.class);
    private static FindJavaFXComponentBP findBP = new FindJavaFXComponentBP();
    private ReentrantLock m_lock = new ReentrantLock();

    public void createHierarchyFrom(Object o) {
        this.m_lock.lock();
        try {
            Object parent;
            Map realMap = this.getRealMap();
            Object lastParent = parent = ParentGetter.get(o);
            while (parent != null) {
                if (realMap.containsKey(parent)) {
                    lastParent = parent;
                    break;
                }
                lastParent = parent;
                parent = ParentGetter.get(parent);
            }
            this.createHierarchy(lastParent == null ? o : lastParent);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    private void createHierarchy(Object parent) {
        JavaFXHierarchyContainer parentCont;
        if (parent == null) {
            return;
        }
        if (this.getRealMap().containsKey(parent)) {
            parentCont = this.getHierarchyContainer(parent);
        } else {
            parentCont = this.initContainer(parent);
            this.name(parentCont);
            this.addToHierachyMap(parentCont);
        }
        List<Object> children = ChildrenGetter.getAsList(parent);
        for (Object child : children) {
            this.createHierarchy(child);
            JavaFXHierarchyContainer childCont = this.getHierarchyContainer(child);
            if (!parentCont.contains(childCont)) {
                parentCont.add(childCont);
                childCont.setPrnt(parentCont);
            } else if (childCont.getPrnt() == null) {
                childCont.setPrnt(parentCont);
            }
            this.name(childCont);
        }
    }

    private JavaFXHierarchyContainer initContainer(Object o) {
        JavaFXComponent comp = new JavaFXComponent(o);
        JavaFXHierarchyContainer cont = new JavaFXHierarchyContainer(comp);
        return cont;
    }

    public void removeComponentFromHierarchy(Object component) {
        JavaFXHierarchyContainer cont;
        if (component != null && (cont = this.getHierarchyContainer(component)) != null) {
            this.removeContainer(cont);
        }
    }

    public void removeContainer(JavaFXHierarchyContainer ctner) {
        this.m_lock.lock();
        try {
            Map contMap = this.getHierarchyMap();
            Map realMap = this.getRealMap();
            JavaFXComponent fxComp = ctner.getComponent();
            fxComp.removeChangeListener();
            contMap.remove((Object)ctner.getComponent());
            realMap.remove(fxComp.getRealComponent());
            JavaFXHierarchyContainer parent = (JavaFXHierarchyContainer)ctner.getPrnt();
            if (parent != null) {
                JavaFXHierarchyContainer[] parentComp = parent.getChildren();
                int i = 0;
                JavaFXHierarchyContainer[] javaFXHierarchyContainerArray = parentComp;
                int n = parentComp.length;
                int n2 = 0;
                while (n2 < n) {
                    JavaFXHierarchyContainer comp = javaFXHierarchyContainerArray[n2];
                    if (comp == ctner) {
                        parentComp[i] = null;
                        break;
                    }
                    ++i;
                    ++n2;
                }
            }
            ArrayList<JavaFXHierarchyContainer> children = new ArrayList<JavaFXHierarchyContainer>(Arrays.asList(ctner.getChildren()));
            for (JavaFXHierarchyContainer child : children) {
                this.removeContainer(child);
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public IComponentIdentifier[] getAllComponentId() {
        Vector<IComponentIdentifier> result = new Vector<IComponentIdentifier>();
        Set keys = this.getHierarchyMap().keySet();
        for (JavaFXComponent wrapComp : keys) {
            Object comp = wrapComp.getRealComponent();
            try {
                if (!AUTServerConfiguration.getInstance().isSupported(comp)) continue;
                result.add(this.getComponentIdentifier(comp));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"hierarchy map contains null values", (Throwable)iae);
            }
            catch (ComponentNotManagedException e) {
                log.error((Object)("component '" + wrapComp.getRealComponentType().getName() + "' not found!"), (Throwable)e);
            }
        }
        return result.toArray(new IComponentIdentifier[result.size()]);
    }

    public IComponentIdentifier getComponentIdentifier(Object component) throws ComponentNotManagedException {
        ComponentIdentifier result = new ComponentIdentifier();
        try {
            result.setComponentClassName(component.getClass().getName());
            result.setSupportedClassName(AUTServerConfiguration.getInstance().getTestableClass(component.getClass()).getName());
            List<String> hierarchy = this.getPathToRoot(component);
            result.setHierarchyNames(hierarchy);
            result.setNeighbours(this.getComponentContext(component));
            JavaFXHierarchyContainer cont = this.getHierarchyContainer(component);
            this.setAlternativeDisplayName(cont, component, (IComponentIdentifier)result);
            if (component.equals(findBP.findComponent((IComponentIdentifier)result, ComponentHandler.getAutHierarchy()))) {
                result.setEqualOriginalFound(true);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)iae);
            throw new ComponentNotManagedException("getComponentIdentifier() called for an unmanaged component: " + component, MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
    }

    public Object findComponent(IComponentIdentifier componentIdentifier) throws IllegalArgumentException, ComponentNotManagedException, InvalidDataException {
        Object comp = findBP.findComponent(componentIdentifier, ComponentHandler.getAutHierarchy());
        if (comp != null) {
            return comp;
        }
        throw new ComponentNotManagedException("unmanaged component with identifier: '" + componentIdentifier.toString() + "'.", MessageIDs.E_COMPONENT_NOT_MANAGED);
    }

    public List<String> getPathToRoot(Object component) throws IllegalArgumentException, ComponentNotManagedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("pathToRoot called for " + component));
        }
        Validate.notNull((Object)component, (String)"The component must not be null");
        ArrayList<String> hierarchy = new ArrayList<String>();
        JavaFXHierarchyContainer container = this.getHierarchyContainer(component);
        hierarchy.add(container.getName());
        JavaFXHierarchyContainer parent = (JavaFXHierarchyContainer)container.getPrnt();
        while (parent != null) {
            container = parent;
            hierarchy.add(0, container.getName());
            parent = (JavaFXHierarchyContainer)container.getPrnt();
        }
        return hierarchy;
    }

    protected List<String> getComponentContext(Object component) {
        ArrayList<String> context = new ArrayList<String>();
        JavaFXHierarchyContainer comp = component instanceof JavaFXHierarchyContainer ? (JavaFXHierarchyContainer)((Object)component) : this.getHierarchyContainer(component);
        JavaFXHierarchyContainer parent = (JavaFXHierarchyContainer)comp.getPrnt();
        if (parent != null) {
            JavaFXHierarchyContainer[] comps = parent.getChildren();
            int i = 0;
            while (i < comps.length) {
                JavaFXHierarchyContainer child = comps[i];
                if (!child.equals((Object)comp)) {
                    String toAdd = child.getName();
                    context.add(toAdd);
                }
                ++i;
            }
        }
        return context;
    }

    public JavaFXHierarchyContainer getHierarchyContainer(Object component) throws IllegalArgumentException {
        Validate.notNull((Object)component, (String)"The component must not be null");
        JavaFXHierarchyContainer result = null;
        try {
            JavaFXComponent compID = (JavaFXComponent)((Object)this.getRealMap().get(component));
            if (compID != null) {
                result = (JavaFXHierarchyContainer)((Object)this.getHierarchyMap().get((Object)compID));
            }
        }
        catch (ClassCastException cce) {
            log.error((Object)cce);
        }
        catch (NullPointerException npe) {
            log.error((Object)npe);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected void name(JavaFXHierarchyContainer hierarchyContainer) {
        block10: {
            comp = hierarchyContainer.getComponent();
            realComponent = comp.getRealComponent();
            if (realComponent instanceof Node) {
                component = realComponent;
                compName = ((Node)component).getId();
            } else if (realComponent instanceof MenuItem) {
                component = realComponent;
                compName = ((MenuItem)component).getId();
            } else {
                compName = null;
                component = realComponent;
            }
            hierParent = (JavaFXHierarchyContainer)hierarchyContainer.getPrnt();
            if (hierarchyContainer.getName() != null && hierarchyContainer.getName().length() != 0 && !hierarchyContainer.getName().equals("null")) {
                if (this.isUniqueName(hierParent, hierarchyContainer.getName(), hierarchyContainer)) {
                    return;
                }
                if (AUTJavaFXHierarchy.log.isInfoEnabled()) {
                    AUTJavaFXHierarchy.log.info((Object)("New name created for " + hierarchyContainer.getName() + "even though there was already a name!"));
                }
            }
            count = 0;
            originalName = null;
            newName = null;
            v0 = newNameGenerated = compName == null;
            if (compName != null) {
                originalName = compName;
                newName = compName;
            }
            if (newName != null) ** GOTO lbl32
            while (!this.isUniqueName(hierParent, newName, hierarchyContainer)) {
                newName = this.createName(component, ++count);
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                newName = this.createName(originalName, ++count);
lbl32:
                // 2 sources

                ** while (!this.isUniqueName((JavaFXHierarchyContainer)hierParent, (String)newName, (JavaFXHierarchyContainer)hierarchyContainer))
            }
        }
        comp.setName(newName);
        hierarchyContainer.setName(newName, newNameGenerated);
    }

    protected boolean isUniqueName(JavaFXHierarchyContainer parent, String name, JavaFXHierarchyContainer container) {
        if (name == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        JavaFXHierarchyContainer[] compIDs = parent.getChildren();
        int length = compIDs.length;
        int index = 0;
        while (index < length) {
            JavaFXHierarchyContainer childContainer = compIDs[index];
            String childName = childContainer.getName();
            if (name.equals(childName) && childContainer != container) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public ReentrantLock getLock() {
        return this.m_lock;
    }
}

