/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester;

import java.awt.Point;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTester;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JTreeTester
extends AbstractTreeTester {
    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        try {
            this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, "no");
            JTreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, "no");
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        try {
            this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, "no");
            JTreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcVerifyTextAtMousePosition(String text, String operator) {
        this.checkNodeText(new Object[]{this.getNodeAtMousePosition()}, text, operator);
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getEventThreadQueuer().invokeAndWait("getNodeAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                TreePath treePath;
                Point mousePosition = JTreeTester.this.getRobot().getCurrentMousePosition();
                Point treeLocation = JTreeTester.this.getTreeComponent().getLocationOnScreen();
                Point relativePos = new Point(mousePosition.x - treeLocation.x, mousePosition.y - treeLocation.y);
                int rowAtMousePosition = JTreeTester.this.getTreeComponent().getRowForLocation(relativePos.x, relativePos.y);
                if (rowAtMousePosition != -1 && (treePath = JTreeTester.this.getTreeComponent().getPathForLocation(relativePos.x, relativePos.y)) != null && treePath.getLastPathComponent() != null) {
                    return treePath.getLastPathComponent();
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    private JTree getTreeComponent() {
        return (JTree)this.getComponent().getRealComponent();
    }
}

