/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.utils.generator.ComponentInfo;
import org.eclipse.jubula.tools.utils.generator.Info;
import org.eclipse.jubula.tools.utils.generator.ParamInfo;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.Param;

public class ActionInfo
extends Info
implements Comparable {
    public static final int TYPE_EXECUTE = 0;
    public static final int TYPE_CHECK = 1;
    private Action m_action;
    private ComponentInfo m_containerComp;
    private int m_type;
    private String m_helpid;
    private List m_params = new ArrayList();
    private String m_shortName;

    public ActionInfo(Action action, ComponentInfo containerComp) {
        super(CompSystemI18n.getString(action.getName()));
        this.m_action = action;
        this.m_containerComp = containerComp;
        this.m_type = this.m_action.getMethod().indexOf("Verify") != -1 ? 1 : 0;
        String[] tokens = StringUtils.split((String)this.m_action.getName(), (char)'.');
        this.m_shortName = tokens[tokens.length - 1];
        this.m_helpid = String.valueOf(this.m_containerComp.getHelpid()) + "_" + this.m_shortName;
        for (Param param : this.m_action.getParams()) {
            this.m_params.add(new ParamInfo(param, this.m_helpid));
        }
    }

    public Action getAction() {
        return this.m_action;
    }

    public ComponentInfo getContainerComp() {
        return this.m_containerComp;
    }

    public List getParams() {
        return this.m_params;
    }

    public int getType() {
        return this.m_type;
    }

    public int compareTo(Object o) {
        ActionInfo ai = (ActionInfo)o;
        return this.getI18nName().compareTo(ai.getI18nName());
    }

    public String getHelpid() {
        return this.m_helpid;
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public String getTypeValue() {
        switch (this.m_type) {
            case 0: {
                return "e";
            }
            case 1: {
                return "c";
            }
        }
        throw new RuntimeException();
    }
}

