/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.monitoring;

import java.util.Map;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.monitoring.IMonitoring;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.GetMonitoringDataMessage;
import org.eclipse.jubula.communication.message.GetMonitoringDataResponseMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.objects.IMonitoringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMonitoringDataCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(GetMonitoringDataCommand.class);
    private GetMonitoringDataMessage m_message;

    public Message execute() {
        MonitoringDataStore cm = MonitoringDataStore.getInstance();
        IMonitoring agent = cm.getMonitoringAgent(this.m_message.getAutId());
        Map<String, IMonitoringValue> monitoringValues = agent.getMonitoringData();
        String monitoringId = cm.getConfigValue(this.m_message.getAutId(), "MONITORING_AGENT_ID");
        GetMonitoringDataResponseMessage message = new GetMonitoringDataResponseMessage();
        message.setMonitoringId(monitoringId);
        message.setMonitoringValues(monitoringValues);
        Communicator m = AutStarter.getInstance().getCommunicator();
        try {
            m.send((Message)message);
        }
        catch (CommunicationException e) {
            LOG.error("failed to send " + message.getClass().getName(), (Throwable)e);
        }
        return null;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (GetMonitoringDataMessage)message;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

