/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.remote.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.jubula.tools.xml.businessmodell.ValueSetElement;

public class ChooseCheckModeDialog
extends JFrame {
    private JButton m_okAndCheckOnButton = new JButton();
    private JButton m_okButStopCheckButton = new JButton();
    private JButton m_cancelButton = new JButton();
    private JLabel m_nameLabelText = new JLabel();
    private JLabel m_nameLabel = new JLabel();
    private JLabel m_actionLabel = new JLabel();
    private JComboBox<String> m_actionCombo = new JComboBox();
    private JPanel m_middlePanel = new JPanel();
    private List<JComponent> m_parameter = new ArrayList<JComponent>();
    private Map m_checkValues = null;
    private String m_operator = "equals";
    private String m_pathType = "absolute";
    private String m_mouseButtonRight = "3";

    public ChooseCheckModeDialog() {
        this.createPart();
    }

    private void createPart() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new FlowLayout());
        southPanel.add(this.m_okAndCheckOnButton);
        southPanel.add(this.m_okButStopCheckButton);
        southPanel.add(this.m_cancelButton);
        contentPane.add((Component)southPanel, "South");
        contentPane.add((Component)this.m_middlePanel, "Center");
        this.createParameterPanel(new Action());
        Border bd1 = BorderFactory.createEtchedBorder();
        contentPane.setBorder(bd1);
        this.m_nameLabelText.setText(I18n.getString((String)"ChooseCheckTypeDialog.nameLabel"));
        this.m_cancelButton.setText(I18n.getString((String)"ChooseCheckTypeDialog.cancel"));
        this.m_okAndCheckOnButton.setText(I18n.getString((String)"ChooseCheckTypeDialog.okAndCheckOn"));
        this.m_okButStopCheckButton.setText(I18n.getString((String)"ChooseCheckTypeDialog.okButStopCheck"));
        this.m_actionLabel.setText(I18n.getString((String)"ChooseCheckTypeDialog.action"));
        this.setTitle(I18n.getString((String)"ChooseCheckTypeDialog.title"));
        this.setContentPane(contentPane);
    }

    public void createParameterPanel(Action action) {
        ArrayList params = null;
        params = action != null ? action.getParams() : new ArrayList(0);
        this.m_middlePanel.removeAll();
        this.m_middlePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(10, 5, 10, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.m_middlePanel.add((Component)this.m_nameLabelText, c);
        c.fill = 2;
        c.insets = new Insets(10, 5, 10, 5);
        c.gridx = 1;
        c.gridy = 0;
        this.m_middlePanel.add((Component)this.getNameLabel(), c);
        c.fill = 2;
        c.insets = new Insets(10, 5, 10, 5);
        c.gridx = 0;
        c.gridy = 1;
        this.m_middlePanel.add((Component)this.m_actionLabel, c);
        c.fill = 2;
        c.insets = new Insets(10, 5, 10, 5);
        c.gridx = 1;
        c.gridy = 1;
        this.m_middlePanel.add(this.m_actionCombo, c);
        this.m_parameter.clear();
        int index = 1;
        int gridcount = 2;
        for (Param param : params) {
            if (param != null) {
                c.fill = 2;
                c.insets = new Insets(10, 5, 10, 5);
                c.gridx = 0;
                c.gridy = gridcount;
                this.m_middlePanel.add((Component)new JLabel(CompSystemI18n.getString((String)param.getName())), c);
                JComponent paramComp = this.createParamComponent(param);
                this.m_parameter.add(paramComp);
                c.fill = 2;
                c.insets = new Insets(10, 5, 10, 5);
                c.gridx = 1;
                c.gridy = gridcount++;
                this.m_middlePanel.add((Component)paramComp, c);
                continue;
            }
            c.gridx = 0;
            c.gridy = gridcount++;
            this.m_middlePanel.add((Component)new JLabel(String.valueOf(I18n.getString((String)"ChooseCheckTypeDialog.parameter")) + index), c);
            ++index;
        }
        this.pack();
    }

    private JComponent createParamComponent(Param param) {
        JTextField textField;
        Object value = this.m_checkValues.get(param.getName());
        if (param.hasValueSet()) {
            JComboBox<String> combo = new JComboBox<String>();
            Iterator valueIter = param.valueSetIterator();
            while (valueIter.hasNext()) {
                ValueSetElement valElem = (ValueSetElement)valueIter.next();
                combo.addItem(valElem.getValue());
            }
            if (value != null) {
                combo.setSelectedItem(value);
            } else if (param.getName().equals("CompSystem.Operator")) {
                combo.setSelectedItem(this.m_operator);
            } else if (param.getName().equals("CompSystem.ValueOperator")) {
                combo.setSelectedItem(this.m_operator);
            } else if (param.getName().equals("CompSystem.PathType")) {
                combo.setSelectedItem(this.m_pathType);
            } else if (param.getName().equals("CompSystem.SearchType")) {
                combo.setSelectedItem(this.m_pathType);
            } else if (param.getName().equals("CompSystem.MouseButton")) {
                combo.setSelectedItem(this.m_mouseButtonRight);
            } else {
                combo.setSelectedIndex(0);
            }
            return combo;
        }
        if (param.getType().equals("java.lang.Integer")) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setGroupingUsed(false);
            textField = new JFormattedTextField(nf);
        } else {
            textField = new JTextField();
        }
        textField.setColumns(25);
        if (this.m_checkValues != null && value != null) {
            String val = value.toString();
            textField.setText(val);
        }
        return textField;
    }

    public JLabel getNameLabel() {
        return this.m_nameLabel;
    }

    public void setNameLabel(String nameLabel) {
        this.m_nameLabel.setText(nameLabel);
    }

    public JButton getCancelButton() {
        return this.m_cancelButton;
    }

    public JButton getOkAndCheckOnButton() {
        return this.m_okAndCheckOnButton;
    }

    public JButton getOkButStopCheckButton() {
        return this.m_okButStopCheckButton;
    }

    public void setActions(List<String> l) {
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            this.m_actionCombo.addItem(iter.next());
        }
    }

    public Map getCheckValues() {
        return this.m_checkValues;
    }

    public void setCheckValues(Map checkValues) {
        this.m_checkValues = checkValues;
    }

    public List getParameter() {
        Iterator<JComponent> iter = this.m_parameter.iterator();
        ArrayList<Object> result = new ArrayList<Object>();
        while (iter.hasNext()) {
            JComponent component = iter.next();
            if (component instanceof JTextField) {
                result.add(((JTextField)component).getText());
                continue;
            }
            if (!(component instanceof JComboBox)) continue;
            result.add(((JComboBox)component).getSelectedItem());
        }
        return result;
    }

    public List getTextFields() {
        Iterator<JComponent> iter = this.m_parameter.iterator();
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        while (iter.hasNext()) {
            JComponent component = iter.next();
            if (!(component instanceof JTextField)) continue;
            result.add(component);
        }
        return result;
    }

    public int getAction() {
        return this.m_actionCombo.getSelectedIndex();
    }

    public JComboBox getActionCombo() {
        return this.m_actionCombo;
    }
}

