/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.jubula.tools.xml.businessmodell.ValueSetElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    private static StringHelper instance = null;
    private static String toolkit = "";
    private Map<String, String> m_map = null;

    private StringHelper() {
        this.initMap();
    }

    public static StringHelper getInstance() {
        if (toolkit == null) {
            toolkit = "";
        }
        if (GeneralStorage.getInstance().getProject() != null && !toolkit.equals(GeneralStorage.getInstance().getProject().getToolkit())) {
            instance = null;
            if (GeneralStorage.getInstance().getProject().getToolkit() != null) {
                toolkit = GeneralStorage.getInstance().getProject().getToolkit();
            } else {
                GeneralStorage.getInstance().getProject().setToolkit("com.bredexsw.guidancer.SwingToolkitPlugin");
            }
        }
        if (instance == null) {
            instance = new StringHelper();
        }
        return instance;
    }

    private void initMap() {
        this.m_map = new HashMap<String, String>(10007);
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        for (Component component : compSystem.getComponents()) {
            String compType = component.getType();
            List realizedTypes = component.getRealizedTypes();
            if (!component.isVisible() && !realizedTypes.isEmpty()) {
                String i18nType = realizedTypes.get(0).toString();
                if (!this.m_map.containsKey(compType)) {
                    String value = CompSystemI18n.getString((String)i18nType);
                    this.m_map.put(compType, value);
                    this.m_map.put(value, compType);
                }
            } else if (!this.m_map.containsKey(compType)) {
                String value = CompSystemI18n.getString((String)compType);
                this.m_map.put(compType, value);
                this.m_map.put(value, compType);
            }
            List actions = component.getActions();
            for (Action action : actions) {
                String actionName = action.getName();
                if (!this.m_map.containsKey(actionName)) {
                    this.m_map.put(actionName, CompSystemI18n.getString((String)actionName));
                }
                List params = action.getParams();
                for (Param param : params) {
                    String paramType;
                    String paramName = param.getName();
                    if (!this.m_map.containsKey(paramName)) {
                        String value = CompSystemI18n.getString((String)paramName);
                        this.m_map.put(paramName, value);
                        this.m_map.put(value, paramName);
                    }
                    if (!this.m_map.containsKey(paramType = param.getType())) {
                        String value = CompSystemI18n.getString((String)paramType);
                        this.m_map.put(paramType, value);
                        this.m_map.put(value, paramType);
                    }
                    Iterator iter = param.valueSetIterator();
                    while (iter.hasNext()) {
                        ValueSetElement vSet = (ValueSetElement)iter.next();
                        String paramValue = vSet.getValue();
                        if (this.m_map.containsKey(paramValue)) continue;
                        String value = CompSystemI18n.getString((String)paramValue, (boolean)true);
                        this.m_map.put(paramValue, value);
                        this.m_map.put(value, paramValue);
                    }
                }
            }
        }
        for (Object o : compSystem.getEventTypes().keySet()) {
            String value = I18n.getString((String)o.toString());
            this.m_map.put(o.toString(), value);
            this.m_map.put(value, o.toString());
        }
    }

    public Map<String, String> getMap() {
        return this.m_map;
    }

    public String get(String key, boolean fallBack) {
        String value = this.m_map.get(key);
        return value != null ? value : (fallBack ? key : value);
    }

    public Set<String> reverseLookup(String value) {
        HashSet<String> res = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.m_map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    public String reverseLookupUnique(String value, boolean fallback) {
        Set<String> keys = this.reverseLookup(value);
        if (keys.size() > 0) {
            return keys.iterator().next();
        }
        if (fallback) {
            return value;
        }
        return null;
    }
}

