/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.dialogs.ClassPathDialog;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.I18nEnumCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.toolkit.common.monitoring.MonitoringAttribute;
import org.eclipse.jubula.toolkit.common.monitoring.MonitoringRegistry;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.about.AboutUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAutConfigComponent
extends AutConfigComponent {
    public static final String AUT_CONFIG_DIALOG_MODE_KEY_DEFAULT = AutConfigComponent.Mode.BASIC.name();
    private static final String MAIN_CLASS = "Main-Class";
    private static final String DEFAULT_WIN_JRE = "../jre/bin/java.exe";
    private static boolean isExecFieldEmpty = true;
    private static String executablePath;
    private static Logger log;
    private boolean m_isExecFieldValid = true;
    private Text m_jarTextField;
    private Button m_jarButton;
    private Text m_execTextField;
    private Button m_execButton;
    private org.eclipse.swt.widgets.List m_classPathListField;
    private Composite m_classPathButtonComposite;
    private Button m_addElementButton;
    private Button m_editElementButton;
    private Button m_removeElementButton;
    private Button m_moveElementUpButton;
    private Button m_moveElementDownButton;
    private Text m_classNameTextField;
    private Text m_autArgsTextField;
    private I18nEnumCombo<IAUTConfigPO.ActivationMethod> m_activationMethodCombo;
    private Text m_autJreTextField;
    private Button m_autJreButton;
    private Composite m_autJreComposite;
    private Text m_autJreParamTextField;
    private DirectCombo<String> m_monitoringCombo;
    private Text m_envTextArea;
    private WidgetModifyListener m_modifyListener;
    private WidgetFocusListener m_focusListener;
    private WidgetSelectionListener m_selectionListener;
    private WidgetKeyListener m_keyListener;

    static {
        log = LoggerFactory.getLogger(JavaAutConfigComponent.class);
    }

    public JavaAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName, true);
    }

    public static boolean isExecFieldEmpty() {
        return isExecFieldEmpty;
    }

    @Override
    protected void createBasicArea(Composite basicAreaComposite) {
        super.createBasicArea(basicAreaComposite);
        this.initGUIAutConfigSettings(basicAreaComposite);
    }

    @Override
    protected void createMonitoringArea(Composite monitoringComposite) {
        GridLayout result = (GridLayout)monitoringComposite.getLayout();
        result.horizontalSpacing = 40;
        result.numColumns = 2;
        monitoringComposite.setLayout((Layout)result);
        String monitoringID = super.getConfigValue("MONITORING_AGENT_ID");
        if (!StringUtils.isEmpty((String)monitoringID)) {
            IConfigurationElement monitoringExtension = MonitoringRegistry.getElement((String)monitoringID);
            if (monitoringExtension != null) {
                this.createMonitoringUIComponents(monitoringComposite, MonitoringRegistry.getAttributes((IConfigurationElement)monitoringExtension));
                String extURL = MonitoringRegistry.getExtUrlForMonitoringId((String)monitoringID);
                if (!StringUtils.isEmpty((String)extURL)) {
                    UIComponentHelper.createLabel((Composite)monitoringComposite, (String)Messages.MonitoringAgentAddInfo);
                    Link extRef = new Link(monitoringComposite, 0);
                    extRef.setText(extURL);
                    extRef.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            AboutUtils.openLink((Shell)JavaAutConfigComponent.this.getShell(), (String)event.text);
                        }
                    });
                }
            } else {
                StyledText missingExtensionLabel = new StyledText(monitoringComposite, 64);
                missingExtensionLabel.setText(Messages.MissingMonitoringExtension);
                missingExtensionLabel.setEditable(false);
                missingExtensionLabel.setEnabled(false);
                missingExtensionLabel.setStyleRange(new StyleRange(0, missingExtensionLabel.getText().length(), null, null, 2));
                ControlDecorator.createWarning((Control)missingExtensionLabel, I18n.getString((String)"MissingMonitoringExtension.fieldDecorationText"));
            }
        }
        this.resize();
        this.getShell().pack();
        super.createMonitoringArea(monitoringComposite);
    }

    private void createMonitoringUIComponents(Composite monitoringComposite, List<MonitoringAttribute> monitoringAttributeList) {
        int i = 0;
        while (i < monitoringAttributeList.size()) {
            MonitoringAttribute attribute = monitoringAttributeList.get(i);
            if (attribute.isRender()) {
                if (attribute.getType().equalsIgnoreCase("string")) {
                    this.createMonitoringWidgetLabel(monitoringComposite, attribute);
                    this.createMonitoringTextFieldWidget(monitoringComposite, attribute);
                }
                if (attribute.getType().equalsIgnoreCase("filebrowse")) {
                    this.createMonitoringWidgetLabel(monitoringComposite, attribute);
                    this.createMonitoringFilebrowse(monitoringComposite, attribute);
                }
                if (attribute.getType().equalsIgnoreCase("boolean")) {
                    this.createMonitoringWidgetLabel(monitoringComposite, attribute);
                    this.createMonitoringCheckBoxWidget(monitoringComposite, attribute);
                }
            }
            ++i;
        }
    }

    public void createMonitoringWidgetLabel(Composite composite, MonitoringAttribute attribute) {
        Label widgetLabel = UIComponentHelper.createLabel((Composite)composite, (String)attribute.getDescription());
        if (!StringUtils.isEmpty((String)attribute.getInfoBobbleText())) {
            ControlDecorator.decorateInfo((Control)widgetLabel, attribute.getInfoBobbleText(), false);
        }
    }

    private void createMonitoringFilebrowse(Composite composite, MonitoringAttribute att) {
        Composite c = UIComponentHelper.createLayoutComposite((Composite)composite, (int)2);
        final Text textField = this.createMonitoringTextFieldWidget(c, att);
        Button browseButton = new Button(c, 8);
        browseButton.setText(Messages.AUTConfigComponentBrowse);
        browseButton.setLayoutData((Object)BUTTON_LAYOUT);
        browseButton.setData("MONITORING_KEY", (Object)att.getId());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaAutConfigComponent.this.monitoringBrowseButtonSelected(textField);
            }
        });
    }

    private void createMonitoringCheckBoxWidget(Composite composite, final MonitoringAttribute att) {
        final String autId = super.getConfigValue("AUT_ID");
        final Button b = UIComponentHelper.createToggleButton((Composite)composite, (int)1);
        b.setData("MONITORING_KEY", (Object)att.getId());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaAutConfigComponent.this.showMonitoringInfoDialog(autId);
                JavaAutConfigComponent.this.putConfigValue(att.getId(), String.valueOf(b.getSelection()));
            }
        });
    }

    private Text createMonitoringTextFieldWidget(Composite composite, final MonitoringAttribute att) {
        final Text textField = UIComponentHelper.createTextField((Composite)composite, (int)1);
        textField.setData("MONITORING_KEY", (Object)att.getId());
        textField.setText(this.getConfigValue(att.getId()));
        final IValidator validator = att.getValidator();
        textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (validator != null) {
                    IStatus status = validator.validate((Object)textField.getText());
                    if (!status.isOK()) {
                        DialogStatusParameter error = JavaAutConfigComponent.this.createErrorStatus(status.getMessage());
                        JavaAutConfigComponent.this.addError(error);
                    }
                    JavaAutConfigComponent.this.checkAll();
                }
                JavaAutConfigComponent.this.putConfigValue(att.getId(), textField.getText());
            }
        });
        final String autId = super.getConfigValue("AUT_ID");
        textField.addFocusListener(new FocusListener(){
            private String m_oldText = "";

            public void focusLost(FocusEvent e) {
                String currentText = textField.getText();
                if (!currentText.equals(this.m_oldText)) {
                    JavaAutConfigComponent.this.showMonitoringInfoDialog(autId);
                }
                JavaAutConfigComponent.this.putConfigValue(att.getId(), textField.getText());
            }

            public void focusGained(FocusEvent e) {
                this.m_oldText = textField.getText();
            }
        });
        return textField;
    }

    private void showMonitoringInfoDialog(String autId) {
        LinkedList l = (LinkedList)AutAgentRegistration.getInstance().getRegisteredAuts();
        String message = NLS.bind((String)Messages.ClientMonitoringInfoDialog, (Object)autId);
        for (AutIdentifier a : l) {
            if (!a.getExecutableName().equals(autId)) continue;
            NagDialog.runNagDialog(null, message, "org.eclipse.jubula.client.ua.help.autConfigPropDialogContextId");
        }
    }

    private void handleMonitoringComboEvent() {
        if (this.m_monitoringCombo.getSelectedObject() != null) {
            this.putConfigValue("MONITORING_AGENT_ID", ((String)this.m_monitoringCombo.getSelectedObject()).toString());
            this.cleanComposite(this.getMonitoringAreaComposite());
            this.createMonitoringArea(this.getMonitoringAreaComposite());
        } else {
            this.cleanComposite(this.getMonitoringAreaComposite());
            this.putConfigValue("MONITORING_AGENT_ID", "");
        }
        String autId = super.getConfigValue("AUT_ID");
        this.showMonitoringInfoDialog(autId);
    }

    private void cleanComposite(Composite compostie) {
        Control[] ca = compostie.getChildren();
        int i = 0;
        while (i < ca.length) {
            ca[i].dispose();
            ++i;
        }
        this.resize();
        this.getShell().pack();
    }

    private void initGUIAutConfigSettings(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.exec");
        this.m_execTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_execTextField, (int)4000);
        this.m_execButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_execButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_execButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_execButton.setEnabled(Utils.isLocalhost());
    }

    @Override
    protected boolean putConfigValue(String key, String value) {
        boolean hasChanged = super.putConfigValue(key, value);
        if (hasChanged) {
            for (Control field : this.getJavaRelatedFields()) {
                field.setEnabled(true);
            }
            boolean enableJarField = StringUtils.defaultString((String)this.getConfigValue("CLASSNAME")).length() == 0;
            this.m_jarTextField.setEnabled(enableJarField);
            this.m_jarButton.setEnabled(enableJarField && (this.checkLocalhostServer() || this.isRemoteRequest()));
            this.m_classNameTextField.setEnabled(StringUtils.defaultString((String)this.getConfigValue("JAR_FILE")).length() == 0);
            String exe = this.getConfigValue("EXECUTABLE");
            boolean isEmpty = exe == null || exe.length() == 0;
            for (Control field : this.getJavaRelatedFields()) {
                field.setEnabled(isEmpty && field.isEnabled());
            }
            if (!isEmpty) {
                this.m_classPathListField.setSelection(-1);
                this.checkClasspathButtons();
            }
            String classname = this.getConfigValue("CLASSNAME");
            String jar = this.getConfigValue("JAR_FILE");
            boolean isClassnameEmpty = classname == null || classname.length() == 0;
            boolean isJarEmpty = jar == null || jar.length() == 0;
            boolean enableExe = isJarEmpty && isClassnameEmpty;
            this.m_execTextField.setEnabled(enableExe);
            this.m_execButton.setEnabled(enableExe && (this.checkLocalhostServer() || this.isRemoteRequest()));
        }
        return hasChanged;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetKeyListener keyListener = this.getKeyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.m_activationMethodCombo.addSelectionListener((SelectionListener)selectionListener);
        this.m_autJreParamTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_envTextArea.addModifyListener((ModifyListener)modifyListener);
        this.m_classPathListField.addKeyListener((KeyListener)keyListener);
        this.m_classPathListField.addSelectionListener((SelectionListener)selectionListener);
        this.m_addElementButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_editElementButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_moveElementUpButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_moveElementDownButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_removeElementButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_jarButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_jarTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_classNameTextField.addModifyListener((ModifyListener)modifyListener);
        this.getServerCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_autJreButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_autJreTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_execTextField.addFocusListener((FocusListener)this.getFocusListener());
        this.m_execTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_execButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_monitoringCombo.addSelectionListener((SelectionListener)selectionListener);
    }

    @Override
    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetKeyListener keyListener = this.getKeyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.m_activationMethodCombo.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autJreParamTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_envTextArea.removeModifyListener((ModifyListener)modifyListener);
        this.m_classPathListField.removeKeyListener((KeyListener)keyListener);
        this.m_addElementButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autJreButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autJreTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_classNameTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_classPathListField.removeSelectionListener((SelectionListener)selectionListener);
        this.m_editElementButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_jarButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_jarTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_removeElementButton.removeSelectionListener((SelectionListener)selectionListener);
        this.getServerCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_execTextField.removeFocusListener((FocusListener)this.getFocusListener());
        this.m_execTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_execButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_monitoringCombo.removeSelectionListener((SelectionListener)selectionListener);
    }

    private void initGuiEnvironmentEditor(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.envVariables");
        this.m_envTextArea = new Text(parent, 578);
        LayoutUtil.setMaxChar((Text)this.m_envTextArea, (int)4000);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.horizontalSpan = 2;
        textGridData.grabExcessHorizontalSpace = false;
        textGridData.widthHint = 250;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_envTextArea), (int)2);
        this.m_envTextArea.setLayoutData((Object)textGridData);
    }

    private void initGuiJarChooser(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.jar");
        this.m_jarTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_jarTextField, (int)4000);
        this.m_jarButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_jarButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_jarButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_jarButton.setEnabled(Utils.isLocalhost());
    }

    private void initGuiClasspathEditor(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.classPath");
        Composite classpathComposite = UIComponentHelper.createLayoutComposite((Composite)parent);
        this.m_classPathListField = new org.eclipse.swt.widgets.List(classpathComposite, 2822);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_classPathListField), (int)2);
        LayoutUtil.addToolTipAndMaxWidth((GridData)textGridData, (Control)this.m_classPathListField);
        this.m_classPathListField.setLayoutData((Object)textGridData);
        Composite moveComposite = UIComponentHelper.createLayoutComposite((Composite)parent);
        this.m_moveElementUpButton = new Button(moveComposite, 8);
        this.m_moveElementUpButton.setImage(IconConstants.UP_ARROW_DIS_IMAGE);
        this.m_moveElementUpButton.setToolTipText(Messages.AutConfigDialogMoveCpUpToolTip);
        this.m_moveElementUpButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_moveElementDownButton = new Button(moveComposite, 8);
        this.m_moveElementDownButton.setImage(IconConstants.DOWN_ARROW_DIS_IMAGE);
        this.m_moveElementDownButton.setToolTipText(Messages.AutConfigDialogMoveCpDownToolTip);
        this.m_moveElementDownButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_classPathButtonComposite = UIComponentHelper.createLayoutComposite((Composite)classpathComposite, (int)3);
        this.m_addElementButton = new Button(this.m_classPathButtonComposite, 8);
        this.m_addElementButton.setText(Messages.AUTConfigComponentElement);
        this.m_addElementButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_editElementButton = new Button(this.m_classPathButtonComposite, 8);
        this.m_editElementButton.setText(Messages.AUTConfigComponentEdit);
        this.m_editElementButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_removeElementButton = new Button(this.m_classPathButtonComposite, 8);
        this.m_removeElementButton.setText(Messages.AUTConfigComponentRemove);
        this.m_removeElementButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.checkClasspathButtons();
    }

    private void initDataClassPath(String classPath) {
        this.m_classPathListField.removeAll();
        if (!StringUtils.isEmpty((String)classPath)) {
            String[] pathList = classPath.split(";");
            int i = 0;
            while (i < pathList.length) {
                this.m_classPathListField.add(pathList[i]);
                ++i;
            }
        }
    }

    @Override
    protected void initState() {
        this.m_activationMethodCombo.setEnabled(true);
        this.m_autJreParamTextField.setEnabled(true);
        this.m_envTextArea.setEnabled(true);
        this.m_jarTextField.setEnabled(true);
        this.m_jarButton.setEnabled(true);
        this.checkLocalhostServer();
        RemoteFileBrowserBP.clearCache();
    }

    DialogStatusParameter modifyEnvFieldAction() {
        this.putConfigValue("ENVIRONMENT", this.m_envTextArea.getText());
        return null;
    }

    DialogStatusParameter modifyJreParamFieldAction() {
        this.putConfigValue("JRE_PARAMETER", this.m_autJreParamTextField.getText());
        return null;
    }

    DialogStatusParameter modifyAutParamFieldAction() {
        String params = this.m_autArgsTextField.getText();
        this.putConfigValue("AUT_ARGUMENTS", params);
        return null;
    }

    boolean handleActivationComboEvent() {
        this.putConfigValue("ACTIVATION_METHOD", IAUTConfigPO.ActivationMethod.getRCString((IAUTConfigPO.ActivationMethod)((IAUTConfigPO.ActivationMethod)this.m_activationMethodCombo.getSelectedObject())));
        return true;
    }

    DialogStatusParameter modifyClassNameFieldAction() {
        if (this.m_classNameTextField == null || this.m_classNameTextField.isDisposed()) {
            return null;
        }
        DialogStatusParameter error = null;
        this.putConfigValue("CLASSNAME", this.m_classNameTextField.getText());
        if (!this.isValid((Widget)this.m_classNameTextField, true) && this.m_classNameTextField.getText().length() != 0) {
            error = this.createErrorStatus(Messages.AUTConfigComponentWrongClassName);
        }
        return error;
    }

    /*
     * Unable to fully structure code
     */
    DialogStatusParameter modifyJarFieldAction() {
        block25: {
            block26: {
                error = null;
                v0 = isEmpty = this.m_jarTextField.getText().length() == 0;
                if (!this.isValid((Widget)this.m_jarTextField, true) || isEmpty) break block26;
                if (!this.checkLocalhostServer()) break block25;
                filename = this.m_jarTextField.getText();
                file = new File(filename);
                workingDir = StringUtils.defaultString((String)this.getConfigValue("WORKING_DIR"));
                if (!file.isAbsolute() && workingDir.length() != 0) {
                    filename = String.valueOf(workingDir) + "/" + filename;
                    file = new File(filename);
                }
                jarFile = null;
                try {
                    if (!file.exists()) {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)file.getCanonicalPath()));
                    } else {
                        jarFile = new JarFile(file);
                        jarManifest = jarFile.getManifest();
                        if (jarManifest == null) {
                            error = this.createErrorStatus(Messages.AUTConfigComponentNoManifest);
                        } else if (jarManifest.getMainAttributes().getValue("Main-Class") == null) {
                            error = this.createErrorStatus(Messages.AUTConfigComponentNoMainClass);
                        }
                    }
                }
                catch (ZipException v1) {
                    error = this.createErrorStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotJar, (Object)filename));
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {
                            JavaAutConfigComponent.log.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    break block25;
                }
                catch (IOException v2) {
                    try {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)filename));
                        break block25;
                    }
                    catch (Throwable var8_12) {
                        throw var8_12;
                    }
                    finally {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException e) {
                                JavaAutConfigComponent.log.error(e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                ** if (jarFile == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        JavaAutConfigComponent.log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                }
            }
            if (!isEmpty) {
                error = this.createErrorStatus(Messages.AUTConfigComponentWrongJAR);
            }
        }
        this.putConfigValue("JAR_FILE", this.m_jarTextField.getText());
        return error;
    }

    @Override
    protected void populateExpertArea(Map<String, String> data) {
        this.m_activationMethodCombo.setSelectedObject((Object)IAUTConfigPO.ActivationMethod.getEnum((String)data.get("ACTIVATION_METHOD")));
        String monitoringAgentId = data.get("MONITORING_AGENT_ID");
        if (StringUtils.isEmpty((String)monitoringAgentId)) {
            this.m_monitoringCombo.deselectAll();
        } else {
            this.m_monitoringCombo.setSelectedObject((Object)monitoringAgentId);
            if (this.m_monitoringCombo.getSelectedObject() == null) {
                ArrayList<String> values = new ArrayList<String>(this.m_monitoringCombo.getValues());
                ArrayList<String> displayValues = new ArrayList<String>(Arrays.asList(this.m_monitoringCombo.getItems()));
                values.add(0, monitoringAgentId);
                values.remove(null);
                displayValues.add(0, monitoringAgentId);
                displayValues.remove("");
                this.m_monitoringCombo.setItems(values, displayValues);
                this.m_monitoringCombo.setSelectedObject((Object)monitoringAgentId);
            }
        }
        if (!this.isDataNew(data)) {
            this.m_autJreParamTextField.setText(StringUtils.defaultString((String)data.get("JRE_PARAMETER")));
            this.m_envTextArea.setText(StringUtils.defaultString((String)data.get("ENVIRONMENT")));
        }
    }

    @Override
    protected void populateMonitoringArea(Map<String, String> data) {
        Composite composite = this.getMonitoringAreaComposite();
        Control[] ca = composite.getChildren();
        int i = 0;
        while (i < ca.length) {
            if (ca[i].getData("MONITORING_KEY") != null) {
                Button b;
                Text t;
                String value;
                if (ca[i] instanceof Text && (value = data.get(String.valueOf((t = (Text)ca[i]).getData("MONITORING_KEY")))) != null && !value.equals("")) {
                    t.setText(value);
                }
                if (ca[i] instanceof Button && (value = data.get(String.valueOf((b = (Button)ca[i]).getData("MONITORING_KEY")))) != null) {
                    b.setSelection(Boolean.valueOf(value).booleanValue());
                }
            }
            ++i;
        }
    }

    @Override
    protected void populateAdvancedArea(Map<String, String> data) {
        this.m_classNameTextField.setText(StringUtils.defaultString((String)data.get("CLASSNAME")));
        this.initDataClassPath(StringUtils.defaultString((String)data.get("CLASSPATH")));
        this.m_autArgsTextField.setText(StringUtils.defaultString((String)data.get("AUT_ARGUMENTS")));
        String jreDirectory = StringUtils.defaultString((String)this.getConfigValue("JRE_BINARY"));
        if (this.isConfigNew()) {
            jreDirectory = this.getDefaultJreBin();
            this.modifyJREFieldAction();
        }
        this.m_autJreTextField.setText(jreDirectory);
    }

    private String getDefaultJreBin() {
        File jreBin = new File(DEFAULT_WIN_JRE);
        if (jreBin.exists()) {
            return DEFAULT_WIN_JRE;
        }
        return "";
    }

    @Override
    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        if (!this.isDataNew(data)) {
            this.getServerCombo().select(this.getServerCombo().indexOf(StringUtils.defaultString((String)data.get("SERVER"))));
            this.m_jarTextField.setText(StringUtils.defaultString((String)data.get("JAR_FILE")));
            this.m_execTextField.setText(StringUtils.defaultString((String)data.get("EXECUTABLE")));
        }
    }

    DialogStatusParameter modifyJREFieldAction() {
        DialogStatusParameter error = null;
        this.putConfigValue("JRE_BINARY", this.m_autJreTextField.getText());
        if (!this.isValid((Widget)this.m_autJreTextField, true) && this.m_autJreTextField.getText().length() != 0) {
            error = this.createErrorStatus(Messages.AUTConfigComponentWrongJRE);
        }
        return error;
    }

    private void setWorkingDirToExecFilePath(String directory) {
        if ((StringUtils.isEmpty((String)this.getAutWorkingDirField().getText()) || this.isBasicMode()) && JavaAutConfigComponent.isFilePathAbsolute(directory) && this.m_isExecFieldValid) {
            File wd = new File(directory);
            if ((wd = wd.getParentFile()) != null) {
                String execPath = wd.getAbsolutePath();
                this.getAutWorkingDirField().setText(execPath);
                this.putConfigValue("WORKING_DIR", execPath);
            }
        }
    }

    private static boolean isFilePathAbsolute(String filename) {
        File execFile = new File(filename);
        return execFile.isAbsolute();
    }

    public void setClasspathUpEnabled(boolean enabled) {
        this.m_moveElementUpButton.setEnabled(enabled);
        if (enabled) {
            this.m_moveElementUpButton.setImage(IconConstants.UP_ARROW_IMAGE);
        } else {
            this.m_moveElementUpButton.setImage(IconConstants.UP_ARROW_DIS_IMAGE);
        }
    }

    public void setClasspathDownEnabled(boolean enabled) {
        this.m_moveElementDownButton.setEnabled(enabled);
        if (enabled) {
            this.m_moveElementDownButton.setImage(IconConstants.DOWN_ARROW_IMAGE);
        } else {
            this.m_moveElementDownButton.setImage(IconConstants.DOWN_ARROW_DIS_IMAGE);
        }
    }

    void handleClassPathListEvent() {
        this.checkClasspathButtons();
        this.m_classPathListField.setFocus();
    }

    void handleDownButtonEvent() {
        int[] selectedIndices = this.m_classPathListField.getSelectionIndices();
        Arrays.sort(selectedIndices);
        int[] newSelectedIndices = new int[selectedIndices.length];
        int greatestIndex = this.m_classPathListField.getItemCount() - 1;
        if (selectedIndices.length > 0 && selectedIndices[selectedIndices.length - 1] < greatestIndex) {
            int i = 0;
            while (i < selectedIndices.length) {
                int index = selectedIndices[i];
                int newIndex = index + 1;
                String item = this.m_classPathListField.getItem(index);
                this.m_classPathListField.remove(index);
                this.m_classPathListField.add(item, newIndex);
                newSelectedIndices[i] = newIndex;
                ++i;
            }
            this.m_classPathListField.setSelection(newSelectedIndices);
        }
        this.checkClasspathButtons();
    }

    public void handleUpButtonEvent() {
        int[] selectedIndices = this.m_classPathListField.getSelectionIndices();
        Arrays.sort(selectedIndices);
        int[] newSelectedIndices = new int[selectedIndices.length];
        if (selectedIndices.length > 0 && selectedIndices[0] > 0) {
            int i = 0;
            while (i < selectedIndices.length) {
                int index = selectedIndices[i];
                int newIndex = index - 1;
                String item = this.m_classPathListField.getItem(index);
                this.m_classPathListField.remove(index);
                this.m_classPathListField.add(item, newIndex);
                newSelectedIndices[i] = newIndex;
                ++i;
            }
            this.m_classPathListField.setSelection(newSelectedIndices);
        }
        this.checkClasspathButtons();
    }

    void browseLocal(String[] extensionFilters, String title, Text textField, String configVarKey) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 81920);
        if (extensionFilters != null) {
            fileDialog.setFilterExtensions(extensionFilters);
        }
        fileDialog.setText(title);
        String filterPath = Utils.getLastDirPath();
        File path = new File(textField.getText());
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), textField.getText());
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            textField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue(configVarKey, directory);
        }
    }

    void handleExecButtonEvent(FileDialog fileDialog) {
        fileDialog.setText(Messages.AUTConfigComponentSelectExecutable);
        String filterPath = Utils.getLastDirPath();
        File path = new File(this.getConfigValue("EXECUTABLE"));
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), this.getConfigValue("EXECUTABLE"));
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            this.m_execTextField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue("EXECUTABLE", directory);
            executablePath = directory;
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    private void handleExecButtonEventForRemote() {
        if (this.remoteBrowse(false, "EXECUTABLE", this.m_execTextField, Messages.AUTConfigComponentSelectExecutable)) {
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    DialogStatusParameter modifyExecTextField() {
        String filename;
        DialogStatusParameter error;
        block10: {
            error = null;
            this.m_isExecFieldValid = true;
            isExecFieldEmpty = this.m_execTextField.getText().length() == 0;
            filename = this.m_execTextField.getText();
            if (this.isValid((Widget)this.m_execTextField, true) && !isExecFieldEmpty) {
                if (this.checkLocalhostServer()) {
                    String workingDirString;
                    File file = new File(filename);
                    if (!file.isAbsolute() && (workingDirString = this.getConfigValue("WORKING_DIR")) != null && workingDirString.length() != 0) {
                        filename = String.valueOf(workingDirString) + "/" + filename;
                        file = new File(filename);
                    }
                    try {
                        if (!file.isFile()) {
                            error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)file.getCanonicalPath()));
                            break block10;
                        }
                        new JarFile(file);
                        error = this.createErrorStatus(NLS.bind((String)Messages.AUTConfigComponentFileJar, (Object)file.getCanonicalPath()));
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)filename));
                    }
                }
            } else if (!isExecFieldEmpty) {
                error = this.createErrorStatus(Messages.AUTConfigComponentWrongExecutable);
            }
        }
        if (error != null) {
            this.m_isExecFieldValid = false;
        }
        this.putConfigValue("EXECUTABLE", this.m_execTextField.getText());
        executablePath = filename;
        return error;
    }

    public void checkClasspathButtons() {
        if (this.m_classPathListField.getItemCount() == 0) {
            this.m_removeElementButton.setEnabled(false);
            this.m_editElementButton.setEnabled(false);
            this.setClasspathUpEnabled(false);
            this.setClasspathDownEnabled(false);
            return;
        }
        if (this.m_classPathListField.getSelectionCount() > 0) {
            String[] selection = this.m_classPathListField.getSelection();
            if (!"".equals(selection[0])) {
                this.m_removeElementButton.setEnabled(true);
                this.m_editElementButton.setEnabled(true);
                int[] indices = this.m_classPathListField.getSelectionIndices();
                int smallestIndex = indices[0];
                int largestIndex = indices[0];
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    smallestIndex = Math.min(smallestIndex, index);
                    largestIndex = Math.max(largestIndex, index);
                    ++n2;
                }
                this.setClasspathUpEnabled(smallestIndex > 0);
                this.setClasspathDownEnabled(largestIndex < this.m_classPathListField.getItemCount() - 1);
            }
        } else {
            this.m_removeElementButton.setEnabled(false);
            this.m_editElementButton.setEnabled(false);
            this.m_moveElementDownButton.setEnabled(false);
            this.m_moveElementUpButton.setEnabled(false);
        }
    }

    public void handleRemoveButtonEvent() {
        int selectionIndex = this.m_classPathListField.getSelectionIndex();
        this.m_classPathListField.remove(this.m_classPathListField.getSelection()[0]);
        if (this.m_classPathListField.getItemCount() >= selectionIndex) {
            this.m_classPathListField.select(selectionIndex - 1);
        }
        if (this.m_classPathListField.getItemCount() == 1) {
            this.m_classPathListField.select(0);
        }
        if (this.m_classPathListField.getSelectionCount() == 0) {
            this.m_classPathListField.select(0);
        }
        this.handleClassPathListEvent();
        this.storeClassPath();
    }

    private void storeClassPath() {
        String classPath = "";
        int i = 0;
        while (i < this.m_classPathListField.getItemCount()) {
            classPath = classPath.concat(String.valueOf(this.m_classPathListField.getItem(i)) + ";");
            ++i;
        }
        if (!"".equals(classPath)) {
            classPath = classPath.substring(0, classPath.length() - 1);
        }
        this.putConfigValue("CLASSPATH", classPath);
    }

    private boolean isClassPathLengthAllowed(String elementToAdd) {
        String classPath = "";
        int i = 0;
        while (i < this.m_classPathListField.getItemCount()) {
            classPath = classPath.concat(String.valueOf(this.m_classPathListField.getItem(i)) + ";");
            ++i;
        }
        return (classPath = classPath.concat(String.valueOf(elementToAdd) + ";")).length() <= 4000;
    }

    public void handleAddElementButtonEvent(boolean editButtonWasPressed) {
        int maxLength = 4000 - this.getClassPathLength();
        if (maxLength < 1) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_TOO_LONG_CLASSPATH, (Object[])new Object[]{4000}, null);
            return;
        }
        String oldText = "";
        if (editButtonWasPressed) {
            oldText = this.m_classPathListField.getSelection()[0];
        }
        ClassPathDialog dialog = new ClassPathDialog(Plugin.getShell(), Messages.AUTConfigComponentClassPathDialogTitle, oldText, Messages.AUTConfigComponentMessage, Messages.AUTConfigComponentLabel, Messages.AUTConfigComponentWrongInputMessage, "", "classpath.png", Messages.AUTConfigComponentShellText, false, maxLength, this.checkLocalhostServer());
        dialog.setStyle(65536);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String[] elements = dialog.getName().split(System.getProperty("path.separator"));
            int i = 0;
            while (i < elements.length) {
                if (!"".equals(elements[i])) {
                    if (this.isClassPathLengthAllowed(elements[i])) {
                        if (editButtonWasPressed) {
                            this.m_classPathListField.remove(oldText);
                        }
                        this.m_classPathListField.add(elements[i]);
                    } else {
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_TOO_LONG_CLASSPATH, (Object[])new Object[]{4000}, null);
                        return;
                    }
                }
                ++i;
            }
            this.storeClassPath();
        }
    }

    private int getClassPathLength() {
        String classPath = "";
        int i = 0;
        while (i < this.m_classPathListField.getItemCount()) {
            classPath = classPath.concat(String.valueOf(this.m_classPathListField.getItem(i)) + ";");
            ++i;
        }
        return classPath.length();
    }

    @Override
    protected boolean checkLocalhostServer() {
        boolean enable = super.checkLocalhostServer();
        boolean browseEnabled = enable || this.isRemoteRequest();
        this.m_jarButton.setEnabled(browseEnabled && this.m_jarTextField.getEnabled());
        this.m_execButton.setEnabled(browseEnabled && this.m_execButton.isEnabled());
        this.m_autJreButton.setEnabled(browseEnabled && this.m_autJreButton.isEnabled());
        return enable;
    }

    @Override
    protected boolean isJavaAut() {
        return true;
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
        this.initGuiJarChooser(advancedAreaComposite);
        this.createAutDirectoryEditor(advancedAreaComposite);
        UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)"AUTConfigComponent.className");
        this.m_classNameTextField = UIComponentHelper.createTextField((Composite)advancedAreaComposite, (int)2);
        LayoutUtil.setMaxChar((Text)this.m_classNameTextField, (int)4000);
        this.m_classNameTextField.setText(StringUtils.defaultString((String)this.getConfigValue("CLASSNAME")));
        this.initGuiClasspathEditor(advancedAreaComposite);
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)"AUTConfigComponent.autArguments"), "ControlDecorator.AUTArguments", false);
        this.m_autArgsTextField = UIComponentHelper.createTextField((Composite)advancedAreaComposite, (int)2);
        UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)"AUTConfigComponent.jre");
        this.m_autJreTextField = UIComponentHelper.createTextField((Composite)advancedAreaComposite, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_autJreTextField, (int)4000);
        GridData comboGrid = new GridData(4, 2, true, false, 1, 1);
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGrid, (Control)this.m_autJreTextField);
        this.m_autJreTextField.setLayoutData((Object)comboGrid);
        ((GridData)this.m_autJreTextField.getLayoutData()).widthHint = 250;
        this.m_autJreComposite = UIComponentHelper.createLayoutComposite((Composite)advancedAreaComposite);
        this.m_autJreButton = new Button(this.m_autJreComposite, 8);
        this.m_autJreButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_autJreButton.setLayoutData((Object)BUTTON_LAYOUT);
        super.createAdvancedArea(advancedAreaComposite);
    }

    @Override
    protected void createExpertArea(Composite expertAreaComposite) {
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.jreArguments"), "ControlDecorator.JREArguments", false);
        this.m_autJreParamTextField = UIComponentHelper.createTextField((Composite)expertAreaComposite, (int)2);
        this.initGuiEnvironmentEditor(expertAreaComposite);
        UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.activationMethod");
        this.m_activationMethodCombo = UIComponentHelper.createEnumCombo((Composite)expertAreaComposite, (int)2, (String)"AUTConfigComponent.ActivationMethod", IAUTConfigPO.ActivationMethod.class);
        UIComponentHelper.createSeparator((Composite)expertAreaComposite, (int)3);
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.labelMonitoring"), "AUTConfigComponent.labelMonitoring.helpText", false);
        this.m_monitoringCombo = UIComponentHelper.createCombo((Composite)expertAreaComposite, (int)2, (List)MonitoringRegistry.getAllRegisteredMonitoringIds(), (List)MonitoringRegistry.getAllRegisteredMonitoringNames(), (boolean)true);
        super.createExpertArea(expertAreaComposite);
    }

    @Override
    protected void openServerPrefPage() {
        boolean checkListeners;
        super.openServerPrefPage();
        boolean bl = checkListeners = this.m_selectionListener != null;
        if (checkListeners) {
            this.deinstallListeners();
        }
        if (checkListeners) {
            this.installListeners();
        }
    }

    protected List<Control> getJavaRelatedFields() {
        ArrayList<Control> javaFields = new ArrayList<Control>();
        javaFields.add((Control)this.m_autJreButton);
        javaFields.add((Control)this.m_autJreTextField);
        javaFields.add((Control)this.m_autJreComposite);
        javaFields.add((Control)this.m_autJreParamTextField);
        javaFields.add((Control)this.m_classNameTextField);
        javaFields.add((Control)this.m_classPathButtonComposite);
        javaFields.add((Control)this.m_addElementButton);
        javaFields.add((Control)this.m_classPathListField);
        javaFields.add((Control)this.m_jarButton);
        javaFields.add((Control)this.m_jarTextField);
        return javaFields;
    }

    private WidgetKeyListener getKeyListener() {
        if (this.m_keyListener == null) {
            this.m_keyListener = new WidgetKeyListener();
        }
        return this.m_keyListener;
    }

    private WidgetSelectionListener getSelectionListener() {
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new WidgetSelectionListener();
        }
        return this.m_selectionListener;
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    private WidgetFocusListener getFocusListener() {
        if (this.m_focusListener == null) {
            this.m_focusListener = new WidgetFocusListener();
        }
        return this.m_focusListener;
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyAutConfigFieldAction());
        this.addError(paramList, this.modifyAutParamFieldAction());
        this.addError(paramList, this.modifyClassNameFieldAction());
        this.addError(paramList, this.modifyEnvFieldAction());
        this.addError(paramList, this.modifyJarFieldAction());
        this.addError(paramList, this.modifyExecTextField());
        this.addError(paramList, this.modifyJREFieldAction());
        this.addError(paramList, this.modifyJreParamFieldAction());
        this.addError(paramList, this.modifyServerComboAction());
    }

    public void dispose() {
        RemoteFileBrowserBP.clearCache();
        super.dispose();
    }

    private void handleBrowseDirButtonEvent(Text textField, DirectoryDialog directoryDialog) {
        String directory = null;
        directoryDialog.setMessage(Messages.AUTConfigComponentSelectDir);
        File path = new File(textField.getText());
        String filterPath = Utils.getLastDirPath();
        if (path.exists()) {
            try {
                filterPath = path.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        directoryDialog.setFilterPath(filterPath);
        directory = directoryDialog.open();
        if (directory != null) {
            textField.setText(directory);
            Utils.storeLastDirPath(directoryDialog.getFilterPath());
            this.putConfigValue(String.valueOf(textField.getData("MONITORING_KEY")), textField.getText());
        }
    }

    private void monitoringBrowseButtonSelected(Text textField) {
        if (this.isRemoteRequest()) {
            this.remoteBrowse(true, String.valueOf(textField.getData("MONITORING_KEY")), textField, Messages.AUTConfigComponentSelectDir);
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(Plugin.getShell(), 81920);
            this.handleBrowseDirButtonEvent(textField, directoryDialog);
        }
    }

    private class WidgetFocusListener
    implements FocusListener {
        private WidgetFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaAutConfigComponent.this.m_execTextField)) {
                JavaAutConfigComponent.this.setWorkingDirToExecFilePath(executablePath);
            }
        }
    }

    private class WidgetKeyListener
    extends KeyAdapter {
        private WidgetKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.widget == JavaAutConfigComponent.this.m_classPathListField && e.stateMask == 65536) {
                if (e.keyCode == 0x1000002) {
                    JavaAutConfigComponent.this.handleDownButtonEvent();
                } else if (e.keyCode == 0x1000001) {
                    JavaAutConfigComponent.this.handleUpButtonEvent();
                }
            }
        }
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaAutConfigComponent.this.getServerCombo())) {
                boolean checkListeners;
                JavaAutConfigComponent.this.checkLocalhostServer();
                boolean bl = checkListeners = JavaAutConfigComponent.this.m_selectionListener != null;
                if (checkListeners) {
                    JavaAutConfigComponent.this.deinstallListeners();
                }
                if (checkListeners) {
                    JavaAutConfigComponent.this.installListeners();
                }
            }
            JavaAutConfigComponent.this.checkAll();
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaAutConfigComponent.this.m_autJreButton)) {
                if (JavaAutConfigComponent.this.isRemoteRequest()) {
                    JavaAutConfigComponent.this.remoteBrowse(false, "JRE_BINARY", JavaAutConfigComponent.this.m_autJreTextField, Messages.AUTConfigComponentSelectJRE);
                } else {
                    JavaAutConfigComponent.this.browseLocal(null, Messages.AUTConfigComponentSelectJRE, JavaAutConfigComponent.this.m_autJreTextField, "JRE_BINARY");
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_jarButton)) {
                if (JavaAutConfigComponent.this.isRemoteRequest()) {
                    JavaAutConfigComponent.this.remoteBrowse(false, "JAR_FILE", JavaAutConfigComponent.this.m_jarTextField, Messages.AUTConfigComponentSelectJAR);
                } else {
                    JavaAutConfigComponent.this.browseLocal(new String[]{"*.jar"}, Messages.AUTConfigComponentSelectJAR, JavaAutConfigComponent.this.m_jarTextField, "JAR_FILE");
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_execButton)) {
                if (JavaAutConfigComponent.this.isRemoteRequest()) {
                    JavaAutConfigComponent.this.handleExecButtonEventForRemote();
                } else {
                    JavaAutConfigComponent.this.handleExecButtonEvent(new FileDialog(Plugin.getShell(), 81920));
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_removeElementButton)) {
                JavaAutConfigComponent.this.handleRemoveButtonEvent();
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_moveElementUpButton)) {
                JavaAutConfigComponent.this.handleUpButtonEvent();
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_moveElementDownButton)) {
                JavaAutConfigComponent.this.handleDownButtonEvent();
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_editElementButton)) {
                JavaAutConfigComponent.this.handleAddElementButtonEvent(true);
                if (JavaAutConfigComponent.this.modifyClassNameFieldAction() != null) {
                    JavaAutConfigComponent.this.m_classNameTextField.setFocus();
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_addElementButton)) {
                JavaAutConfigComponent.this.handleAddElementButtonEvent(false);
                if (JavaAutConfigComponent.this.modifyClassNameFieldAction() != null) {
                    JavaAutConfigComponent.this.m_classNameTextField.setFocus();
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_classPathListField)) {
                JavaAutConfigComponent.this.handleClassPathListEvent();
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_activationMethodCombo)) {
                JavaAutConfigComponent.this.handleActivationComboEvent();
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_monitoringCombo)) {
                JavaAutConfigComponent.this.handleMonitoringComboEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "(" + source + ")" + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object source = e.getSource();
            DirectoryDialog directoryDialog = new DirectoryDialog(Plugin.getShell(), 65536);
            if (source.equals(JavaAutConfigComponent.this.m_classPathListField)) {
                directoryDialog.setMessage(Messages.AUTConfigComponentEdit);
                directoryDialog.setFilterPath(JavaAutConfigComponent.this.m_classPathListField.getSelection()[0]);
                int selectionIndex = JavaAutConfigComponent.this.m_classPathListField.getSelectionIndex();
                String directory = directoryDialog.open();
                if (directory != null) {
                    JavaAutConfigComponent.this.m_classPathListField.remove(JavaAutConfigComponent.this.m_classPathListField.getSelection()[0]);
                    JavaAutConfigComponent.this.m_classPathListField.add(directory, selectionIndex);
                }
                JavaAutConfigComponent.this.handleClassPathListEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "(" + source + ")" + "."));
        }
    }
}

