/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.propertytester;

import javax.persistence.EntityManager;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.propertytester.AbstractBooleanPropertyTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultSummaryPropertyTester
extends AbstractBooleanPropertyTester {
    public static final String HAS_MONITORING_DATA_PROP = "hasMonitoringData";
    public static final String HAS_TEST_RESULT_DETAILS_PROP = "hasTestResultDetails";
    public static final String HAS_PENDING_ALM_REPORT_PROP = "hasPendingALMReport";
    private static final String[] PROPERTIES = new String[]{"hasMonitoringData", "hasTestResultDetails", "hasPendingALMReport"};

    public boolean testImpl(Object receiver, String property, Object[] args) {
        EntityManager masterSession;
        GeneralStorage instance = GeneralStorage.getInstance();
        if (instance != null && (masterSession = instance.getMasterSession()).isOpen()) {
            ITestResultSummaryPO summary = (ITestResultSummaryPO)receiver;
            if (property.equals(HAS_MONITORING_DATA_PROP)) {
                return summary.isReportWritten();
            }
            if (property.equals(HAS_TEST_RESULT_DETAILS_PROP)) {
                return TestResultPM.hasTestResultDetails((EntityManager)masterSession, (Long)summary.getId());
            }
            if (property.equals(HAS_PENDING_ALM_REPORT_PROP)) {
                return TestResultSummaryPropertyTester.hasPendingALMReport(summary, masterSession);
            }
        }
        return false;
    }

    public static boolean hasPendingALMReport(ITestResultSummaryPO summary, EntityManager session) {
        return summary.isTestsuiteRelevant() && TestResultPM.hasTestResultDetails((EntityManager)session, (Long)summary.getId()) && summary.getAlmReportStatus() == ITestResultSummaryPO.AlmReportStatus.NOT_YET_REPORTED;
    }

    public Class<? extends Object> getType() {
        return ITestResultSummaryPO.class;
    }

    public String[] getProperties() {
        return PROPERTIES;
    }
}

