/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses.tree;

import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractPathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;

public class PathBasedTraverser
extends AbstractPathBasedTraverser {
    private INodePath m_treePath;

    public PathBasedTraverser(AbstractTreeOperationContext context, INodePath treePath) {
        super(context, treePath);
        this.m_treePath = treePath;
    }

    public PathBasedTraverser(AbstractTreeOperationContext context, INodePath treePath, TreeNodeOperationConstraint constraint) {
        super(context, treePath, constraint);
        this.m_treePath = treePath;
    }

    private void traversePath(Object node, int level, TreeNodeOperation operation) throws StepExecutionException {
        if (level == this.m_treePath.getLength()) {
            return;
        }
        boolean found = false;
        int childCount = this.getContext().getNumberOfChildren(node);
        int i = 0;
        while (i < childCount && !found) {
            Object child = this.getContext().getChild(node, i);
            found = this.m_treePath.isInPath(child, level, this.getContext());
            if (found) {
                if (this.isOperable(level, this.m_treePath.getLength())) {
                    this.callOperation(child, operation);
                }
                this.traversePath(child, level + 1, operation);
            }
            ++i;
        }
        if (!found) {
            this.throwTreeNodeNotFound(level);
        }
    }

    public void traversePath(TreeNodeOperation operation, Object startNode) throws StepExecutionException {
        operation.setContext(this.getContext());
        if (startNode == null) {
            if (this.m_treePath.getLength() > 0) {
                Object[] rootNodes = this.getContext().getRootNodes();
                boolean found = false;
                int i = 0;
                while (i < rootNodes.length && !found) {
                    Object root = rootNodes[i];
                    found = this.m_treePath.isInPath(root, 0, this.getContext());
                    if (found) {
                        if (this.isOperable(0, this.m_treePath.getLength())) {
                            this.callOperation(root, operation);
                        }
                        this.traversePath(root, 1, operation);
                    }
                    ++i;
                }
                if (!found) {
                    this.throwTreeNodeNotFound(0);
                }
            }
        } else {
            this.traverseRelativePath(startNode, operation);
        }
    }

    private void traverseRelativePath(Object startNode, TreeNodeOperation operation) throws StepExecutionException {
        if (this.isOperable(-1, this.m_treePath.getLength())) {
            this.callOperation(startNode, operation);
        }
        boolean found = false;
        int childCount = this.getContext().getNumberOfChildren(startNode);
        if (this.m_treePath.getLength() != 0) {
            int i = 0;
            while (i < childCount && !found) {
                Object child = this.getContext().getChild(startNode, i);
                found = this.m_treePath.isInPath(child, 0, this.getContext());
                if (found) {
                    if (this.isOperable(0, this.m_treePath.getLength())) {
                        this.callOperation(child, operation);
                    }
                    this.traversePath(child, 1, operation);
                }
                ++i;
            }
            if (!found) {
                this.throwTreeNodeNotFound(0);
            }
        }
    }

    protected INodePath getTreePath() {
        return this.m_treePath;
    }
}

