/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IWidgetComponent;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.RobotJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.MenuTester;
import org.eclipse.jubula.rc.javafx.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class JavaFXComponentAdapter<T extends Node>
extends AbstractComponentAdapter<T>
implements IWidgetComponent {
    private static Map<String, Integer> converterTable = null;

    static {
        converterTable = new HashMap<String, Integer>();
        converterTable.put("none", new Integer(-1));
        converterTable.put("shift", new Integer(16));
        converterTable.put("control", new Integer(17));
        converterTable.put("alt", new Integer(18));
        converterTable.put("meta", new Integer(157));
        converterTable.put("cmd", new Integer(157));
        converterTable.put("mod", new Integer(17));
    }

    public JavaFXComponentAdapter(T objectToAdapt) {
        super(objectToAdapt);
    }

    public boolean isShowing() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isShowing", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((Node)JavaFXComponentAdapter.this.getRealComponent()).isVisible();
            }
        });
        return result;
    }

    public boolean isEnabled() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isEnabled", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !((Node)JavaFXComponentAdapter.this.getRealComponent()).isDisabled();
            }
        });
        return result;
    }

    public boolean hasFocus() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("hasFocus", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((Node)JavaFXComponentAdapter.this.getRealComponent()).isFocused();
            }
        });
        return result;
    }

    public String getPropteryValue(final String propertyname) {
        String prop = EventThreadQueuerJavaFXImpl.invokeAndWait("getProperty", new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    return JavaFXComponentAdapter.this.getRobot().getPropertyValue(JavaFXComponentAdapter.this.getRealComponent(), propertyname);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    public AbstractMenuTester showPopup(int xPos, String xUnits, int yPos, String yUnits, int button) throws StepExecutionException {
        Node n = (Node)this.getRealComponent();
        if (n instanceof Control && ((Control)n).getContextMenu() != null) {
            return this.openPropertyContextMenu(xPos, xUnits, yPos, yUnits, button, (Control)n);
        }
        return this.openContextMenu(xPos, xUnits, yPos, yUnits, button, n);
    }

    private AbstractMenuTester openContextMenu(int xPos, String xUnits, int yPos, String yUnits, int button, Node n) {
        boolean isAbsoluteUnitsX = "Pixel".equalsIgnoreCase(xUnits);
        boolean isAbsoluteUnitsY = "Pixel".equalsIgnoreCase(yUnits);
        this.getRobot().click(n, null, ClickOptions.create().setClickCount(1).setMouseButton(button), xPos, isAbsoluteUnitsX, yPos, isAbsoluteUnitsY);
        return EventThreadQueuerJavaFXImpl.invokeAndWait("showPopup", new Callable<MenuTester>(){

            @Override
            public MenuTester call() throws Exception {
                long now;
                MenuTester menuTester = null;
                Iterator iter = Window.impl_getWindows();
                ArrayList<ContextMenu> result = new ArrayList<ContextMenu>();
                long timeout = 10000L;
                long done = System.currentTimeMillis() + timeout;
                do {
                    Window w;
                    if (!iter.hasNext()) {
                        iter = Window.impl_getWindows();
                    }
                    if (!((w = (Window)iter.next()) instanceof ContextMenu) || result.contains(w)) continue;
                    result.add((ContextMenu)w);
                } while ((timeout = done - (now = System.currentTimeMillis())) > 0L && (iter.hasNext() || result.size() <= 0));
                if (result.size() == 1) {
                    ContextMenu cm = (ContextMenu)result.get(0);
                    menuTester = new MenuTester();
                    menuTester.setComponent(cm);
                } else {
                    if (result.size() == 0) {
                        throw new StepExecutionException("No Context Menu was found", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
                    }
                    if (result.size() > 1) {
                        throw new StepExecutionException("Multiple Context Menus were found", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedOperationInToolkit"));
                    }
                }
                return menuTester;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractMenuTester openPropertyContextMenu(int xPos, String xUnits, int yPos, String yUnits, int button, Control comp) {
        ContextMenu cotxMenu;
        block10: {
            final EventLock event = new EventLock();
            cotxMenu = comp.getContextMenu();
            EventHandler<WindowEvent> filter = new EventHandler<WindowEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(WindowEvent e) {
                    EventLock eventLock = event;
                    synchronized (eventLock) {
                        event.notifyAll();
                    }
                }
            };
            cotxMenu.addEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)filter);
            boolean isAbsoluteUnitsX = "Pixel".equalsIgnoreCase(xUnits);
            boolean isAbsoluteUnitsY = "Pixel".equalsIgnoreCase(yUnits);
            this.getRobot().click(comp, null, ClickOptions.create().setClickCount(1).setMouseButton(button), xPos, isAbsoluteUnitsX, yPos, isAbsoluteUnitsY);
            if (!comp.getContextMenu().isShowing()) {
                try {
                    try {
                        EventLock eventLock = event;
                        synchronized (eventLock) {
                            event.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        cotxMenu.removeEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)filter);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    cotxMenu.removeEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)filter);
                    throw throwable;
                }
                cotxMenu.removeEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)filter);
            }
        }
        if (comp.getContextMenu().isShowing()) {
            MenuTester tester = new MenuTester();
            tester.setComponent(cotxMenu);
            return tester;
        }
        throw new StepExecutionException("Popup could not be opened", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
    }

    public AbstractMenuTester showPopup(int button) {
        return this.showPopup(50, "Percent", 50, "Percent", button);
    }

    public void showToolTip(String text, int textSize, int timePerWord, int windowWidth) {
        StepExecutionException.throwUnsupportedAction();
    }

    public void rcDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        RobotJavaFXImpl robot = this.getRobot();
        this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
        this.pressOrReleaseModifiers(modifier, true);
        robot.mousePress(null, null, mouseButton);
    }

    public void rcDrop(int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        String modifier = dndHelper.getModifier();
        int mouseButton = dndHelper.getMouseButton();
        try {
            this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
            TimeUtil.delay((long)delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, mouseButton);
            this.pressOrReleaseModifiers(modifier, false);
        }
    }

    private void pressOrReleaseModifiers(String modifier, boolean press) {
        RobotJavaFXImpl robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = this.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    private void clickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click(this.getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase("Pixel"), yPos, yUnits.equalsIgnoreCase("Pixel"));
    }

    public int getKeyCode(String key) {
        if (key == null) {
            throw new RobotException("Key is null!", EventFactory.createConfigErrorEvent());
        }
        Integer keyCode = converterTable.get(key.toLowerCase());
        if (keyCode == null) {
            throw new RobotException("No KeyCode found for key '" + key + "'", EventFactory.createConfigErrorEvent());
        }
        return keyCode;
    }

    @Override
    public ReadOnlyObjectProperty<Window> getWindow() {
        return ((Node)this.getRealComponent()).getScene().windowProperty();
    }
}

