/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.driver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.swing.utils.SwingUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class KeyCodeConverter {
    private static Map converterTable = null;

    static {
        converterTable = new HashMap();
        converterTable.put("none", new Integer(-1));
        converterTable.put("shift", new Integer(16));
        converterTable.put("control", new Integer(17));
        converterTable.put("alt", new Integer(18));
        converterTable.put("meta", new Integer(157));
        converterTable.put("cmd", new Integer(157));
        converterTable.put("mod", new Integer(SwingUtils.getSystemDefaultModifier()));
    }

    private KeyCodeConverter() {
    }

    public static int getKeyCode(String key) {
        if (key == null) {
            throw new RobotException("Key is null!", EventFactory.createConfigErrorEvent());
        }
        Integer keyCode = (Integer)converterTable.get(key.toLowerCase());
        if (keyCode == null) {
            throw new RobotException("No KeyCode found for key '" + key + "'", EventFactory.createConfigErrorEvent());
        }
        return keyCode;
    }
}

