/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.model;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.osgi.util.NLS;

public class CommentEntry {
    private static final int MAX_DATA_STRING_LENGTH = 200;
    private String m_timestamp;
    private String m_nodeType;
    private String m_nodeNameAndParams;
    private String m_status;
    private String m_dashboardURL;
    private String m_summaryId;
    private Long m_nodeCount;

    public CommentEntry(TestResultNode resultNode, String dashboardURL, String summaryId, Long nodeCount) {
        this.m_dashboardURL = dashboardURL;
        this.m_summaryId = summaryId;
        this.m_nodeCount = nodeCount;
        Date executionTime = resultNode.getTimeStamp();
        this.m_timestamp = executionTime != null ? executionTime.toString() : Messages.NotAvailable;
        this.m_nodeType = resultNode.getTypeOfNode();
        String paramDescription = StringUtils.abbreviate((String)resultNode.getParameterDescription(), (int)200);
        this.m_nodeNameAndParams = this.getName(resultNode);
        if (!StringUtils.isBlank((String)paramDescription)) {
            this.m_nodeNameAndParams = String.valueOf(this.m_nodeNameAndParams) + " " + paramDescription;
        }
        this.m_status = CommentEntry.hasPassed(resultNode.getStatus()) ? Messages.StatusPassed : Messages.StatusFailed;
    }

    public String getDashboardURL() {
        return String.valueOf(this.m_dashboardURL) + "?" + "summaryId" + "=" + this.m_summaryId + "&" + "resultNode" + "=" + String.valueOf(this.m_nodeCount);
    }

    public String toString() {
        return NLS.bind((String)Messages.NodeComment, (Object[])new String[]{this.m_timestamp, this.m_nodeType, this.m_nodeNameAndParams, this.m_status});
    }

    private String getName(TestResultNode resultNode) {
        StringBuilder nameBuilder = new StringBuilder();
        INodePO node = resultNode.getNode();
        if (node != null) {
            if (node instanceof IExecTestCasePO) {
                String testCaseName;
                IExecTestCasePO testCaseRef = (IExecTestCasePO)node;
                String realName = testCaseRef.getRealName();
                ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
                String string = testCaseName = testCase != null ? testCase.getName() : "";
                if (!StringUtils.isBlank((String)realName)) {
                    nameBuilder.append(realName);
                    nameBuilder.append(" ").append("(").append(testCaseName).append(")");
                } else {
                    nameBuilder.append(testCaseName);
                }
            } else {
                nameBuilder.append(node.getName());
            }
        }
        return nameBuilder.toString();
    }

    public static boolean hasPassed(int statusCode) {
        return statusCode == 1 || statusCode == 8;
    }
}

