/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class OMEditorDndSupport {
    private OMEditorDndSupport() {
    }

    public static void checkTypeCompatibilityAndMove(List<IComponentNamePO> compNamesToMove, IObjectMappingAssoziationPO target, ObjectMappingMultiPageEditor editor) {
        IWritableComponentNameMapper compMapper = editor.getEditorHelper().getEditSupport().getCompMapper();
        IObjectMappingCategoryPO unmappedTechnical = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
        for (IComponentNamePO compName : compNamesToMove) {
            String compNameGuid = compName.getGuid();
            if (target.getLogicalNames().contains(compNameGuid)) continue;
            IObjectMappingAssoziationPO oldAssoc = editor.getOmEditorBP().getAssociation(compNameGuid);
            try {
                compMapper.changeReuse((IComponentNameReuser)target, null, compNameGuid);
                compMapper.changeReuse((IComponentNameReuser)oldAssoc, compNameGuid, null);
                if (OMEditorDndSupport.getSection(target).equals(unmappedTechnical)) {
                    IObjectMappingCategoryPO mapped = editor.getAut().getObjMap().getMappedCategory();
                    IObjectMappingCategoryPO newCategory = editor.getOmEditorBP().createCategory(mapped, target.getCategory());
                    target.getCategory().removeAssociation(target);
                    newCategory.addAssociation(target);
                }
                OMEditorDndSupport.cleanupAssociation(editor, oldAssoc);
            }
            catch (IncompatibleTypeException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
            }
            catch (PMException pme) {
                PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
            }
        }
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)editor.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        editor.getTreeViewer().setExpandedState((Object)target, true);
    }

    private static void cleanupAssociation(ObjectMappingMultiPageEditor editor, IObjectMappingAssoziationPO assoc) {
        if (assoc != null && assoc.getLogicalNames().isEmpty()) {
            IObjectMappingCategoryPO fromCategory = assoc.getCategory();
            if (assoc.getTechnicalName() != null) {
                IObjectMappingCategoryPO unmappedTech = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
                IObjectMappingCategoryPO newCategory = editor.getOmEditorBP().createCategory(unmappedTech, fromCategory);
                fromCategory.removeAssociation(assoc);
                newCategory.addAssociation(assoc);
            } else {
                fromCategory.removeAssociation(assoc);
            }
        }
    }

    public static void checkTypeCompatibilityAndMove(List<IComponentNamePO> compNamesToMove, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO targetSection;
        IObjectMappingCategoryPO unmappedComponentNames = editor.getAut().getObjMap().getUnmappedLogicalCategory();
        if (unmappedComponentNames.equals(targetSection = OMEditorDndSupport.getSection(target))) {
            IWritableComponentNameMapper compMapper = editor.getEditorHelper().getEditSupport().getCompMapper();
            for (IComponentNamePO compName : compNamesToMove) {
                String compNameGuid = compName.getGuid();
                IObjectMappingAssoziationPO oldAssoc = editor.getOmEditorBP().getAssociation(compNameGuid);
                try {
                    IObjectMappingAssoziationPO newAssoc = PoMaker.createObjectMappingAssoziationPO(null, new ArrayList());
                    compMapper.changeReuse((IComponentNameReuser)newAssoc, null, compNameGuid);
                    compMapper.changeReuse((IComponentNameReuser)oldAssoc, compNameGuid, null);
                    target.addAssociation(newAssoc);
                    if (oldAssoc == null || !oldAssoc.getLogicalNames().isEmpty()) continue;
                    IObjectMappingCategoryPO unmappedTech = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
                    IObjectMappingCategoryPO newCategory = editor.getOmEditorBP().createCategory(unmappedTech, oldAssoc.getCategory());
                    oldAssoc.getCategory().removeAssociation(oldAssoc);
                    newCategory.addAssociation(oldAssoc);
                }
                catch (IncompatibleTypeException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
                }
                catch (PMException pme) {
                    PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
                }
            }
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)editor.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            editor.getTreeViewer().refresh((Object)target);
            editor.getTreeViewer().setExpandedState((Object)target, true);
        }
    }

    public static void checkAndMoveAssociations(List<IObjectMappingAssoziationPO> toMove, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO unmappedTechNames = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
        IObjectMappingCategoryPO newSection = OMEditorDndSupport.getSection(target);
        for (IObjectMappingAssoziationPO assoc : toMove) {
            IObjectMappingCategoryPO oldSection = OMEditorDndSupport.getSection(assoc);
            if (oldSection.equals(newSection)) {
                IObjectMappingCategoryPO fromCategory = assoc.getCategory();
                fromCategory.removeAssociation(assoc);
                target.addAssociation(assoc);
                continue;
            }
            if (!unmappedTechNames.equals(newSection)) continue;
            IObjectMappingCategoryPO unmappedCompNames = editor.getAut().getObjMap().getUnmappedLogicalCategory();
            IWritableComponentNameMapper compMapper = editor.getEditorHelper().getEditSupport().getCompMapper();
            for (String compNameGuid : new ArrayList(assoc.getLogicalNames())) {
                try {
                    compMapper.changeReuse((IComponentNameReuser)assoc, compNameGuid, null);
                    IObjectMappingAssoziationPO compNameAssoc = PoMaker.createObjectMappingAssoziationPO(null, new ArrayList());
                    compMapper.changeReuse((IComponentNameReuser)compNameAssoc, null, compNameGuid);
                    unmappedCompNames.addAssociation(compNameAssoc);
                }
                catch (IncompatibleTypeException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
                }
                catch (PMException pme) {
                    PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
                }
            }
            IObjectMappingCategoryPO fromCategory = assoc.getCategory();
            fromCategory.removeAssociation(assoc);
            target.addAssociation(assoc);
        }
        if (!toMove.isEmpty()) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)editor.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            editor.getTreeViewer().setExpandedState((Object)target, true);
        }
    }

    public static boolean isMergeIfNeeded(List<IObjectMappingCategoryPO> toBeMoved, IObjectMappingCategoryPO targetCategory) {
        boolean doIt = true;
        for (IObjectMappingCategoryPO categoryToMove : toBeMoved) {
            Dialog dialog;
            IObjectMappingCategoryPO existingCategory = null;
            for (IObjectMappingCategoryPO child : targetCategory.getUnmodifiableCategoryList()) {
                if (!child.getName().equals(categoryToMove.getName())) continue;
                existingCategory = child;
                break;
            }
            if (existingCategory == null || (dialog = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_MERGE_CATEGORY, (Object[])new Object[]{existingCategory.getName(), targetCategory.getName()}, null)).getReturnCode() != 1) continue;
            doIt = false;
        }
        return doIt;
    }

    public static boolean canMoveAssociations(List<IObjectMappingAssoziationPO> toMove, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        for (IObjectMappingAssoziationPO assoc : toMove) {
            if (OMEditorDndSupport.canMove(assoc, target, editor)) continue;
            return false;
        }
        return true;
    }

    private static boolean canMove(IObjectMappingAssoziationPO assoc, IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        IObjectMappingCategoryPO oldSection = OMEditorDndSupport.getSection(assoc);
        IObjectMappingCategoryPO newSection = OMEditorDndSupport.getSection(target);
        IObjectMappingCategoryPO unmappedTechnicalNames = editor.getAut().getObjMap().getUnmappedTechnicalCategory();
        return unmappedTechnicalNames.equals(newSection) || oldSection.equals(newSection);
    }

    public static boolean canMoveCompNames(IObjectMappingCategoryPO target, ObjectMappingMultiPageEditor editor) {
        return OMEditorDndSupport.getSection(target).equals(editor.getAut().getObjMap().getUnmappedLogicalCategory());
    }

    public static IObjectMappingCategoryPO getSection(IObjectMappingCategoryPO startCategory) {
        return startCategory != null ? startCategory.getSection() : null;
    }

    public static IObjectMappingCategoryPO getSection(IObjectMappingAssoziationPO assoc) {
        return assoc != null ? assoc.getSection() : null;
    }
}

