/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractEditParametersDialog
extends TitleAreaDialog {
    private static final String PARAM_NAME_REGEX = "[a-zA-Z_0-9]*";
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    private static final int INITIAL_SIZE = 600;
    private static final String NAME_COL_NAME = Messages.EditParametersDialogNameTableColumnName;
    private static final String TYPE_COL_NAME = Messages.EditParametersDialogTypeTableColumnName;
    private static final String EMPTY_ENTRY = "";
    private static final String DEFAULT_PARAM_NAME = Messages.EditParametersDialogDefaultNewParameterName;
    private static final String DEFAULT_PARAM_TYPE = "java.lang.String";
    private static final int ERROR_COLOR = 3;
    private static final int NAME_TABLE_COLUMN = 0;
    private static final int TYPE_TABLE_COLUMN = 1;
    private static final String[] TABLE_COLUMNS = new String[]{NAME_COL_NAME, TYPE_COL_NAME};
    private IParameterInterfacePO m_paramInterfaceObj;
    private List<Parameter> m_parameters = new ArrayList<Parameter>();
    private TableViewer m_paramTableViewer;

    public AbstractEditParametersDialog(Shell parentShell, IParameterInterfacePO paramIntObj) {
        super(parentShell);
        this.setParamInterfaceObj(paramIntObj);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.y = 600;
        return initialSize;
    }

    protected boolean generalButtonEnablement() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout();
        area.setLayout((Layout)areaLayout);
        GridData areaGridData = new GridData();
        areaGridData.grabExcessVerticalSpace = true;
        areaGridData.horizontalAlignment = 4;
        areaGridData.verticalAlignment = 4;
        area.setLayoutData((Object)areaGridData);
        this.createNameField(area);
        LayoutUtil.createSeparator((Composite)area);
        this.createParameterTableArea(area);
        LayoutUtil.createSeparator((Composite)area);
        this.refreshTable();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.editParametersDialogContextId");
        this.setHelpAvailable(true);
        return area;
    }

    private void createParameterTableArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.EditParametersDialogParameters);
        this.createAdditionalWidgetsAtTop(parent);
        Composite tableArea = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout(2, false);
        tableArea.setLayout((Layout)areaLayout);
        GridData tableAreaGridData = new GridData();
        tableAreaGridData.grabExcessVerticalSpace = true;
        tableAreaGridData.horizontalAlignment = 4;
        tableAreaGridData.verticalAlignment = 4;
        tableArea.setLayoutData((Object)tableAreaGridData);
        this.createParameterTable(tableArea);
        this.createTableButtons(tableArea);
    }

    protected void createAdditionalWidgetsAtTop(Composite parent) {
    }

    protected void createParameterTable(Composite parent) {
        this.setParamTableViewer(new TableViewer(parent, 67588));
        this.createInnerDataModel();
        GridData paramTableFieldGridData = new GridData();
        paramTableFieldGridData.grabExcessHorizontalSpace = true;
        paramTableFieldGridData.grabExcessVerticalSpace = true;
        paramTableFieldGridData.horizontalAlignment = 4;
        paramTableFieldGridData.verticalAlignment = 4;
        Table table = this.getParamTableViewer().getTable();
        String[] stringArray = TABLE_COLUMNS;
        int n = TABLE_COLUMNS.length;
        int n2 = 0;
        while (n2 < n) {
            String columnText = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnText);
            ++n2;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)paramTableFieldGridData);
        stringArray = table.getColumns();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            col.setWidth(200);
            ++n2;
        }
        this.getParamTableViewer().setColumnProperties(TABLE_COLUMNS);
        this.getParamTableViewer().setContentProvider((IContentProvider)new ParamTableContentProvider());
        this.getParamTableViewer().setLabelProvider((IBaseLabelProvider)new ParamTableLabelProvider());
        this.getParamTableViewer().setInput(this.m_parameters);
        this.createTableCellEditors(table);
        this.getParamTableViewer().setCellModifier(this.getParamTableCellModifier());
        stringArray = this.getParamTableViewer().getCellEditors();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String cellEditor = stringArray[n2];
            cellEditor.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    AbstractEditParametersDialog.this.checkOkButtonEnablement();
                }
            });
            ++n2;
        }
    }

    protected abstract ICellModifier getParamTableCellModifier();

    private void createTableCellEditors(Table table) {
        TextCellEditor paramNameTextCellEditor = new TextCellEditor((Composite)table);
        ((Text)paramNameTextCellEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text txt = (Text)e.widget;
                String oldValue = txt.getText();
                StringBuilder workValue = new StringBuilder(oldValue);
                workValue.replace(e.start, e.end, e.text);
                String newValue = workValue.toString();
                e.doit = Pattern.matches(AbstractEditParametersDialog.PARAM_NAME_REGEX, newValue);
            }
        });
        Set paramTypes = ComponentBuilder.getInstance().getCompSystem().getDataTypes();
        I18nComboBoxCellEditor i18nParamTypesComboBoxEditor = new I18nComboBoxCellEditor((Composite)table, paramTypes.toArray(new String[paramTypes.size()]), 8);
        this.getParamTableViewer().setCellEditors(new CellEditor[]{paramNameTextCellEditor, i18nParamTypesComboBoxEditor});
    }

    private void createInnerDataModel() {
        if (!this.m_parameters.isEmpty()) {
            this.m_parameters.clear();
        }
        List parameterList = this.getParamInterfaceObj().getParameterList();
        for (IParamDescriptionPO descr : parameterList) {
            this.m_parameters.add(new Parameter(descr));
        }
    }

    private void createTableButtons(Composite parent) {
        Composite tableButtonArea = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout(1, true);
        tableButtonArea.setLayout((Layout)areaLayout);
        GridData tableAreaGridData = new GridData();
        tableAreaGridData.grabExcessVerticalSpace = true;
        tableAreaGridData.horizontalAlignment = 4;
        tableAreaGridData.verticalAlignment = 4;
        tableButtonArea.setLayoutData((Object)tableAreaGridData);
        GridData buttonsGridData = new GridData();
        buttonsGridData.grabExcessHorizontalSpace = true;
        buttonsGridData.horizontalAlignment = 4;
        this.createAddButton(tableButtonArea, buttonsGridData);
        this.createDeleteButton(tableButtonArea, buttonsGridData);
        LayoutUtil.createSeparator((Composite)tableButtonArea);
        this.createUpButton(tableButtonArea, buttonsGridData);
        this.createDownButton(tableButtonArea, buttonsGridData);
    }

    private Button createDeleteButton(Composite parent, GridData layoutData) {
        Button deleteButton = new Button(parent, 0);
        deleteButton.setText(Messages.EditParametersDialogRemove);
        deleteButton.setLayoutData((Object)layoutData);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                AbstractEditParametersDialog.this.removeSelectedParameter();
                AbstractEditParametersDialog.this.checkOkButtonEnablement();
            }
        });
        SelectionBasedButtonEnabler buttonEnabler = new SelectionBasedButtonEnabler(deleteButton);
        this.getParamTableViewer().addSelectionChangedListener((ISelectionChangedListener)buttonEnabler);
        this.afterDeleteButtonCreation(deleteButton, buttonEnabler);
        deleteButton.setEnabled(!this.getParamTableViewer().getSelection().isEmpty());
        return deleteButton;
    }

    protected void afterDeleteButtonCreation(Button deleteButton, SelectionBasedButtonEnabler buttonEnabler) {
    }

    private Button createUpButton(Composite parent, GridData layoutData) {
        Button upButton = new Button(parent, 0);
        upButton.setText(Messages.EditParametersDialogUp);
        upButton.setLayoutData((Object)layoutData);
        upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                AbstractEditParametersDialog.this.moveParameter(false);
            }
        });
        SelectionBasedButtonEnabler buttonEnabler = new SelectionBasedButtonEnabler(upButton);
        this.getParamTableViewer().addSelectionChangedListener((ISelectionChangedListener)buttonEnabler);
        this.afterUpButtonCreation(upButton, buttonEnabler);
        upButton.setEnabled(!this.getParamTableViewer().getSelection().isEmpty());
        return upButton;
    }

    protected void afterUpButtonCreation(Button upButton, SelectionBasedButtonEnabler buttonEnabler) {
    }

    private Button createDownButton(Composite parent, GridData layoutData) {
        Button downButton = new Button(parent, 0);
        downButton.setText(Messages.EditParametersDialogDown);
        downButton.setLayoutData((Object)layoutData);
        downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                AbstractEditParametersDialog.this.moveParameter(true);
            }
        });
        SelectionBasedButtonEnabler buttonEnabler = new SelectionBasedButtonEnabler(downButton);
        this.getParamTableViewer().addSelectionChangedListener((ISelectionChangedListener)buttonEnabler);
        this.afterDownButtonCreation(downButton, buttonEnabler);
        downButton.setEnabled(!this.getParamTableViewer().getSelection().isEmpty());
        return downButton;
    }

    protected void afterDownButtonCreation(Button downButton, SelectionBasedButtonEnabler buttonEnabler) {
    }

    private Button createAddButton(Composite parent, GridData layoutData) {
        Button addButton = new Button(parent, 0);
        addButton.setText(Messages.EditParametersDialogAdd);
        addButton.setLayoutData((Object)layoutData);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleSelection(e);
            }

            private void handleSelection(SelectionEvent e) {
                AbstractEditParametersDialog.this.addParameter();
                AbstractEditParametersDialog.this.checkOkButtonEnablement();
            }
        });
        this.afterAddButtonCreation(addButton);
        return addButton;
    }

    protected void afterAddButtonCreation(Button addButton) {
    }

    private void addParameter() {
        String newParamName = DEFAULT_PARAM_NAME;
        boolean unique = true;
        int count = 0;
        block0: do {
            for (Parameter p : this.m_parameters) {
                unique = true;
                if (!p.getName().equals(newParamName)) continue;
                unique = false;
                newParamName = String.valueOf(DEFAULT_PARAM_NAME) + ++count;
                continue block0;
            }
        } while (!unique);
        Parameter parameter = new Parameter(newParamName, DEFAULT_PARAM_TYPE);
        this.m_parameters.add(parameter);
        this.refreshTable();
        this.selectRowInParameterTable(-1);
        this.getParamTableViewer().editElement((Object)parameter, 0);
    }

    private void selectRowInParameterTable(int row) {
        boolean selectLast = row == -1;
        Table table = this.getParamTableViewer().getTable();
        int tableItemCount = table.getItemCount();
        int index = row;
        if (selectLast && (index = tableItemCount - 1) == -1) {
            return;
        }
        if (index > tableItemCount) {
            return;
        }
        Object selectedObject = this.getParamTableViewer().getElementAt(index);
        if (selectedObject != null) {
            this.getParamTableViewer().setSelection((ISelection)new StructuredSelection(selectedObject));
        }
    }

    private void removeSelectedParameter() {
        int index;
        int[] selectionIndices;
        if (!this.confirmDeleteParam()) {
            return;
        }
        Table table = this.getParamTableViewer().getTable();
        int[] nArray = selectionIndices = table.getSelectionIndices();
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            index = nArray[n2];
            this.m_parameters.remove(index);
            ++n2;
        }
        if (selectionIndices.length > 0) {
            index = selectionIndices[selectionIndices.length - 1];
            this.refreshTable();
            int tableItemCount = table.getItemCount();
            if (index >= tableItemCount) {
                index = -1;
            }
            this.selectRowInParameterTable(index);
        }
    }

    private boolean confirmDeleteParam() {
        Dialog dialog = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_CHANGE_INTERFACE_REMOVE_PARAM, null, null, (Shell)this.getShell());
        return dialog.getReturnCode() == 0;
    }

    private boolean confirmChangeParamType() {
        Dialog dialog = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_CHANGE_INTERFACE_CHANGE_PARAM_TYPE, null, null, (Shell)this.getShell());
        return dialog.getReturnCode() == 0;
    }

    private void createNameField(Composite parent) {
        Composite nameFieldArea = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout(2, false);
        nameFieldArea.setLayout((Layout)areaLayout);
        GridData tableAreaGridData = new GridData();
        tableAreaGridData.horizontalAlignment = 4;
        nameFieldArea.setLayoutData((Object)tableAreaGridData);
        Label nameLabel = new Label(nameFieldArea, 0);
        nameLabel.setText(this.getEditedObjectNameString());
        Label nameField = new Label(nameFieldArea, 4);
        GridData nameFieldGridData = new GridData();
        nameFieldGridData.grabExcessHorizontalSpace = true;
        nameFieldGridData.horizontalAlignment = 4;
        nameField.setLayoutData((Object)nameFieldGridData);
        nameField.setText(this.getParamInterfaceObj().getName());
    }

    protected abstract String getEditedObjectNameString();

    public final List<Parameter> getParameters() {
        return this.m_parameters;
    }

    private int getColumnIndex(String columnName) {
        int index = 0;
        String[] stringArray = TABLE_COLUMNS;
        int n = TABLE_COLUMNS.length;
        int n2 = 0;
        while (n2 < n) {
            String colName = stringArray[n2];
            if (colName.equals(columnName)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private String getTableCellText(Parameter parameter, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return parameter.getName();
            }
            case 1: {
                String paramType = parameter.getType();
                return CompSystemI18n.getString((String)paramType, (boolean)true);
            }
        }
        StringBuilder msg = new StringBuilder();
        msg.append(Messages.ColumnIndex).append(" ").append("'").append(columnIndex).append("'").append(" ").append(Messages.DoesNotExist).append("!");
        Assert.notReached((String)msg.toString());
        return EMPTY_ENTRY;
    }

    private void setTableCellText(Object value, Parameter parameter, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.changeParameterName(parameter, (String)value);
                break;
            }
            case 1: {
                this.changeParameterType(parameter, (String)value);
                break;
            }
            default: {
                StringBuilder msg = new StringBuilder();
                msg.append(Messages.ColumnIndex).append(" ").append("'").append(columnIndex).append("'").append(" ").append(Messages.DoesNotExist).append("!");
                Assert.notReached((String)msg.toString());
            }
        }
        this.refreshTable();
    }

    private void changeParameterName(Parameter parameter, String name) {
        if (parameter.getName().equals(name)) {
            return;
        }
        if (this.isNewParameter(parameter)) {
            parameter.setName(name);
        } else if (this.confirmChangeParamName()) {
            parameter.setName(name);
        }
    }

    protected boolean confirmChangeParamName() {
        return true;
    }

    private void changeParameterType(Parameter parameter, String type) {
        if (parameter.getType().equals(type)) {
            return;
        }
        if (this.isNewParameter(parameter)) {
            parameter.setType(type);
        } else if (this.confirmChangeParamType()) {
            int index = this.m_parameters.indexOf(parameter);
            Parameter newParam = new Parameter(parameter.getName(), type);
            this.m_parameters.remove(parameter);
            this.m_parameters.add(index, newParam);
        }
    }

    private boolean isNewParameter(Parameter parameter) {
        return parameter.getGuid() == null;
    }

    private void refreshTable() {
        this.getParamTableViewer().refresh();
        Table table = this.getParamTableViewer().getTable();
        table.setFocus();
    }

    private Button getOkButton() {
        return this.getButton(0);
    }

    private void checkOkButtonEnablement() {
        this.getOkButton().setEnabled(this.isParamTableValid());
    }

    private boolean isParamTableValid() {
        for (Parameter param : this.getParameters()) {
            if (EMPTY_ENTRY.equals(param.getName().trim())) {
                this.setErrorMessage(Messages.EditParametersDialogEmptyParamName);
                return false;
            }
            if (EMPTY_ENTRY.equals(param.getType().trim())) {
                this.setErrorMessage(Messages.EditParametersDialogEmptyParamName);
                return false;
            }
            if (!this.isDuplicate(param)) continue;
            this.setErrorMessage(NLS.bind((String)Messages.EditParametersDialogDuplicateParamName, (Object)param.getName()));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isDuplicate(Parameter parameter) {
        int occurences = 0;
        for (Parameter param : this.m_parameters) {
            if (param.equals(parameter)) {
                ++occurences;
            }
            if (occurences <= 1) continue;
            return true;
        }
        return false;
    }

    private Integer[] getIndices(Parameter parameter) {
        ArrayList<Integer> occurenceIndices = new ArrayList<Integer>();
        int index = 0;
        for (Parameter param : this.m_parameters) {
            if (param.equals(parameter)) {
                occurenceIndices.add(index);
            }
            ++index;
        }
        return occurenceIndices.toArray(new Integer[occurenceIndices.size()]);
    }

    private void moveParameter(boolean down) {
        if (this.getParamTableViewer().getSelection() instanceof IStructuredSelection) {
            int newIdx;
            Parameter param = (Parameter)((IStructuredSelection)this.getParamTableViewer().getSelection()).getFirstElement();
            int paramIdx = this.m_parameters.indexOf(param);
            int n = newIdx = down ? paramIdx + 1 : paramIdx - 1;
            if (newIdx < this.m_parameters.size() && newIdx > -1) {
                this.m_parameters.remove(paramIdx);
                this.m_parameters.add(newIdx, param);
                this.refreshTable();
            }
        }
    }

    private void setParamTableViewer(TableViewer paramTableViewer) {
        this.m_paramTableViewer = paramTableViewer;
    }

    protected TableViewer getParamTableViewer() {
        return this.m_paramTableViewer;
    }

    protected void setParamInterfaceObj(IParameterInterfacePO paramInterfaceObj) {
        this.m_paramInterfaceObj = paramInterfaceObj;
    }

    protected IParameterInterfacePO getParamInterfaceObj() {
        return this.m_paramInterfaceObj;
    }

    protected abstract class AbstractTableCellModifier
    implements ICellModifier {
        protected AbstractTableCellModifier() {
        }

        public abstract boolean canModify(Object var1, String var2);

        public Object getValue(Object element, String property) {
            int columnIndex = AbstractEditParametersDialog.this.getColumnIndex(property);
            return AbstractEditParametersDialog.this.getTableCellText((Parameter)element, columnIndex);
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Parameter parameter = (Parameter)tableItem.getData();
            int columnIndex = AbstractEditParametersDialog.this.getColumnIndex(property);
            AbstractEditParametersDialog.this.setTableCellText(value, parameter, columnIndex);
        }
    }

    private static final class I18nComboBoxCellEditor
    extends ComboBoxCellEditor {
        private String[] m_modelItems;

        public I18nComboBoxCellEditor(Composite parent, String[] items, int style) {
            super(parent, items, style);
            this.m_modelItems = items;
            this.translateModelItems();
        }

        protected void translateModelItems() {
            int itemSize = this.m_modelItems.length;
            String[] translatedItems = new String[itemSize];
            int i = 0;
            String[] stringArray = this.m_modelItems;
            int n = this.m_modelItems.length;
            int n2 = 0;
            while (n2 < n) {
                String translatedItem;
                String item = stringArray[n2];
                translatedItems[i] = translatedItem = CompSystemI18n.getString((String)item);
                ++i;
                ++n2;
            }
            this.setItems(translatedItems);
        }

        protected Object doGetValue() {
            int selectedIndex = (Integer)super.doGetValue();
            return this.getModelItems()[selectedIndex];
        }

        protected void doSetValue(Object value) {
            int index = Arrays.asList(this.getItems()).indexOf(value);
            if (index < 0) {
                index = 0;
            }
            super.doSetValue((Object)index);
        }

        public String[] getModelItems() {
            return this.m_modelItems;
        }
    }

    private static final class ParamTableContentProvider
    implements IStructuredContentProvider {
        private ParamTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ParamTableLabelProvider
    implements ITableLabelProvider {
        private ParamTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Parameter parameter;
            if (columnIndex == 0 && (AbstractEditParametersDialog.EMPTY_ENTRY.equals((parameter = (Parameter)element).getName().trim()) || AbstractEditParametersDialog.EMPTY_ENTRY.equals(parameter.getType().trim()) || AbstractEditParametersDialog.this.isDuplicate(parameter))) {
                return IconConstants.ERROR_IMAGE;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Parameter parameter = (Parameter)element;
            String text = AbstractEditParametersDialog.this.getTableCellText(parameter, columnIndex);
            this.setCellBackground(parameter);
            return text;
        }

        private void setCellBackground(Parameter parameter) {
            Table table = AbstractEditParametersDialog.this.getParamTableViewer().getTable();
            Color rowColor = null;
            if (AbstractEditParametersDialog.EMPTY_ENTRY.equals(parameter.getName().trim()) || AbstractEditParametersDialog.EMPTY_ENTRY.equals(parameter.getType().trim()) || AbstractEditParametersDialog.this.isDuplicate(parameter)) {
                rowColor = table.getDisplay().getSystemColor(3);
            }
            Integer[] indices = AbstractEditParametersDialog.this.getIndices(parameter);
            int itemCount = table.getItemCount();
            Integer[] integerArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                int index = integerArray[n2];
                if (index < itemCount) {
                    TableItem item = table.getItem(index);
                    item.setBackground(0, rowColor);
                }
                ++n2;
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static final class Parameter {
        private String m_guid;
        private String m_name = "";
        private String m_type = "";

        public Parameter(String name, String type) {
            this.m_name = name;
            this.m_type = type;
        }

        public Parameter(String guid, String name, String type) {
            this(name, type);
            this.m_guid = guid;
        }

        public Parameter(IParamDescriptionPO descr) {
            this(descr.getUniqueId(), descr.getName(), descr.getType());
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name == null ? AbstractEditParametersDialog.EMPTY_ENTRY : name;
        }

        public String getType() {
            return this.m_type;
        }

        public void setType(String type) {
            this.m_type = type == null ? AbstractEditParametersDialog.EMPTY_ENTRY : type;
        }

        public String getGuid() {
            return this.m_guid;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Parameter)) {
                return false;
            }
            Parameter param = (Parameter)obj;
            return this.m_name.equals(param.m_name);
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }
    }

    protected final class SelectionBasedButtonEnabler
    implements ISelectionChangedListener,
    SelectionListener {
        private final Button m_button;

        private SelectionBasedButtonEnabler(Button button) {
            this.m_button = button;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.handleSelection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelection();
        }

        private void handleSelection() {
            this.m_button.setEnabled(AbstractEditParametersDialog.this.generalButtonEnablement() && !AbstractEditParametersDialog.this.getParamTableViewer().getSelection().isEmpty());
        }
    }
}

