/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.State;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractStartTestHandler
extends AbstractHandler {
    public static boolean prepareTestExecution() {
        IClientTest clientTest = ClientTest.instance();
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("GENERATEREPORT_KEY")) {
            URL xslUrl = TestResultBP.getInstance().getXslFileURL();
            if (xslUrl == null) {
                Plugin.getDefault().handleError(new JBException(Messages.FileNotFoundFormatXsl, MessageIDs.E_FILE_NOT_FOUND));
                return false;
            }
            clientTest.setLogPath(preferenceStore.getString("RESULTPATH_PREF_KEY"));
            clientTest.setLogStyle(preferenceStore.getString("REPORTGENERATORSTYLE_KEY"));
        } else {
            clientTest.setLogPath(null);
            clientTest.setLogStyle(null);
        }
        return true;
    }

    protected boolean initTestExecution(ExecutionEvent event) {
        return this.initTestExecutionRelevantFlag() && this.initPauseTestExecutionState(event);
    }

    private boolean initPauseTestExecutionState(ExecutionEvent event) {
        Command command;
        ICommandService cmdService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
        if (cmdService != null && (command = cmdService.getCommand("org.eclipse.jubula.client.ui.rcp.commands.PauseTestSuiteCommand")) != null) {
            final Display display = Plugin.getDisplay();
            ITestExecutionEventListener l = new ITestExecutionEventListener(){

                public void endTestExecution() {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            State state = command.getState("org.eclipse.ui.commands.toggleState");
                            state.setValue((Object)false);
                        }
                    });
                    ClientTest.instance().removeTestExecutionEventListener((ITestExecutionEventListener)this);
                }

                public void stateChanged(final TestExecutionEvent tee) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            State state = command.getState("org.eclipse.ui.commands.toggleState");
                            boolean newToggleStateValue = tee.getState() == TestExecutionEvent.State.TEST_EXEC_PAUSED;
                            state.setValue((Object)newToggleStateValue);
                        }
                    });
                }
            };
            ClientTest.instance().addTestExecutionEventListener(l);
            return true;
        }
        return false;
    }

    private boolean initTestExecutionRelevantFlag() {
        final IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        int value = preferenceStore.getInt("TEST_EXECUTION_RELEVANT");
        IClientTest clientTest = ClientTest.instance();
        if (value == 0) {
            clientTest.setRelevantFlag(true);
            return true;
        }
        if (value == 1) {
            clientTest.setRelevantFlag(false);
            return true;
        }
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getActiveShell(), Messages.TestExecRelevantDialogTitle, null, Messages.TestExecRelevantDialogQuestion, 3, new String[]{Messages.UtilsYes, Messages.UtilsNo}, 0, Messages.UtilsRemember, false){

            protected void buttonPressed(int buttonId) {
                super.buttonPressed(buttonId);
                preferenceStore.setValue("TEST_EXECUTION_RELEVANT_REMEMBER_KEY", this.getToggleState());
                int val = 2;
                if (this.getToggleState() && this.getReturnCode() == 257) {
                    val = 1;
                } else if (this.getToggleState() && this.getReturnCode() == 256) {
                    val = 0;
                }
                preferenceStore.setValue("TEST_EXECUTION_RELEVANT", val);
            }
        };
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        clientTest.setRelevantFlag(true);
        if (dialog.getReturnCode() == 257) {
            clientTest.setRelevantFlag(false);
        } else if (dialog.getReturnCode() == -1) {
            clientTest.setRelevantFlag(false);
            return false;
        }
        return true;
    }
}

