/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.XmlStorage;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportProjectHandler
extends AbstractProjectHandler {
    private static Logger log = LoggerFactory.getLogger(ExportProjectHandler.class);

    private void showExportDialog() {
        FileDialog fileDialog = new FileDialog(this.getActiveShell(), 73728);
        fileDialog.setText(Messages.ActionBuilderSaveAs);
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        fileDialog.setFilterPath(Utils.getLastDirPath());
        StringBuilder sb = new StringBuilder(GeneralStorage.getInstance().getProject().getDisplayName());
        fileDialog.setFileName(sb.append(".xml").toString());
        String fileNameTemp = fileDialog.open();
        if (fileNameTemp == null) {
            return;
        }
        File file = new File(fileNameTemp);
        if (file.exists()) {
            MessageBox mb = new MessageBox(fileDialog.getParent(), 200);
            mb.setText(Messages.ExportFileActionConfirmOverwriteTitle);
            mb.setMessage(NLS.bind((String)Messages.ExportFileActionConfirmOverwrite, (Object)fileNameTemp));
            if (mb.open() == 128) {
                return;
            }
        }
        Plugin.startLongRunning(Messages.ExportFileActionWaitWhileExporting);
        String fileName = fileNameTemp;
        Utils.storeLastDirPath(fileDialog.getFilterPath());
        ExportFileOperation op = new ExportFileOperation(fileName);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ite) {
            log.error(ite.getLocalizedMessage(), ite.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }

    public Object executeImpl(ExecutionEvent event) {
        if (Plugin.getDefault().showSaveEditorDialog()) {
            this.showExportDialog();
        }
        Plugin.stopLongRunning();
        return null;
    }

    private static final class ExportFileOperation
    implements IRunnableWithProgress {
        private final String m_fileName;

        private ExportFileOperation(String fileName) {
            this.m_fileName = fileName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(IProgressMonitor monitor) {
            if (this.m_fileName != null) {
                try {
                    try {
                        GeneralStorage gstorage = GeneralStorage.getInstance();
                        gstorage.validateProjectExists(gstorage.getProject());
                        final AtomicReference statusOfRefresh = new AtomicReference();
                        Plugin.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                RefreshProjectHandler rph = new RefreshProjectHandler();
                                statusOfRefresh.set((IStatus)rph.executeImpl(null));
                            }
                        });
                        if (statusOfRefresh.get() == null || !((IStatus)statusOfRefresh.get()).isOK()) return;
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportFileActionExporting, (int)1);
                        XmlStorage.save((IProjectPO)gstorage.getProject(), (String)this.m_fileName, (boolean)true, (IProgressMonitor)subMonitor.newChild(1), (boolean)false, null);
                        return;
                    }
                    catch (PMException e) {
                        ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                        monitor.done();
                        Plugin.stopLongRunning();
                        return;
                    }
                    catch (ProjectDeletedException projectDeletedException) {
                        PMExceptionHandler.handleProjectDeletedException();
                        monitor.done();
                        Plugin.stopLongRunning();
                        return;
                    }
                }
                finally {
                    monitor.done();
                    Plugin.stopLongRunning();
                }
            } else {
                monitor.done();
            }
        }
    }
}

