/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.MasterSessionComponentNameMapper;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.AbstractMatchSelectionPage;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComponentNameMappingWizardPage
extends AbstractMatchSelectionPage {
    private Map<String, ComboViewer> m_componentNamesMapping;
    private ISpecTestCasePO m_newSpec;
    private boolean m_noMatchingType = false;
    private LinkedList<ICompNamesPairPO> m_oldCompNamePairs = new LinkedList();
    private CompNamesBP m_compNamesBP = new CompNamesBP();

    public ComponentNameMappingWizardPage(String pageName, Set<IExecTestCasePO> execTCList) {
        super(pageName, Messages.ReplaceTCRWizard_matchComponentNames_title, null);
        for (IExecTestCasePO exec : execTCList) {
            this.m_oldCompNamePairs.addAll(this.m_compNamesBP.getAllCompNamesPairs(exec));
        }
    }

    public void setNewSpec(ISpecTestCasePO newSpec) {
        this.m_newSpec = newSpec;
        this.m_noMatchingType = false;
        this.m_componentNamesMapping = new HashMap<String, ComboViewer>();
    }

    private void createLayoutWithData(Composite parent) {
        IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)this.m_newSpec);
        List compNamePairs = this.m_compNamesBP.getAllCompNamesPairs(newExec);
        if (compNamePairs.size() == 0) {
            return;
        }
        this.createMatchingFields(parent);
        parent.pack();
    }

    private void createMatchingFields(Composite parent) {
        IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)this.m_newSpec);
        List compNamePairs = this.m_compNamesBP.getAllCompNamesPairs(newExec);
        for (ICompNamesPairPO compNamesPair : compNamePairs) {
            GridData leftGridData = new GridData();
            leftGridData.horizontalAlignment = 16384;
            leftGridData.verticalAlignment = 1;
            GridData rightGridData = new GridData();
            rightGridData.horizontalAlignment = 4;
            rightGridData.verticalAlignment = 1;
            rightGridData.minimumWidth = 200;
            rightGridData.grabExcessHorizontalSpace = true;
            IComponentNamePO newComponentName = ComponentNamesBP.getInstance().getCompNamePo(compNamesPair.getFirstName());
            String displayName = this.getDisplayName(newComponentName.getName(), newComponentName.getComponentType());
            Label compname = new Label(parent, 0);
            compname.setText(displayName);
            compname.setLayoutData((Object)leftGridData);
            Control comboOrLabel = this.createControlWithOldComponentNames(newComponentName, parent);
            comboOrLabel.setLayoutData((Object)rightGridData);
            comboOrLabel.pack();
        }
    }

    private Control createControlWithOldComponentNames(IComponentNamePO componentName, Composite parent) {
        int counter = 1;
        LinkedList<String> listOfMatchingCompNames = new LinkedList<String>();
        listOfMatchingCompNames.add(" ");
        int selection = 0;
        for (ICompNamesPairPO oldPairs : this.m_oldCompNamePairs) {
            IComponentNamePO oldComponent = ComponentNamesBP.getInstance().getCompNamePo(oldPairs.getFirstName());
            String isCompatible = ComponentNamesBP.getInstance().isCompatible(componentName.getComponentType(), oldComponent.getName(), (IComponentNameMapper)MasterSessionComponentNameMapper.getInstance(), null, true);
            if (isCompatible != null || listOfMatchingCompNames.contains(oldComponent.getGuid())) continue;
            listOfMatchingCompNames.add(oldComponent.getGuid());
            if (componentName.getName().equals(oldComponent.getName()) && componentName.getComponentType().equals(oldComponent.getComponentType())) {
                selection = counter;
            }
            ++counter;
        }
        if (listOfMatchingCompNames.size() > 1) {
            return this.createCombo(componentName, parent, listOfMatchingCompNames, selection);
        }
        Label label = new Label(parent, 0);
        label.setText(Messages.ReplaceTCRWizard_matchComponentNames_warningNoSameType);
        ControlDecorator.addWarningDecorator((Control)label, Messages.ReplaceTCRWizard_matchComponentNames_warningNoSameTypeDesc);
        this.m_noMatchingType = true;
        return label;
    }

    private Combo createCombo(IComponentNamePO componentName, Composite parent, List<String> listOfMatchingCompNames, int selection) {
        final Combo oldCompNamesCombo = new Combo(parent, 8);
        ComboViewer comboViewer = new ComboViewer(oldCompNamesCombo);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    String guid = (String)element;
                    if (!StringUtils.isBlank((String)((String)element))) {
                        IComponentNamePO newComponentName = ComponentNamesBP.getInstance().getCompNamePo(guid);
                        return ComponentNameMappingWizardPage.this.getDisplayName(newComponentName.getGuid(), newComponentName.getComponentType());
                    }
                }
                return " ";
            }
        });
        comboViewer.setInput((Object)listOfMatchingCompNames.toArray());
        this.m_componentNamesMapping.put(componentName.getGuid(), comboViewer);
        final ControlDecorator notMappedDecoration = ControlDecorator.addWarningDecorator((Control)oldCompNamesCombo, Messages.ReplaceTCRWizard_matchComponentNames_warningUnmatchedComp);
        oldCompNamesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                notMappedDecoration.setVisible(oldCompNamesCombo.getSelectionIndex() == 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (selection != 0) {
            oldCompNamesCombo.select(selection);
            notMappedDecoration.setVisible(false);
        }
        return oldCompNamesCombo;
    }

    private String getDisplayName(String guidName, String guidType) {
        String firstName = ComponentNamesBP.getInstance().getName(guidName);
        String type = CompSystemI18n.getString((String)guidType);
        String displayName = firstName;
        if (!StringUtils.isBlank((String)type)) {
            displayName = String.valueOf(displayName) + " [" + type + "]";
        }
        return displayName;
    }

    public Map<String, String> getCompMatching() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (Map.Entry<String, ComboViewer> entry : this.m_componentNamesMapping.entrySet()) {
            String guidOfCompName = entry.getKey();
            IViewerObservableValue value = ViewersObservables.observeSingleSelection((Viewer)((Viewer)entry.getValue()));
            String guidOfMappedCompName = (String)value.getValue();
            mapping.put(guidOfCompName, guidOfMappedCompName);
        }
        return mapping;
    }

    @Override
    protected void createSelectionTable(Composite parent) {
        if (this.m_componentNamesMapping.size() == 0) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            ComponentNameMappingWizardPage.createHeadLabel(parent, Messages.ReplaceTCRWizard_ComponentNameMapping_newTC);
            ComponentNameMappingWizardPage.createHeadLabel(parent, Messages.ReplaceTCRWizard_ComponentNameMapping_oldTC);
            this.createLayoutWithData(parent);
            this.updateAdditionalInformation();
        }
    }

    private void updateAdditionalInformation() {
        IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)this.m_newSpec);
        List compNamePairs = this.m_compNamesBP.getAllCompNamesPairs(newExec);
        ArrayList<String> messages = new ArrayList<String>();
        HashSet<String> oldCompNames = new HashSet<String>();
        for (ICompNamesPairPO pair : this.m_oldCompNamePairs) {
            oldCompNames.add(pair.getFirstName());
        }
        if (compNamePairs.size() == 0 && oldCompNames.size() == 0) {
            messages.add(Messages.ReplaceTCRWizard_matchComponentNames_infoNotNecessary);
        }
        if (compNamePairs.size() < oldCompNames.size()) {
            messages.add(Messages.ReplaceTCRWizard_matchComponentNames_infoOldMore);
        }
        if (this.m_noMatchingType) {
            messages.add(Messages.ReplaceTCRWizard_matchComponentNames_infoNoType);
        }
        this.setAdditionalInformation(messages);
    }

    public void performHelp() {
        Plugin.getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.searchRefactorReplaceExecutionTestCaseWizardContextId");
    }
}

