/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.model.ALMChange;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.osgi.util.NLS;

public class CommentEntry
extends ALMChange {
    private String m_status;

    public CommentEntry(TestResultNode resultNode, String dashboardURL, String summaryId, Long nodeCount) {
        super(resultNode, dashboardURL, summaryId, nodeCount);
        this.setNodeNameAndParams(this.getName(resultNode));
        this.m_status = CommentEntry.hasPassed(resultNode.getStatus()) ? Messages.StatusPassed : Messages.StatusFailed;
        String paramDescription = StringUtils.abbreviate((String)resultNode.getParameterDescription(), (int)200);
        if (!StringUtils.isBlank((String)paramDescription)) {
            this.setNodeNameAndParams(String.valueOf(this.getNodeNameAndParams()) + " " + paramDescription);
        }
    }

    public String toString() {
        return NLS.bind((String)Messages.NodeComment, (Object[])new String[]{this.getTimestamp(), this.getNodeType(), this.getNodeNameAndParams(), this.m_status});
    }

    protected String getName(TestResultNode resultNode) {
        StringBuilder nameBuilder = new StringBuilder();
        INodePO node = resultNode.getNode();
        if (node != null) {
            if (node instanceof IExecTestCasePO) {
                String testCaseName;
                IExecTestCasePO testCaseRef = (IExecTestCasePO)node;
                String realName = testCaseRef.getRealName();
                ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
                String string = testCaseName = testCase != null ? testCase.getName() : "";
                if (!StringUtils.isBlank((String)realName)) {
                    nameBuilder.append(realName);
                    nameBuilder.append(" ").append("(").append(testCaseName).append(")");
                } else {
                    nameBuilder.append(testCaseName);
                }
            } else {
                nameBuilder.append(node.getName());
            }
        }
        return nameBuilder.toString();
    }

    public static boolean hasPassed(int statusCode) {
        return statusCode == 1 || statusCode == 8;
    }
}

