/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.model.IModifiableParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractEditParametersHandler
extends AbstractHandler {
    protected IJBEditor getEditor(ExecutionEvent event) {
        Object adapter;
        IWorkbenchPart activeEditor = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activeEditor != null && (adapter = activeEditor.getAdapter(IJBEditor.class)) != null) {
            return (IJBEditor)adapter;
        }
        return null;
    }

    protected static int getNewParamIndex(IParamDescriptionPO paramDesc, List<AbstractEditParametersDialog.Parameter> paramList) {
        int i = 0;
        while (i < paramList.size()) {
            String paramGuid = paramList.get(i).getGuid();
            if (paramGuid != null && paramGuid.equals(paramDesc.getUniqueId())) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < paramList.size()) {
            if (paramList.get(i).getName().equals(paramDesc.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static <T extends IModifiableParameterInterfacePO> boolean editParameters(T paramIntObj, List<AbstractEditParametersDialog.Parameter> parameters, boolean isInterfaceLocked, ParamNameBPDecorator mapper, AbstractParamInterfaceBP<T> paramInterfaceBP) {
        Map<String, IParamDescriptionPO> oldParamsMap = AbstractEditParametersHandler.createOldParamsMap(paramIntObj);
        ArrayList<AbstractEditParametersDialog.Parameter> paramsToAdd = new ArrayList<AbstractEditParametersDialog.Parameter>();
        ArrayList<AbstractEditParametersDialog.Parameter> params = new ArrayList<AbstractEditParametersDialog.Parameter>(parameters);
        for (AbstractEditParametersDialog.Parameter parameter : parameters) {
            if (parameter.getGuid() != null) continue;
            paramsToAdd.add(parameter);
            params.remove(parameter);
        }
        HashMap<IParamDescriptionPO, String> paramsToRename = new HashMap<IParamDescriptionPO, String>();
        HashMap<IParamDescriptionPO, String> paramsToChangeUsage = new HashMap<IParamDescriptionPO, String>();
        for (AbstractEditParametersDialog.Parameter param : params) {
            IParamDescriptionPO paramDescr = oldParamsMap.get(param.getGuid());
            if (paramDescr != null) {
                if (paramDescr.getName().equals(param.getName())) continue;
                AbstractEditParametersDialog.Parameter paramNotRenamed = AbstractEditParametersHandler.getNotRenamedParamWithSameName(oldParamsMap, params, param);
                if (paramNotRenamed == null) {
                    paramsToRename.put(paramDescr, param.getName());
                    continue;
                }
                paramsToChangeUsage.put(paramDescr, paramNotRenamed.getGuid());
                continue;
            }
            Assert.notReached((String)(String.valueOf(Messages.UnexpectedError) + ":" + " " + Messages.ModificationOfNonExistingParameter + "."));
        }
        List<IParamDescriptionPO> paramsToRemove = AbstractEditParametersHandler.findParamsToRemove(parameters, oldParamsMap);
        boolean isInterfaceLockedChanged = false;
        ISpecTestCasePO specTc = null;
        if (paramIntObj instanceof ISpecTestCasePO) {
            specTc = (ISpecTestCasePO)paramIntObj;
            isInterfaceLockedChanged = specTc.isInterfaceLocked() != isInterfaceLocked;
            TestCaseParamBP.setInterfaceLocked((ISpecTestCasePO)specTc, (boolean)isInterfaceLocked);
        }
        AbstractEditParametersHandler.updateModel(paramIntObj, mapper, paramInterfaceBP, paramsToAdd, paramsToRename, paramsToChangeUsage, paramsToRemove);
        boolean moved = AbstractEditParametersHandler.moveParameters(paramIntObj, parameters);
        return !paramsToRemove.isEmpty() || !paramsToAdd.isEmpty() || !paramsToRename.isEmpty() || !paramsToChangeUsage.isEmpty() || moved || isInterfaceLockedChanged;
    }

    private static <T extends IModifiableParameterInterfacePO> void updateModel(T paramIntObj, ParamNameBPDecorator mapper, AbstractParamInterfaceBP<T> paramInterfaceBP, List<AbstractEditParametersDialog.Parameter> paramsToAdd, Map<IParamDescriptionPO, String> paramsToRename, Map<IParamDescriptionPO, String> paramsToChangeUsage, List<IParamDescriptionPO> paramsToRemove) {
        for (AbstractEditParametersDialog.Parameter addParam : paramsToAdd) {
            paramInterfaceBP.addParameter(addParam.getName(), addParam.getType(), paramIntObj, (IParamNameMapper)mapper);
        }
        List projLangs = GeneralStorage.getInstance().getProject().getLangHelper().getLanguageList();
        for (IParamDescriptionPO desc : paramsToRemove) {
            for (Locale locale : projLangs) {
                paramInterfaceBP.removeParameter(desc, paramIntObj, locale);
            }
        }
        for (IParamDescriptionPO desc : paramsToRename.keySet()) {
            paramInterfaceBP.renameParameters(desc, paramsToRename.get(desc), mapper);
        }
        for (IParamDescriptionPO desc : paramsToChangeUsage.keySet()) {
            for (Locale locale : projLangs) {
                paramInterfaceBP.changeUsageParameter(paramIntObj, desc, paramsToChangeUsage.get(desc), locale, mapper);
            }
        }
    }

    private static List<IParamDescriptionPO> findParamsToRemove(List<AbstractEditParametersDialog.Parameter> parameters, Map<String, IParamDescriptionPO> oldParams) {
        ArrayList<String> oldGuids = new ArrayList<String>(oldParams.keySet());
        for (AbstractEditParametersDialog.Parameter parameter : parameters) {
            oldGuids.remove(parameter.getGuid());
        }
        ArrayList<IParamDescriptionPO> paramsToRemove = new ArrayList<IParamDescriptionPO>();
        for (String oldGuid : oldGuids) {
            paramsToRemove.add(oldParams.get(oldGuid));
        }
        return paramsToRemove;
    }

    private static Map<String, IParamDescriptionPO> createOldParamsMap(IModifiableParameterInterfacePO paramIntObj) {
        HashMap<String, IParamDescriptionPO> oldParams = new HashMap<String, IParamDescriptionPO>();
        List paramList = paramIntObj.getParameterList();
        for (IParamDescriptionPO oldDesc : paramList) {
            oldParams.put(oldDesc.getUniqueId(), oldDesc);
        }
        return oldParams;
    }

    private static AbstractEditParametersDialog.Parameter getNotRenamedParamWithSameName(Map<String, IParamDescriptionPO> oldParamsMap, List<AbstractEditParametersDialog.Parameter> params, AbstractEditParametersDialog.Parameter param) {
        for (AbstractEditParametersDialog.Parameter paramSearch : params) {
            IParamDescriptionPO oldParam;
            if (paramSearch == param || !(oldParam = oldParamsMap.get(paramSearch.getGuid())).getName().equals(param.getName())) continue;
            return paramSearch;
        }
        return null;
    }

    private static boolean moveParameters(IModifiableParameterInterfacePO paramIntObj, List<AbstractEditParametersDialog.Parameter> parameters) {
        boolean moved = false;
        LinkedList paramList = new LinkedList(paramIntObj.getParameterList());
        for (IParamDescriptionPO paramDesc : paramList) {
            int newIdx;
            int currIdx = paramList.indexOf(paramDesc);
            if (currIdx == (newIdx = AbstractEditParametersHandler.getNewParamIndex(paramDesc, parameters))) continue;
            paramIntObj.moveParameter(paramDesc.getUniqueId(), newIdx);
            moved = true;
        }
        return moved;
    }

    public static boolean editParameters(ITestDataCubePO paramIntObj, List<AbstractEditParametersDialog.Parameter> parameters, ParamNameBPDecorator mapper, AbstractParamInterfaceBP<ITestDataCubePO> paramInterfaceBP) {
        return AbstractEditParametersHandler.editParameters(paramIntObj, parameters, false, mapper, paramInterfaceBP);
    }
}

