/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.State;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractStartTestHandler
extends AbstractHandler {
    public static boolean prepareTestExecution() {
        IClientTest clientTest = ClientTest.instance();
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("GENERATEREPORT_KEY")) {
            URL xslUrl = TestResultBP.getInstance().getXslFileURL();
            if (xslUrl == null) {
                Plugin.getDefault().handleError(new JBException(Messages.FileNotFoundFormatXsl, MessageIDs.E_FILE_NOT_FOUND));
                return false;
            }
            clientTest.setLogPath(preferenceStore.getString("RESULTPATH_PREF_KEY"));
            clientTest.setLogStyle(preferenceStore.getString("REPORTGENERATORSTYLE_KEY"));
        } else {
            clientTest.setLogPath(null);
            clientTest.setLogStyle(null);
        }
        return true;
    }

    protected boolean initTestExecution(ExecutionEvent event) {
        return this.initPauseTestExecutionState(event);
    }

    private boolean initPauseTestExecutionState(ExecutionEvent event) {
        Command command;
        ICommandService cmdService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
        if (cmdService != null && (command = cmdService.getCommand("org.eclipse.jubula.client.ui.rcp.commands.PauseTestSuiteCommand")) != null) {
            final Display display = Plugin.getDisplay();
            ITestExecutionEventListener l = new ITestExecutionEventListener(){

                public void endTestExecution() {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            State state = command.getState("org.eclipse.ui.commands.toggleState");
                            state.setValue((Object)false);
                        }
                    });
                    ClientTest.instance().removeTestExecutionEventListener((ITestExecutionEventListener)this);
                }

                public void stateChanged(final TestExecutionEvent tee) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            State state = command.getState("org.eclipse.ui.commands.toggleState");
                            boolean newToggleStateValue = tee.getState() == TestExecutionEvent.State.TEST_EXEC_PAUSED;
                            state.setValue((Object)newToggleStateValue);
                        }
                    });
                }
            };
            ClientTest.instance().addTestExecutionEventListener(l);
            return true;
        }
        return false;
    }
}

