/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractStartTestHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.JobUtils;

public class StartTestJobHandler
extends AbstractStartTestHandler {
    public static final String TEST_JOB_TO_START = "org.eclipse.jubula.client.ui.rcp.commands.StartTestJobCommand.parameter.testJobToStart";

    public Object executeImpl(final ExecutionEvent event) throws ExecutionException {
        Object testJobToStartObj = null;
        ITestJobPO testJobToStart = null;
        testJobToStartObj = event.getObjectParameterForExecution(TEST_JOB_TO_START);
        if (testJobToStartObj instanceof ITestJobPO) {
            final ITestJobPO finalTestJob = testJobToStart = (ITestJobPO)testJobToStartObj;
            final boolean autoScreenshots = Plugin.getDefault().getPreferenceStore().getBoolean("AUTO_SCREENSHOT_PREF_KEY");
            final String jobName = Messages.UIJobStartTestJob;
            Job startTestJobJob = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(jobName, -1);
                    final AtomicBoolean prepareOk = new AtomicBoolean(false);
                    Plugin.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (StartTestJobHandler.prepareTestExecution() && StartTestJobHandler.this.initTestExecution(event)) {
                                prepareOk.set(true);
                            }
                        }
                    });
                    if (prepareOk.get()) {
                        ClientTest.instance().startTestJob(finalTestJob, WorkingLanguageBP.getInstance().getWorkingLanguage(), autoScreenshots, null);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            startTestJobJob.setSystem(true);
            JobUtils.executeJob((Job)startTestJobJob, null);
        }
        return null;
    }
}

