/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.alm.mylyn.core.utils.ALMAccess;
import org.eclipse.jubula.client.core.model.IALMReportingRulePO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.utils.ReportRuleType;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.factory.ControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedURLText;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ProjectALMPropertyPage
extends AbstractProjectPropertyPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private DirectCombo<String> m_almRepoCombo;
    private Button m_connectionTest;
    private Button m_reportOnSuccess = null;
    private Group m_onSuccessGroup;
    private Group m_onFailureGroup;
    private Label m_onSuccessRulesLabel;
    private Label m_onFailureRulesLabel;
    private TableViewer m_onSuccessTableViewer;
    private TableViewer m_onFailureTableViewer;
    private Button m_onSuccessAddButton = null;
    private Button m_onSuccessRemoveButton = null;
    private Button m_onFailureAddButton = null;
    private Button m_onFailureRemoveButton = null;
    private List<IALMReportingRulePO> m_reportingRules;
    private ModifyListener m_dataUpdater = new DataUpdateListener();
    private Button m_reportOnFailure = null;
    private CheckedText m_dashboardURL;
    private IProjectPropertiesPO m_origProjectProps;

    public ProjectALMPropertyPage(EditSupport es) {
        super(es);
        this.m_origProjectProps = (IProjectPropertiesPO)es.getOriginal();
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 1, 4, false);
        this.createALMPageDescription(composite);
        Composite main = this.createComposite(composite, 2, 4, false);
        this.noDefaultAndApplyButton();
        this.createEmptyLabel(main);
        this.createEmptyLabel(main);
        this.createALMrepositoryChooser(main);
        this.createDashboardURL(main);
        this.createReportOnSuccess(main);
        this.createReportOnFailure(main);
        Event event = new Event();
        event.type = 13;
        event.widget = this.m_almRepoCombo;
        this.m_almRepoCombo.notifyListeners(13, event);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectAlmSettingsPageContextId");
        return composite;
    }

    private void createDashboardURL(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageDasboardURLLabel);
        this.m_dashboardURL = new CheckedURLText(rightComposite, 2048);
        this.m_dashboardURL.setText(StringUtils.defaultString((String)this.m_origProjectProps.getDashboardURL()));
        this.m_dashboardURL.validate();
        GridData textGridData = new GridData(768);
        textGridData.grabExcessHorizontalSpace = true;
        this.m_dashboardURL.setLayoutData(textGridData);
        LayoutUtil.setMaxChar((Text)this.m_dashboardURL, (int)4000);
        this.m_dashboardURL.addModifyListener(this.m_dataUpdater);
    }

    private void createReportOnFailure(Composite parent) {
        this.m_onFailureAddButton = new Button(parent, 8);
        this.m_onFailureRemoveButton = new Button(parent, 8);
        Composite leftPart = this.createComposite(parent, 1, 4, true);
        this.m_onFailureGroup = new Group(parent, 0);
        this.m_reportOnFailure = new Button(leftPart, 32);
        this.m_reportOnFailure.setSelection(this.m_origProjectProps.getIsReportOnFailure());
        this.m_onFailureRulesLabel = new Label(leftPart, 0);
        this.m_onFailureTableViewer = new TableViewer(leftPart, 68354);
        this.m_onFailureTableViewer.addFilter((ViewerFilter)new RuleTypeFilter(ReportRuleType.ONFAILURE));
        this.createRuleGroup(leftPart, this.m_onFailureGroup, this.m_reportOnFailure, this.m_onFailureRulesLabel, this.m_onFailureTableViewer, Messages.ProjectPropertyPageReportOnFailureLabel, this.m_onFailureAddButton, this.m_onFailureRemoveButton);
    }

    private void createReportOnSuccess(Composite parent) {
        this.m_onSuccessAddButton = new Button(parent, 8);
        this.m_onSuccessRemoveButton = new Button(parent, 8);
        Composite leftPart = this.createComposite(parent, 1, 4, true);
        this.m_onSuccessGroup = new Group(parent, 0);
        this.m_reportOnSuccess = new Button(leftPart, 32);
        this.m_reportOnSuccess.setSelection(this.m_origProjectProps.getIsReportOnSuccess());
        this.m_onSuccessRulesLabel = new Label(leftPart, 0);
        this.m_onSuccessTableViewer = new TableViewer(leftPart, 68354);
        this.m_onSuccessTableViewer.addFilter((ViewerFilter)new RuleTypeFilter(ReportRuleType.ONSUCCESS));
        this.createRuleGroup(leftPart, this.m_onSuccessGroup, this.m_reportOnSuccess, this.m_onSuccessRulesLabel, this.m_onSuccessTableViewer, Messages.ProjectPropertyPageReportOnSuccessLabel, this.m_onSuccessAddButton, this.m_onSuccessRemoveButton);
    }

    private void createRuleGroup(Composite leftPart, Group group, Button report, Label rulesLabel, TableViewer tableViewer, String groupTitle, Button addButton, Button removeButton) {
        GridData groupGridData = new GridData(16384, 128, false, false);
        groupGridData.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)groupGridData);
        group.setText(groupTitle);
        leftPart.setParent((Composite)group);
        report.setText(Messages.ProjectPropertyPageReportWriteCommentLabel);
        GridData labelGridData = new GridData(1040);
        labelGridData.grabExcessHorizontalSpace = false;
        report.setLayoutData((Object)labelGridData);
        report.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectALMPropertyPage.this.updateALMData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        rulesLabel.setText(Messages.ProjectPropertyPageReportRulesLabel);
        ArrayContentProvider provider = new ArrayContentProvider();
        tableViewer.setContentProvider((IContentProvider)provider);
        this.m_reportingRules = this.getProject().getProjectProperties().getALMReportingRules();
        this.createTableContent(tableViewer);
        tableViewer.setInput(this.m_reportingRules);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData layoutData = new GridData(600, 150);
        table.setLayoutData((Object)layoutData);
        Composite rightPart = new Composite((Composite)group, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        rightPart.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(131072, 1024, false, false);
        compositeData.horizontalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        rightPart.setLayoutData((Object)compositeData);
        WidgetSelectionListener selectionListener = new WidgetSelectionListener(tableViewer);
        addButton.setParent(rightPart);
        addButton.setText(Messages.ProjectPropertyPageALMReportRuleAdd);
        addButton.setLayoutData((Object)this.buttonGrid());
        addButton.addSelectionListener((SelectionListener)selectionListener);
        removeButton.setParent(rightPart);
        removeButton.setText(Messages.ProjectPropertyPageALMReportRuleRemove);
        removeButton.setLayoutData((Object)this.buttonGrid());
        removeButton.addSelectionListener((SelectionListener)selectionListener);
    }

    private void createTableContent(TableViewer tableViewer) {
        TableViewerColumn nameColumn = new TableViewerColumn(tableViewer, 16384);
        nameColumn.getColumn().setText(Messages.ALMReportRuleDescription);
        nameColumn.getColumn().setWidth(200);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IALMReportingRulePO) {
                    return ((IALMReportingRulePO)element).getName();
                }
                return null;
            }
        });
        nameColumn.setEditingSupport((EditingSupport)new ReportingRuleNameEditingSupport((ColumnViewer)tableViewer));
        TableViewerColumn fieldColumn = new TableViewerColumn(tableViewer, 16384);
        fieldColumn.getColumn().setText(Messages.ALMReportRuleField);
        fieldColumn.getColumn().setWidth(200);
        fieldColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IALMReportingRulePO) {
                    return ((IALMReportingRulePO)element).getAttributeID();
                }
                return null;
            }
        });
        fieldColumn.setEditingSupport((EditingSupport)new ReportingRuleFieldIDEditingSupport((ColumnViewer)tableViewer));
        TableViewerColumn valueColumn = new TableViewerColumn(tableViewer, 16384);
        valueColumn.getColumn().setText(Messages.ALMReportRuleValue);
        valueColumn.getColumn().setWidth(200);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IALMReportingRulePO) {
                    return ((IALMReportingRulePO)element).getValue();
                }
                return null;
            }
        });
        valueColumn.setEditingSupport((EditingSupport)new ReportingRuleValueEditingSupport((ColumnViewer)tableViewer));
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void createALMPageDescription(Composite parent) {
        this.createEmptyLabel(parent);
        Composite composite = this.createComposite(parent, 1, 4, true);
        this.createLabel(composite, Messages.ProjectPropertyPageALMLabel);
    }

    private void createALMrepositoryChooser(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, false);
        Composite rightComposite = this.createComposite(parent, 3, 4, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageALMRepositoryLabel);
        String configuredRepo = this.m_origProjectProps.getALMRepositoryName();
        this.m_almRepoCombo = ControlFactory.createALMRepositoryCombo(rightComposite, configuredRepo);
        this.m_almRepoCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectALMPropertyPage.this.m_connectionTest.setImage(IconConstants.STEP_TESTING_IMAGE);
                if (ProjectALMPropertyPage.this.m_almRepoCombo.getSelectedObject() == null) {
                    ProjectALMPropertyPage.this.m_dashboardURL.setEnabled(false);
                    ProjectALMPropertyPage.this.setEnabledRecursive((Control)ProjectALMPropertyPage.this.m_onSuccessGroup, false);
                    ProjectALMPropertyPage.this.setEnabledRecursive((Control)ProjectALMPropertyPage.this.m_onFailureGroup, false);
                    ProjectALMPropertyPage.this.m_onSuccessTableViewer.setSelection(null);
                    ProjectALMPropertyPage.this.m_onFailureTableViewer.setSelection(null);
                    ProjectALMPropertyPage.this.m_onSuccessTableViewer.getTable().setEnabled(false);
                    ProjectALMPropertyPage.this.m_onFailureTableViewer.getTable().setEnabled(false);
                } else {
                    ProjectALMPropertyPage.this.m_dashboardURL.setEnabled(true);
                    ProjectALMPropertyPage.this.setEnabledRecursive((Control)ProjectALMPropertyPage.this.m_onSuccessGroup, true);
                    ProjectALMPropertyPage.this.setEnabledRecursive((Control)ProjectALMPropertyPage.this.m_onFailureGroup, true);
                    ProjectALMPropertyPage.this.m_onSuccessTableViewer.getTable().setEnabled(true);
                    ProjectALMPropertyPage.this.m_onFailureTableViewer.getTable().setEnabled(true);
                }
                ProjectALMPropertyPage.this.setErrorMessage(null);
                ProjectALMPropertyPage.this.updateALMData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.m_almRepoCombo.setSelectedObject((Object)configuredRepo);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = true;
        textGridData.horizontalAlignment = 4;
        this.m_almRepoCombo.setLayoutData((Object)textGridData);
        this.m_connectionTest = new Button(rightComposite, 8);
        this.m_connectionTest.setText(Messages.ProjectPropertyPageALMConnectionTest);
        this.m_connectionTest.setImage(IconConstants.STEP_TESTING_IMAGE);
        this.m_connectionTest.addSelectionListener((SelectionListener)new ConnectionTestListener());
    }

    public void setEnabledRecursive(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setEnabledRecursive(c, enabled);
                ++n2;
            }
        } else {
            control.setEnabled(enabled);
        }
    }

    private void updateALMData() {
        IProjectPropertiesPO props = this.getProject().getProjectProperties();
        if (this.m_almRepoCombo != null) {
            props.setALMRepositoryName(this.m_almRepoCombo.getText());
        }
        if (this.m_reportOnFailure != null) {
            props.setIsReportOnFailure(this.m_reportOnFailure.getSelection());
        }
        if (this.m_reportOnSuccess != null) {
            props.setIsReportOnSuccess(this.m_reportOnSuccess.getSelection());
        }
        if (this.m_dashboardURL != null) {
            props.setDashboardURL(this.m_dashboardURL.getText().trim());
        }
        if (this.m_reportingRules != null) {
            props.setALMReportingRules(this.m_reportingRules);
        }
    }

    void handleAddButtonEvent(Button button, TableViewer tableViewer) {
        ReportRuleType type = null;
        if (tableViewer.equals(this.m_onSuccessTableViewer)) {
            type = ReportRuleType.ONSUCCESS;
        } else if (tableViewer.equals(this.m_onFailureTableViewer)) {
            type = ReportRuleType.ONFAILURE;
        }
        IALMReportingRulePO rule = PoMaker.createALMReportingRulePO((String)"", (String)"", (String)"", (ReportRuleType)type);
        this.m_reportingRules.add(rule);
        tableViewer.refresh();
        tableViewer.reveal((Object)rule);
        tableViewer.editElement((Object)rule, 0);
    }

    void handleRemoveButtonEvent(TableViewer tableViewer) {
        StructuredSelection selection = (StructuredSelection)tableViewer.getSelection();
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            this.m_reportingRules.remove(itr.next());
        }
        tableViewer.refresh();
    }

    private GridData buttonGrid() {
        GridData buttonData = new GridData();
        buttonData.horizontalAlignment = 4;
        return buttonData;
    }

    private class ConnectionTestListener
    implements SelectionListener {
        private ConnectionTestListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String selectedObject = (String)ProjectALMPropertyPage.this.m_almRepoCombo.getSelectedObject();
            IStatus connectionStatus = ALMAccess.testConnection((String)selectedObject);
            if (connectionStatus.isOK()) {
                ProjectALMPropertyPage.this.m_connectionTest.setImage(IconConstants.STEP_OK_IMAGE);
                ProjectALMPropertyPage.this.setErrorMessage(null);
            } else {
                ProjectALMPropertyPage.this.m_connectionTest.setImage(IconConstants.ERROR_IMAGE);
                ProjectALMPropertyPage.this.setErrorMessage(connectionStatus.getMessage());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class DataUpdateListener
    implements ModifyListener {
        private DataUpdateListener() {
        }

        public void modifyText(ModifyEvent e) {
            ProjectALMPropertyPage.this.updateALMData();
        }
    }

    private static abstract class ReportingRuleEditingSupport
    extends EditingSupport {
        public ReportingRuleEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }
    }

    private static class ReportingRuleFieldIDEditingSupport
    extends ReportingRuleEditingSupport {
        public ReportingRuleFieldIDEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected Object getValue(Object element) {
            return StringUtils.defaultString((String)((IALMReportingRulePO)element).getAttributeID());
        }

        protected void setValue(Object element, Object value) {
            String hostNameValue = String.valueOf(value);
            ((IALMReportingRulePO)element).setAttributeID(hostNameValue);
            this.getViewer().update(element, null);
        }
    }

    private static class ReportingRuleNameEditingSupport
    extends ReportingRuleEditingSupport {
        public ReportingRuleNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected Object getValue(Object element) {
            return StringUtils.defaultString((String)((IALMReportingRulePO)element).getName());
        }

        protected void setValue(Object element, Object value) {
            String hostNameValue = String.valueOf(value);
            ((IALMReportingRulePO)element).setName(hostNameValue);
            this.getViewer().update(element, null);
        }
    }

    private static class ReportingRuleValueEditingSupport
    extends ReportingRuleEditingSupport {
        public ReportingRuleValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected Object getValue(Object element) {
            return StringUtils.defaultString((String)((IALMReportingRulePO)element).getValue());
        }

        protected void setValue(Object element, Object value) {
            String hostNameValue = String.valueOf(value);
            ((IALMReportingRulePO)element).setValue(hostNameValue);
            this.getViewer().update(element, null);
        }
    }

    private class RuleTypeFilter
    extends ViewerFilter {
        private ReportRuleType m_type = null;

        public RuleTypeFilter(ReportRuleType type) {
            this.m_type = type;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IALMReportingRulePO rule;
            return element instanceof IALMReportingRulePO && (rule = (IALMReportingRulePO)element).getType() == this.m_type;
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private TableViewer m_tableViewer;

        WidgetSelectionListener(TableViewer tableViewer) {
            this.m_tableViewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleSelectionEvent(e);
        }

        private void handleSelectionEvent(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectALMPropertyPage.this.m_onSuccessAddButton) || o.equals(ProjectALMPropertyPage.this.m_onFailureAddButton)) {
                ProjectALMPropertyPage.this.handleAddButtonEvent((Button)o, this.m_tableViewer);
                return;
            }
            if (o.equals(ProjectALMPropertyPage.this.m_onSuccessRemoveButton) || o.equals(ProjectALMPropertyPage.this.m_onFailureRemoveButton)) {
                ProjectALMPropertyPage.this.handleRemoveButtonEvent(this.m_tableViewer);
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + ":" + " " + "'" + String.valueOf(e.getSource()) + "'"));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleSelectionEvent(e);
        }
    }
}

