/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.IModifiableListObservable;
import org.eclipse.jubula.client.ui.rcp.widgets.ModifiableListObservable;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiableTriggerList
extends Composite
implements IModifiableListObservable {
    private static Logger log = LoggerFactory.getLogger(ModifiableTriggerList.class);
    private Text m_editor;
    private Button m_addButton;
    private org.eclipse.swt.widgets.List m_list;
    private Button m_changeButton;
    private Button m_removeButton;
    private Button m_optionalButton;
    private IModifiableListObservable m_observable;
    private boolean m_isEmptyListAllowed;
    private KeySequenceText m_textTriggerSequenceManager;

    public ModifiableTriggerList(Composite parent, int style, String headerKey, Set<String> values, boolean emptyListAllowed) {
        super(parent, style);
        if (!emptyListAllowed && values != null && values.isEmpty()) {
            String msg = String.valueOf(Messages.ValuesForListMustNotBeEmpty) + ".";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.m_observable = new ModifiableListObservable();
        this.m_isEmptyListAllowed = emptyListAllowed;
        this.initControls(headerKey, values);
        this.enableButtons();
        this.addListeners();
    }

    @Override
    public void addContentAddedListener(ModifiableListObservable.IContentAddedListener listener) {
        this.m_observable.addContentAddedListener(listener);
    }

    @Override
    public void addContentChangedListener(ModifiableListObservable.IContentChangedListener listener) {
        this.m_observable.addContentChangedListener(listener);
    }

    @Override
    public void addContentRemovedListener(ModifiableListObservable.IContentRemovedListener listener) {
        this.m_observable.addContentRemovedListener(listener);
    }

    @Override
    public void addSelectionChangedListener(ModifiableListObservable.ISelectionChangedListener listener) {
        this.m_observable.addSelectionChangedListener(listener);
    }

    @Override
    public void addOptionalButtonSelectedListener(ModifiableListObservable.IOptionalButtonSelectedListener listener) {
        this.m_observable.addOptionalButtonSelectedListener(listener);
    }

    @Override
    public void removeContentAddedListener(ModifiableListObservable.IContentAddedListener listener) {
        this.m_observable.removeContentAddedListener(listener);
    }

    @Override
    public void removeContentChangedListener(ModifiableListObservable.IContentChangedListener listener) {
        this.m_observable.removeContentChangedListener(listener);
    }

    @Override
    public void removeContentRemovedListener(ModifiableListObservable.IContentRemovedListener listener) {
        this.m_observable.removeContentRemovedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(ModifiableListObservable.ISelectionChangedListener listener) {
        this.m_observable.removeSelectionChangedListener(listener);
    }

    @Override
    public void removeOptionalButtonSelectedListener(ModifiableListObservable.IOptionalButtonSelectedListener listener) {
        this.m_observable.removeOptionalButtonSelectedListener(listener);
    }

    @Override
    public void fireContentAdded(String newValue) {
        this.m_observable.fireContentAdded(newValue);
    }

    @Override
    public void fireContentChanged(String oldValue, String newValue) {
        this.m_observable.fireContentChanged(oldValue, newValue);
    }

    @Override
    public void fireContentRemoved(String oldValue) {
        this.m_observable.fireContentRemoved(oldValue);
    }

    @Override
    public void fireSelectionChanged(String value) {
        this.m_observable.fireSelectionChanged(value);
    }

    @Override
    public void fireOptionalButtonSelected() {
        this.m_observable.fireOptionalButtonSelected();
    }

    private void enableButtons() {
        boolean validSelection = this.m_list.getSelectionIndex() != -1;
        boolean emptyEditor = "".equals(this.m_editor.getText());
        if (!this.m_isEmptyListAllowed && this.m_list.getItemCount() <= 1) {
            this.m_removeButton.setEnabled(false);
        } else {
            this.m_removeButton.setEnabled(validSelection);
        }
        this.m_changeButton.setEnabled(validSelection && !emptyEditor);
        this.m_addButton.setEnabled(!emptyEditor);
    }

    private void addListeners() {
        this.m_addButton.addSelectionListener((SelectionListener)new AddSelected());
        this.m_removeButton.addSelectionListener((SelectionListener)new RemoveSelected());
        this.m_changeButton.addSelectionListener((SelectionListener)new ChangeSelected());
        this.m_list.addSelectionListener((SelectionListener)new ItemSelected());
        this.m_editor.addModifyListener((ModifyListener)new EditorModified());
        if (this.m_optionalButton != null) {
            this.m_optionalButton.addSelectionListener((SelectionListener)new OptionalButtonSelected());
        }
    }

    private void initControls(String headerKey, Set<String> values) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Label header = new Label((Composite)this, 0);
        header.setText(I18n.getString((String)headerKey));
        FormData headerData = new FormData();
        headerData.left = new FormAttachment(0, 0);
        headerData.top = new FormAttachment(0, 0);
        headerData.right = new FormAttachment(100, 0);
        header.setLayoutData((Object)headerData);
        this.m_editor = new Text((Composite)this, 2048);
        FormData editorData = new FormData();
        editorData.left = new FormAttachment(0, 0);
        editorData.top = new FormAttachment((Control)header, 5, 1024);
        this.m_editor.setLayoutData((Object)editorData);
        this.m_textTriggerSequenceManager = new KeySequenceText(this.m_editor);
        this.m_textTriggerSequenceManager.setKeyStrokeLimit(1);
        this.m_addButton = new Button((Composite)this, 8);
        this.m_addButton.setText(Messages.ModifiableListAdd);
        FormData addButtonData = new FormData();
        this.m_addButton.setLayoutData((Object)addButtonData);
        editorData.right = new FormAttachment(74, 0);
        addButtonData.top = new FormAttachment((Control)this.m_editor, -2, 128);
        addButtonData.left = new FormAttachment(76, 0);
        addButtonData.right = new FormAttachment(100, 0);
        this.createButtonGroup();
        this.m_list = new org.eclipse.swt.widgets.List((Composite)this, 2564);
        this.addToolTipListener();
        FormData listData = new FormData();
        listData.left = new FormAttachment(0, 0);
        listData.top = new FormAttachment((Control)this.m_addButton, 10, 1024);
        listData.right = new FormAttachment((Control)this.m_addButton, 0, 131072);
        listData.bottom = new FormAttachment((Control)this.m_changeButton, -10, 128);
        this.m_list.setLayoutData((Object)listData);
        this.setValues(values);
    }

    private void createButtonGroup() {
        this.m_changeButton = new Button((Composite)this, 0);
        this.m_changeButton.setText(Messages.ModifiableListEdit);
        FormData changeBtData = new FormData();
        changeBtData.left = new FormAttachment(0, 0);
        changeBtData.top = new FormAttachment(100, -30);
        changeBtData.right = new FormAttachment(49, 0);
        this.m_changeButton.setLayoutData((Object)changeBtData);
        this.m_removeButton = new Button((Composite)this, 0);
        this.m_removeButton.setText(Messages.ModifiableListRemove);
        FormData removeBtData = new FormData();
        removeBtData.left = new FormAttachment(51, 0);
        removeBtData.top = new FormAttachment((Control)this.m_changeButton, 0, 128);
        removeBtData.right = new FormAttachment(100, 0);
        this.m_removeButton.setLayoutData((Object)removeBtData);
    }

    private void addToolTipListener() {
        new ToolTipListener(this, (Control)this.m_list){

            @Override
            public String getText(Event event) {
                int heightPerItem;
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)this.getToolTipOwner();
                int start = list.getTopIndex();
                int itemIndex = start + event.getBounds().y / (heightPerItem = list.getItemHeight());
                if (itemIndex >= list.getItemCount()) {
                    return "";
                }
                String item = list.getItem(itemIndex);
                return item;
            }
        };
    }

    public void setValues(Set<String> values) {
        this.m_list.removeAll();
        this.m_editor.setText("");
        if (values != null) {
            for (String value : values) {
                this.m_list.add(value);
            }
        }
        this.enableButtons();
    }

    public String[] getValues() {
        return this.m_list.getItems();
    }

    public void setSelection(int pos) {
        Validate.isTrue((pos >= 0 ? 1 : 0) != 0, (String)"Invalid index for selection.");
        if (this.m_list.getItemCount() > pos) {
            this.m_list.setSelection(pos);
            this.fireSelectionChanged(this.m_list.getSelection()[0]);
            this.enableButtons();
        }
    }

    public void setOptionalButtonEnabled(boolean isEnabled) {
        if (this.m_optionalButton != null) {
            this.m_optionalButton.setEnabled(isEnabled);
        }
    }

    public void setEditorText(String value) {
        this.m_editor.setText(value);
    }

    public int getItemCount() {
        return this.m_list.getItemCount();
    }

    public class AddSelected
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            this.handleAdd();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void handleAdd() {
            List<String> listContent;
            String newValue = ModifiableTriggerList.this.m_editor.getText();
            if (!StringUtils.isEmpty((String)newValue) && !(listContent = Arrays.asList(ModifiableTriggerList.this.m_list.getItems())).contains(newValue)) {
                TreeSet<String> content = new TreeSet<String>(listContent);
                content.add(newValue);
                ModifiableTriggerList.this.setValues(content);
                ModifiableTriggerList.this.setSelection(ModifiableTriggerList.this.m_list.indexOf(newValue));
                ModifiableTriggerList.this.m_list.showSelection();
                ModifiableTriggerList.this.fireContentAdded(newValue);
            }
        }
    }

    public class ChangeSelected
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            this.handleChange();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void handleChange() {
            int selectionIndex = ModifiableTriggerList.this.m_list.getSelectionIndex();
            String oldValue = ModifiableTriggerList.this.m_list.getItem(selectionIndex);
            if (selectionIndex != -1) {
                String newValue = ModifiableTriggerList.this.m_editor.getText();
                List<String> listContent = Arrays.asList(ModifiableTriggerList.this.m_list.getItems());
                if (!listContent.contains(newValue)) {
                    TreeSet<String> content = new TreeSet<String>(listContent);
                    content.remove(oldValue);
                    content.add(newValue);
                    ModifiableTriggerList.this.setValues(content);
                    ModifiableTriggerList.this.m_list.select(ModifiableTriggerList.this.m_list.indexOf(newValue));
                    ModifiableTriggerList.this.m_list.showSelection();
                    ModifiableTriggerList.this.m_editor.setText(newValue);
                    ModifiableTriggerList.this.fireContentChanged(oldValue, newValue);
                }
            }
        }
    }

    public class EditorModified
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            this.handleEditorChanged();
        }

        private void handleEditorChanged() {
            ModifiableTriggerList.this.enableButtons();
        }
    }

    public class ItemSelected
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            this.handleListSelection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleListSelection() {
            if (ModifiableTriggerList.this.m_list.getSelectionCount() > 0) {
                String selection = ModifiableTriggerList.this.m_list.getSelection()[0];
                ModifiableTriggerList.this.m_editor.setText(selection);
                ModifiableTriggerList.this.fireSelectionChanged(selection);
            }
            ModifiableTriggerList.this.enableButtons();
        }
    }

    public class OptionalButtonSelected
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            this.handleOptionalButtonSelected();
        }

        private void handleOptionalButtonSelected() {
            ModifiableTriggerList.this.fireOptionalButtonSelected();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class RemoveSelected
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            this.handleRemove();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void handleRemove() {
            int selectionIndex = ModifiableTriggerList.this.m_list.getSelectionIndex();
            if (selectionIndex != -1) {
                String oldValue = ModifiableTriggerList.this.m_list.getItem(selectionIndex);
                ModifiableTriggerList.this.m_list.remove(selectionIndex);
                ModifiableTriggerList.this.enableButtons();
                ModifiableTriggerList.this.fireContentRemoved(oldValue);
            }
        }
    }

    private abstract class ToolTipListener
    implements Listener {
        private Control m_toolTipOwner;
        private Text m_toolTipContent;
        private Shell m_tip;
        private Listener m_labelListener = new LabelListener();

        public ToolTipListener(Control c) {
            this.m_toolTipOwner = c;
            c.addListener(32, (Listener)this);
            c.addListener(12, (Listener)this);
            c.addListener(1, (Listener)this);
            c.addListener(5, (Listener)this);
            c.addListener(13, (Listener)this);
            c.addListener(16, (Listener)this);
        }

        public abstract String getText(Event var1);

        public Control getToolTipOwner() {
            return this.m_toolTipOwner;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 5: 
                case 12: 
                case 13: 
                case 16: {
                    if (this.m_tip == null) break;
                    this.m_tip.dispose();
                    this.m_tip = null;
                    this.m_toolTipContent = null;
                    break;
                }
                case 32: {
                    if (this.m_tip != null) {
                        this.m_tip.dispose();
                    }
                    Point point = ModifiableTriggerList.this.toDisplay(this.m_toolTipOwner.getLocation());
                    this.m_tip = new Shell(this.m_toolTipOwner.getShell(), 16388);
                    FillLayout layout = new FillLayout();
                    layout.marginHeight = 2;
                    layout.marginWidth = 2;
                    this.m_tip.setLayout((Layout)layout);
                    this.m_toolTipContent = new Text((Composite)this.m_tip, 74);
                    this.m_tip.setForeground(this.m_toolTipOwner.getDisplay().getSystemColor(28));
                    this.m_tip.setBackground(this.m_toolTipOwner.getDisplay().getSystemColor(29));
                    this.m_toolTipContent.setForeground(this.m_toolTipOwner.getDisplay().getSystemColor(28));
                    this.m_toolTipContent.setBackground(this.m_toolTipOwner.getDisplay().getSystemColor(29));
                    String text = this.getText(event);
                    if (text.length() == 0) {
                        return;
                    }
                    this.m_toolTipContent.setText(text);
                    this.m_toolTipContent.addListener(7, this.m_labelListener);
                    this.m_toolTipContent.addListener(3, this.m_labelListener);
                    this.m_toolTipContent.addListener(16, this.m_labelListener);
                    this.m_tip.setBounds(this.m_toolTipOwner.getBounds());
                    int height = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_toolTipContent), (int)(this.m_toolTipContent.getLineCount() + 1));
                    Rectangle itemBounds = this.m_toolTipOwner.getBounds();
                    this.m_tip.setBounds(point.x + event.x, point.y + event.y + 20, itemBounds.width, height);
                    this.m_tip.setVisible(true);
                }
            }
        }

        private class LabelListener
        implements Listener {
            private LabelListener() {
            }

            public void handleEvent(Event event) {
                Text label = (Text)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 7: 
                    case 16: {
                        shell.dispose();
                        break;
                    }
                }
            }
        }
    }
}

