/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.core.utils.DatabaseStateDispatcher;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.client.core.utils.IDatabaseStateListener;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.filter.JBPatternFilter;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.labelprovider.TestresultSummaryViewColumnLabelProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.client.ui.views.ColumnViewerSorter;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestresultSummaryView
extends ViewPart
implements DataEventDispatcher.ITestresultSummaryEventListener,
DataEventDispatcher.ITestresultChangedListener,
IDatabaseStateListener {
    public static final DateFormat DTF_DEFAULT = DateFormat.getDateTimeInstance(2, 2);
    public static final DateFormat DTF_LONG = DateFormat.getDateTimeInstance(2, 1);
    private static final int FILTER_CONTROL_INPUT_DELAY = 300;
    private static final String NO_DATA_AVAILABLE = Messages.TestresultSummaryNoData;
    private static final String TESTRESULT_SUMMARY_NUMBER_OF_FAILED_CAPS = Messages.TestresultSummaryNumberOfFailedCaps;
    private static final String TESTRESULT_SUMMARY_DETAILS_AVAILABLE = Messages.TestresultSummaryDetailsAvailable;
    private static final String TESTRESULT_SUMMARY_TESTRUN_RELEVANT = Messages.TestresultSummaryTestrunRelevant;
    private static final String TESTRESULT_SUMMARY_CMD_PARAM = Messages.TestresultSummaryCmdParam;
    private static final String TESTRESULT_SUMMARY_HANDLER_CAPS = Messages.TestresultSummaryHandlerCaps;
    private static final String TESTRESULT_SUMMARY_EXECUTED_CAPS = Messages.TestresultSummaryExecCaps;
    private static final String TESTRESULT_SUMMARY_EXPECTED_CAPS = Messages.TestresultSummaryExpecCaps;
    private static final String TESTRESULT_SUMMARY_DURATION = Messages.TestresultSummaryDuration;
    private static final String TESTRESULT_SUMMARY_END_TIME = Messages.TestresultSummaryEndTime;
    private static final String TESTRESULT_SUMMARY_START_TIME = Messages.TestresultSummaryStartTime;
    private static final String TESTRESULT_SUMMARY_LANGUAGE = Messages.TestresultSummaryLanguage;
    private static final String TESTRESULT_SUMMARY_TOOLKIT = Messages.TestresultSummaryToolkit;
    private static final String TESTRESULT_SUMMARY_AUT_OS = Messages.TestresultSummaryAutOS;
    private static final String TESTRESULT_SUMMARY_AUT_AGENT_HOSTNAME = Messages.TestresultSummaryAutAgentHostname;
    private static final String TESTRESULT_SUMMARY_AUT_HOSTNAME = Messages.TestresultSummaryAutHostname;
    private static final String TESTRESULT_SUMMARY_AUT_CONFIG = Messages.TestresultSummaryAutConf;
    private static final String TESTRESULT_SUMMARY_AUT_ID = Messages.TestresultSummaryAutId;
    private static final String TESTRESULT_SUMMARY_AUT_NAME = Messages.TestresultSummaryAutName;
    private static final String TESTRESULT_SUMMARY_TESTSUITE_STATUS = Messages.TestresultSummaryTestsuiteStatus;
    private static final String TESTRESULT_SUMMARY_TESTSUITE = Messages.TestresultSummaryTestsuite;
    private static final String TESTRESULT_SUMMARY_PROJECT_NAME = Messages.TestresultSummaryProjectName;
    private static final String TESTRESULT_PROJECT_VERSION = Messages.TestresultSummaryProjectVersion;
    private static final String TESTRESULT_SUMMARY_TESTRUN_STATE = Messages.TestresultSummaryTestrunState;
    private static final String TESTRESULT_ALM_REPORT_STATE = Messages.TestresultSummaryAlmReportState;
    private static final String TESTRESULT_SUMMARY_DATE = Messages.TestresultSummaryDate;
    private static final String TESTRESULT_SUMMARY_COMMENT_TITLE = Messages.TestresultSummaryCommentTitle;
    private static final String TESTRESULT_SUMMARY_TEST_JOB_START_TIME = Messages.TestresultSummaryTestJobStartTime;
    private static final String TESTRESULT_SUMMARY_TEST_JOB = Messages.TestresultSummaryTestJob;
    private static final String TESTRESULT_SUMMARY_TESTRUN_ID = Messages.TestresultSummaryTestrunID;
    private static final String MONITORING_ID = Messages.TestresultSummaryMonitoringId;
    private static final String MONITORING_VALUE = Messages.TestresultSummaryMonitoringValue;
    private static final String MONITORING_DETAILS = Messages.TestresultSummaryMonitoringDetails;
    private static Logger log = LoggerFactory.getLogger(TestresultSummaryView.class);
    private static final String TAG_COLUMN = "column";
    private static final String TAG_NUMBER = "number";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_COL_IDX = "columnIndex";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final String TAG_SEARCH_TYPE = "searchType";
    private static final String TAG_SORT = "sort";
    private static final String TAG_SORT_COL = "sortColumn";
    private static final String TAG_SORT_DIRECTION = "sortDirection";
    private TableViewer m_tableViewer;
    private TestresultSummaryFilter m_filter;
    private Menu m_headerMenu;
    private IMemento m_memento;
    private Combo m_filterCombo;
    private Text m_searchText;
    private List<Number> m_detailedSummaryIds = new ArrayList<Number>();
    private TestresultFilterJob m_filterJob = new TestresultFilterJob(Messages.JobFilterSummaryView, "");

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.m_memento = memento;
    }

    public void createPartControl(Composite parent) {
        this.m_headerMenu = new Menu((Control)parent);
        GridLayout layout = new GridLayout(4, false);
        parent.setLayout((Layout)layout);
        this.m_filter = new TestresultSummaryFilter();
        this.createSearchFilter(parent);
        this.m_tableViewer = new TableViewer(parent, 268503810);
        this.addDateColumn(this.m_tableViewer);
        this.addDetailsColumn(this.m_tableViewer);
        this.addStatusDecoratorColumn(this.m_tableViewer);
        this.addTestsuiteColumn(this.m_tableViewer);
        this.addCommentTitleColumn(this.m_tableViewer);
        this.addTestrunIdColumn(this.m_tableViewer);
        this.addTestRelevantColumn(this.m_tableViewer);
        this.addTestJobStartTimeColumn(this.m_tableViewer);
        this.addTestJobColumn(this.m_tableViewer);
        this.addAlmStatusDecoratorColumn(this.m_tableViewer);
        this.addTsStatusColumn(this.m_tableViewer);
        this.addProjectNameColumn(this.m_tableViewer);
        this.addProjectVersionColumn(this.m_tableViewer);
        this.addAutIdColumn(this.m_tableViewer);
        this.addAutNameColumn(this.m_tableViewer);
        this.addAutConfColumn(this.m_tableViewer);
        this.addLanguageColumn(this.m_tableViewer);
        this.addCmdParamColumn(this.m_tableViewer);
        this.addAutOSColumn(this.m_tableViewer);
        this.addAutHostnameColumn(this.m_tableViewer);
        this.addAutAgentHostnameColumn(this.m_tableViewer);
        this.addToolkitColumn(this.m_tableViewer);
        this.addStartTimeColumn(this.m_tableViewer);
        this.addEndTimeColumn(this.m_tableViewer);
        this.addDurationColumn(this.m_tableViewer);
        this.addExpecCapsColumn(this.m_tableViewer);
        this.addExecCapsColumn(this.m_tableViewer);
        this.addEventhandlerCapsColumn(this.m_tableViewer);
        this.addFailedCapsColumn(this.m_tableViewer);
        this.addMonitoringIdColumn(this.m_tableViewer);
        this.addMonitoringValueColumn(this.m_tableViewer);
        this.addMonitoringReportColumn(this.m_tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_tableViewer);
        this.m_tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_tableViewer.getTable().setLinesVisible(true);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        this.m_tableViewer.setUseHashlookup(true);
        this.addContextMenu(this.m_tableViewer, this.m_headerMenu);
        this.setTableViewerLayout();
        this.m_tableViewer.addFilter((ViewerFilter)this.m_filter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.m_tableViewer.getControl(), "org.eclipse.jubula.client.ua.help.testResultSummaryViewContextId");
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addTestresultListener((DataEventDispatcher.ITestresultChangedListener)this, true);
        ded.addTestresultSummaryEventListener((DataEventDispatcher.ITestresultSummaryEventListener)this);
        DatabaseStateDispatcher.addDatabaseStateListener((IDatabaseStateListener)this);
        this.addDoubleClickListener((StructuredViewer)this.m_tableViewer);
        this.loadViewInput();
        this.restoreViewStatus();
    }

    private void addContextMenu(final TableViewer tableViewer, final Menu headerMenu) {
        final Table table = tableViewer.getTable();
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                boolean isHeaderEvent;
                Point pt = event.display.map(null, (Control)table, new Point(event.x, event.y));
                Rectangle clientArea = table.getClientArea();
                boolean bl = isHeaderEvent = clientArea.y <= pt.y && pt.y < clientArea.y + table.getHeaderHeight();
                if (isHeaderEvent) {
                    table.setMenu(headerMenu);
                } else {
                    MenuManager menuMgr = new MenuManager();
                    menuMgr.setRemoveAllWhenShown(true);
                    menuMgr.addMenuListener(new IMenuListener(){

                        public void menuAboutToShow(IMenuManager mgr) {
                            TestresultSummaryView.this.fillContextMenu(mgr);
                        }
                    });
                    Menu menu = menuMgr.createContextMenu((Control)table);
                    TestresultSummaryView.this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)tableViewer);
                    table.setMenu(menu);
                }
            }
        });
        table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                headerMenu.dispose();
            }
        });
    }

    private void fillContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.jubula.client.ui.commands.OpenTestResultViewer");
        CommandHelper.createContributionPushItem(mgr, "org.eclipse.ui.file.refresh");
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void addFailedCapsColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.EH_CAP_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_NUMBER_OF_FAILED_CAPS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                int noFailed = ((ITestResultSummaryPO)element).getTestsuiteFailedTeststeps();
                if (noFailed == -1) {
                    return NO_DATA_AVAILABLE;
                }
                return String.valueOf(noFailed);
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteFailedTeststeps(), ((ITestResultSummaryPO)e2).getTestsuiteFailedTeststeps());
            }
        };
    }

    private void addDetailsColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(70);
        column.getColumn().setToolTipText(Messages.TestresultSummaryColumnDescriptionDetails);
        column.getColumn().setText(TESTRESULT_SUMMARY_DETAILS_AVAILABLE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public Image getImage(Object element) {
                String text = String.valueOf(TestresultSummaryView.this.m_detailedSummaryIds.contains(((ITestResultSummaryPO)element).getId()));
                if (text.equals(Boolean.TRUE.toString())) {
                    return IconConstants.TRSV_DETAILS;
                }
                return IconConstants.TRSV_NODETAILS;
            }

            public String getText(Object element) {
                return null;
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(TestresultSummaryView.this.m_detailedSummaryIds.contains(((ITestResultSummaryPO)e1).getId()), TestresultSummaryView.this.m_detailedSummaryIds.contains(((ITestResultSummaryPO)e2).getId()));
            }
        };
    }

    private void addDoubleClickListener(StructuredViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommandHelper.executeCommand("org.eclipse.jubula.client.ui.commands.OpenTestResultViewer", TestresultSummaryView.this.getSite());
            }
        });
    }

    public void saveState(IMemento memento) {
        Table table = this.m_tableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        int[] colOrder = table.getColumnOrder();
        int i = 0;
        while (i < columns.length) {
            IMemento colWidthChild = memento.createChild(TAG_COLUMN);
            colWidthChild.putInteger(TAG_NUMBER, i);
            colWidthChild.putInteger(TAG_WIDTH, columns[i].getWidth());
            colWidthChild.putInteger(TAG_COL_IDX, colOrder[i]);
            ++i;
        }
        IMemento filterChild = memento.createChild(TAG_FILTER);
        filterChild.putString(TAG_FILTER_TYPE, this.m_filterCombo.getItem(this.m_filterCombo.getSelectionIndex()));
        filterChild.putString(TAG_SEARCH_TYPE, this.m_searchText.getText());
        IMemento sortChild = memento.createChild(TAG_SORT);
        TableColumn sortCol = table.getSortColumn();
        if (sortCol != null) {
            sortChild.putString(TAG_SORT_COL, sortCol.getText());
            sortChild.putInteger(TAG_SORT_DIRECTION, table.getSortDirection());
        }
    }

    private void restoreViewStatus() {
        Table table = this.m_tableViewer.getTable();
        if (this.m_memento != null) {
            IMemento[] children = this.m_memento.getChildren(TAG_COLUMN);
            if (children.length == table.getColumnCount()) {
                IMemento sortChild;
                IMemento filterChild;
                if (children != null) {
                    int[] colOrder = new int[table.getColumnOrder().length];
                    int i = 0;
                    while (i < children.length) {
                        Integer val = children[i].getInteger(TAG_NUMBER);
                        if (val != null) {
                            Integer colIdx;
                            int index = val;
                            Integer width = children[i].getInteger(TAG_WIDTH);
                            if (width != null) {
                                table.getColumn(index).setWidth(width.intValue());
                            }
                            if ((colIdx = children[i].getInteger(TAG_COL_IDX)) != null) {
                                colOrder[i] = colIdx;
                            }
                        }
                        ++i;
                    }
                    if (children.length == colOrder.length) {
                        table.setColumnOrder(colOrder);
                    }
                }
                if ((filterChild = this.m_memento.getChild(TAG_FILTER)) != null) {
                    String filterTypeString = filterChild.getString(TAG_FILTER_TYPE);
                    String searchString = filterChild.getString(TAG_SEARCH_TYPE);
                    this.m_filterCombo.select(this.m_filterCombo.indexOf(filterTypeString));
                    this.m_filter.setFilterType(filterTypeString);
                    this.m_searchText.setText(searchString);
                    this.m_filter.setPattern(searchString);
                }
                if ((sortChild = this.m_memento.getChild(TAG_SORT)) != null) {
                    String sortHeader = sortChild.getString(TAG_SORT_COL);
                    Integer direction = sortChild.getInteger(TAG_SORT_DIRECTION);
                    this.sortTable(table, sortHeader, direction);
                }
            }
        } else {
            this.sortTable(table, TESTRESULT_SUMMARY_DATE, 1024);
        }
    }

    public void sortTable(Table table, String sortHeader, Integer direction) {
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn tblCol = table.getColumn(i);
            if (tblCol.getText().equals(sortHeader)) {
                table.setSortColumn(tblCol);
                table.setSortDirection(direction.intValue());
                tblCol.notifyListeners(13, new Event());
                if (direction != 1024) break;
                tblCol.notifyListeners(13, new Event());
                break;
            }
            ++i;
        }
    }

    private void createSearchFilter(Composite parent) {
        Label searchLabel = new Label(parent, 0);
        searchLabel.setText(Messages.TestresultSummaryFilterLabel);
        this.m_filterCombo = new Combo(parent, 12);
        Object[] items = new String[]{TESTRESULT_SUMMARY_TESTRUN_ID, TESTRESULT_SUMMARY_TEST_JOB, TESTRESULT_SUMMARY_TEST_JOB_START_TIME, TESTRESULT_SUMMARY_DATE, TESTRESULT_SUMMARY_COMMENT_TITLE, TESTRESULT_SUMMARY_TESTRUN_STATE, TESTRESULT_ALM_REPORT_STATE, TESTRESULT_SUMMARY_PROJECT_NAME, TESTRESULT_PROJECT_VERSION, TESTRESULT_SUMMARY_TESTSUITE, TESTRESULT_SUMMARY_TESTSUITE_STATUS, TESTRESULT_SUMMARY_AUT_NAME, TESTRESULT_SUMMARY_AUT_ID, TESTRESULT_SUMMARY_AUT_CONFIG, TESTRESULT_SUMMARY_AUT_HOSTNAME, TESTRESULT_SUMMARY_AUT_AGENT_HOSTNAME, TESTRESULT_SUMMARY_AUT_OS, TESTRESULT_SUMMARY_TOOLKIT, TESTRESULT_SUMMARY_LANGUAGE, TESTRESULT_SUMMARY_START_TIME, TESTRESULT_SUMMARY_END_TIME, TESTRESULT_SUMMARY_DURATION, TESTRESULT_SUMMARY_EXPECTED_CAPS, TESTRESULT_SUMMARY_EXECUTED_CAPS, TESTRESULT_SUMMARY_HANDLER_CAPS, TESTRESULT_SUMMARY_CMD_PARAM, TESTRESULT_SUMMARY_TESTRUN_RELEVANT, TESTRESULT_SUMMARY_DETAILS_AVAILABLE, TESTRESULT_SUMMARY_NUMBER_OF_FAILED_CAPS};
        Arrays.sort(items);
        this.m_filterCombo.setItems((String[])items);
        this.m_filterCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.widget instanceof Combo) {
                    Combo cbx = (Combo)e.widget;
                    TestresultSummaryView.this.m_filter.setFilterType(cbx.getItem(cbx.getSelectionIndex()));
                    TestresultSummaryView.this.m_tableViewer.refresh();
                }
            }
        });
        int index = this.m_filterCombo.indexOf(TESTRESULT_SUMMARY_TESTRUN_STATE);
        if (index != -1) {
            this.m_filterCombo.select(index);
            this.m_filter.setFilterType(TESTRESULT_SUMMARY_TESTRUN_STATE);
        } else {
            this.m_filterCombo.select(0);
        }
        this.createLabel(parent);
        this.m_searchText = new Text(parent, 2176);
        this.m_searchText.setLayoutData((Object)new GridData(768));
        this.m_searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (TestresultSummaryView.this.m_filterJob.cancel()) {
                    TestresultSummaryView.this.m_filterJob = new TestresultFilterJob(Messages.JobFilterSummaryView, TestresultSummaryView.this.m_searchText.getText());
                    JobUtils.executeJob(TestresultSummaryView.this.m_filterJob, null, 300L);
                }
            }
        });
    }

    private void createLabel(Composite parent) {
        IPreferenceStore ps = Plugin.getDefault().getPreferenceStore();
        final Label forLabel = new Label(parent, 0);
        forLabel.setText(NLS.bind((String)Messages.TestresultSummaryForLabel, (Object)ps.getInt("MAX_NUMBER_OF_DAYS_KEY")));
        ps.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("MAX_NUMBER_OF_DAYS_KEY")) {
                    forLabel.setText(NLS.bind((String)Messages.TestresultSummaryForLabel, (Object)event.getNewValue()));
                }
            }
        });
    }

    public Long[] getSelectedTestrunIds() {
        ISelection selection = this.m_tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<Long> selectedIds = new ArrayList<Long>();
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedItem = objectArray[n2];
                ITestResultSummaryPO summary = (ITestResultSummaryPO)selectedItem;
                selectedIds.add(summary.getId());
                ++n2;
            }
            return selectedIds.toArray(new Long[selectedIds.size()]);
        }
        return new Long[0];
    }

    public void deleteTestresults(final Long[] testrunIds) {
        final String jobName = Messages.UIJobDeletingTestResultFromDB;
        Job job = new Job(jobName){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                TestResultSummaryPM.deleteTestruns((Long[])testrunIds);
                TestresultSummaryView.this.loadViewInput();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void loadViewInput() {
        this.m_tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    int maxNoOfDays = Plugin.getDefault().getPreferenceStore().getInt("MAX_NUMBER_OF_DAYS_KEY");
                    Date startTime = DateUtils.addDays((Date)new Date(), (int)(maxNoOfDays * -1));
                    List metaList = TestResultSummaryPM.findAllTestResultSummaries((Date)startTime);
                    if (Persistor.instance() != null) {
                        TestresultSummaryView.this.m_detailedSummaryIds = TestResultPM.computeTestresultIdsWithDetails((EntityManager)GeneralStorage.getInstance().getMasterSession());
                    }
                    if (metaList != null) {
                        TestresultSummaryView.this.m_tableViewer.setInput((Object)metaList.toArray());
                    }
                }
                catch (JBException e) {
                    String msg = Messages.CantLoadMetadataFromDatabase;
                    log.error(msg, (Throwable)e);
                    TestresultSummaryView.this.showErrorDialog(msg);
                }
                ISelection s = TestresultSummaryView.this.m_tableViewer.getSelection();
                TestresultSummaryView.this.m_tableViewer.setSelection(null);
                TestresultSummaryView.this.m_tableViewer.setSelection(s);
            }
        });
    }

    private void setTableViewerLayout() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.m_tableViewer.getControl().setLayoutData((Object)gridData);
    }

    public void manageColumnWidths() {
        int availableWidth = this.m_tableViewer.getTable().getBounds().width;
        ScrollBar verticalBar = this.m_tableViewer.getTable().getVerticalBar();
        if (verticalBar.isVisible()) {
            availableWidth -= verticalBar.getSize().x + 5;
        }
        TableColumn[] columns = this.m_tableViewer.getTable().getColumns();
        ArrayList<TableColumn> columnsWithVariableWidth = new ArrayList<TableColumn>();
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            String columnName = column.getText();
            if (columnName.equals(TESTRESULT_ALM_REPORT_STATE) || columnName.equals(TESTRESULT_SUMMARY_DATE) || columnName.equals(TESTRESULT_SUMMARY_DETAILS_AVAILABLE) || columnName.equals(TESTRESULT_PROJECT_VERSION) || columnName.equals(TESTRESULT_SUMMARY_START_TIME) || columnName.equals(TESTRESULT_SUMMARY_END_TIME) || columnName.equals(TESTRESULT_SUMMARY_DURATION) || columnName.equals(TESTRESULT_SUMMARY_EXECUTED_CAPS) || columnName.equals(TESTRESULT_SUMMARY_EXPECTED_CAPS) || columnName.equals(TESTRESULT_SUMMARY_HANDLER_CAPS) || columnName.equals(TESTRESULT_SUMMARY_LANGUAGE) || columnName.equals(TESTRESULT_SUMMARY_TESTRUN_RELEVANT) || columnName.equals(TESTRESULT_SUMMARY_TOOLKIT) || columnName.equals(TESTRESULT_SUMMARY_TESTRUN_STATE)) {
                availableWidth -= column.getWidth();
            } else if (column.getWidth() > 0) {
                columnsWithVariableWidth.add(column);
            }
            ++n2;
        }
        int numberOfVariableColums = columnsWithVariableWidth.size();
        if (numberOfVariableColums == 0) {
            return;
        }
        int columnWidth = Math.max(150, availableWidth / numberOfVariableColums);
        for (TableColumn column : columnsWithVariableWidth) {
            column.setWidth(columnWidth);
        }
    }

    private void addTestJobColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.TJ_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_TEST_JOB);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getTestJobName());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestJobName(), ((ITestResultSummaryPO)e2).getTestJobName());
            }
        };
    }

    private void addTestJobStartTimeColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.CLOCK_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_TEST_JOB_START_TIME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                Date date = ((ITestResultSummaryPO)element).getTestJobStartTime();
                if (date != null) {
                    return DTF_LONG.format(date);
                }
                return ObjectUtils.toString((Object)date, (String)"");
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestJobStartTime(), ((ITestResultSummaryPO)e2).getTestJobStartTime());
            }
        };
    }

    private void addStatusDecoratorColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(60);
        column.getColumn().setToolTipText(Messages.TestresultSummaryColumnDescriptionStatus);
        column.getColumn().setText(TESTRESULT_SUMMARY_TESTRUN_STATE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                ITestResultSummaryPO row = (ITestResultSummaryPO)element;
                switch (row.getTestsuiteStatus()) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        return IconConstants.STEP_OK_IMAGE;
                    }
                    case 6: {
                        return IconConstants.STEP_TESTING_IMAGE;
                    }
                    case 1: {
                        return IconConstants.STEP_OK_IMAGE;
                    }
                    case 2: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                    case 5: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                    case 4: {
                        return IconConstants.STEP_FAILED_IMAGE;
                    }
                    case 7: {
                        return IconConstants.STEP_RETRY_IMAGE;
                    }
                    case 8: {
                        return IconConstants.STEP_RETRY_OK_IMAGE;
                    }
                    case 9: {
                        return IconConstants.STEP_NOT_OK_IMAGE;
                    }
                    default: {
                        return null;
                    }
                }
                return null;
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestRunState(), ((ITestResultSummaryPO)e2).getTestRunState());
            }
        };
    }

    private void addAlmStatusDecoratorColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setText(TESTRESULT_ALM_REPORT_STATE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                ITestResultSummaryPO row = (ITestResultSummaryPO)element;
                return TestresultSummaryView.this.getDescriptiveALMStatusDescription(row);
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAlmReportStatus(), ((ITestResultSummaryPO)e2).getAlmReportStatus());
            }
        };
    }

    private String getDescriptiveALMStatusDescription(ITestResultSummaryPO summary) {
        ITestResultSummaryPO.AlmReportStatus almReportStatus = summary.getAlmReportStatus();
        if (almReportStatus == ITestResultSummaryPO.AlmReportStatus.NOT_YET_REPORTED && !summary.isTestsuiteRelevant()) {
            return Messages.ALMStatusMarkedAsNonRelevant;
        }
        return I18n.getString((String)("almReportStatus." + almReportStatus));
    }

    private void addProjectNameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.PROJECT_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_PROJECT_NAME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getProjectName());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getProjectName(), ((ITestResultSummaryPO)e2).getProjectName());
            }
        };
    }

    private String getProjectVersion(ITestResultSummaryPO element) {
        return StringUtils.defaultString((String)(String.valueOf(String.valueOf(element.getProjectMajorVersion())) + "." + String.valueOf(element.getProjectMinorVersion())));
    }

    private void addProjectVersionColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.PROJECT_IMAGE);
        column.getColumn().setText(TESTRESULT_PROJECT_VERSION);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return TestresultSummaryView.this.getProjectVersion((ITestResultSummaryPO)element);
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                ITestResultSummaryPO testResultSummary1 = (ITestResultSummaryPO)e1;
                ITestResultSummaryPO testResultSummary2 = (ITestResultSummaryPO)e2;
                int majDif = testResultSummary1.getProjectMajorVersion() - testResultSummary2.getProjectMajorVersion();
                if (majDif != 0) {
                    return majDif;
                }
                return testResultSummary1.getProjectMinorVersion() - testResultSummary2.getProjectMinorVersion();
            }
        };
    }

    private void addTestsuiteColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(250);
        column.getColumn().setImage(IconConstants.TS_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_TESTSUITE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getTestsuiteName());
            }
        });
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteName(), ((ITestResultSummaryPO)e2).getTestsuiteName());
            }
        };
        this.createMenuItem(this.m_headerMenu, column.getColumn());
    }

    private void addTsStatusColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.TS_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_TESTSUITE_STATUS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getStatusString());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getStatusString(), ((ITestResultSummaryPO)e2).getStatusString());
            }
        };
    }

    private void addAutNameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.AUT_RUNNING_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_AUT_NAME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutName());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutName(), ((ITestResultSummaryPO)e2).getAutName());
            }
        };
    }

    private void addAutIdColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.AUT_RUNNING_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_AUT_ID);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutId());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutId(), ((ITestResultSummaryPO)e2).getAutId());
            }
        };
    }

    private void addAutConfColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.AUT_RUNNING_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_AUT_CONFIG);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutConfigName());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutConfigName(), ((ITestResultSummaryPO)e2).getAutConfigName());
            }
        };
    }

    private void addAutAgentHostnameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.AUT_RUNNING_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_AUT_AGENT_HOSTNAME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutAgentName());
            }
        });
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutAgentName(), ((ITestResultSummaryPO)e2).getAutAgentName());
            }
        };
        this.createMenuItem(this.m_headerMenu, column.getColumn());
    }

    private void addAutHostnameColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.AUT_RUNNING_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_AUT_HOSTNAME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutHostname());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutHostname(), ((ITestResultSummaryPO)e2).getAutHostname());
            }
        };
    }

    private void addAutOSColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.AUT_RUNNING_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_AUT_OS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutOS());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutOS(), ((ITestResultSummaryPO)e2).getAutOS());
            }
        };
    }

    private void addLanguageColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.LANGUAGE_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_LANGUAGE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return ObjectUtils.toString((Object)((ITestResultSummaryPO)element).getTestsuiteLanguage());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteLanguage(), ((ITestResultSummaryPO)e2).getTestsuiteLanguage());
            }
        };
    }

    private void addToolkitColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setText(TESTRESULT_SUMMARY_TOOLKIT);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutToolkit());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutToolkit(), ((ITestResultSummaryPO)e2).getAutToolkit());
            }
        };
    }

    private void addDateColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(TESTRESULT_SUMMARY_DATE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return DTF_DEFAULT.format(((ITestResultSummaryPO)element).getTestsuiteDate());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteDate(), ((ITestResultSummaryPO)e2).getTestsuiteDate());
            }
        };
    }

    private void addCommentTitleColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setText(TESTRESULT_SUMMARY_COMMENT_TITLE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return ObjectUtils.toString((Object)((ITestResultSummaryPO)element).getCommentTitle());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getCommentTitle(), ((ITestResultSummaryPO)e2).getCommentTitle());
            }
        };
    }

    private void addStartTimeColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.CLOCK_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_START_TIME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return DTF_LONG.format(((ITestResultSummaryPO)element).getTestsuiteStartTime());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteStartTime(), ((ITestResultSummaryPO)e2).getTestsuiteStartTime());
            }
        };
    }

    private void addEndTimeColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.CLOCK_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_END_TIME);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return DTF_LONG.format(((ITestResultSummaryPO)element).getTestsuiteEndTime());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteEndTime(), ((ITestResultSummaryPO)e2).getTestsuiteEndTime());
            }
        };
    }

    private void addDurationColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.CLOCK_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_DURATION);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getTestsuiteDuration());
            }
        });
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteDuration(), ((ITestResultSummaryPO)e2).getTestsuiteDuration());
            }
        };
        this.createMenuItem(this.m_headerMenu, column.getColumn());
    }

    private void addExpecCapsColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.CAP_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_EXPECTED_CAPS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((ITestResultSummaryPO)element).getTestsuiteExpectedTeststeps());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteExpectedTeststeps(), ((ITestResultSummaryPO)e2).getTestsuiteExpectedTeststeps());
            }
        };
    }

    private void addExecCapsColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.CAP_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_EXECUTED_CAPS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((ITestResultSummaryPO)element).getTestsuiteExecutedTeststeps());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteExecutedTeststeps(), ((ITestResultSummaryPO)e2).getTestsuiteExecutedTeststeps());
            }
        };
    }

    private void addEventhandlerCapsColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.EH_CAP_IMAGE);
        column.getColumn().setText(TESTRESULT_SUMMARY_HANDLER_CAPS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((ITestResultSummaryPO)element).getTestsuiteEventHandlerTeststeps());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getTestsuiteEventHandlerTeststeps(), ((ITestResultSummaryPO)e2).getTestsuiteEventHandlerTeststeps());
            }
        };
    }

    private void addCmdParamColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setText(TESTRESULT_SUMMARY_CMD_PARAM);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getAutCmdParameter());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getAutCmdParameter(), ((ITestResultSummaryPO)e2).getAutCmdParameter());
            }
        };
    }

    private void addTestrunIdColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setText(TESTRESULT_SUMMARY_TESTRUN_ID);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultString((String)((ITestResultSummaryPO)element).getId().toString());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getId(), ((ITestResultSummaryPO)e2).getId());
            }
        };
    }

    private void addTestRelevantColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setText(TESTRESULT_SUMMARY_TESTRUN_RELEVANT);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((ITestResultSummaryPO)element).isTestsuiteRelevant());
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).isTestsuiteRelevant(), ((ITestResultSummaryPO)e2).isTestsuiteRelevant());
            }
        };
    }

    private void addMonitoringReportColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.INFO_IMAGE);
        column.getColumn().setText(MONITORING_DETAILS);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                if (((ITestResultSummaryPO)element).isReportWritten()) {
                    return Messages.TestresultSummaryMonitoringDetailsAvailable;
                }
                return Messages.TestresultSummaryMonitoringDetailsNotAvailable;
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).isReportWritten(), ((ITestResultSummaryPO)e2).isReportWritten());
            }
        };
    }

    private void addMonitoringIdColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.INFO_IMAGE);
        column.getColumn().setText(MONITORING_ID);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                return StringUtils.defaultIfEmpty((String)((ITestResultSummaryPO)element).getInternalMonitoringId(), (String)Messages.TestresultSummaryMonitoringIdNonSelected);
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getInternalMonitoringId(), ((ITestResultSummaryPO)e2).getInternalMonitoringId());
            }
        };
    }

    private void addMonitoringValueColumn(TableViewer tableViewer) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setWidth(0);
        column.getColumn().setImage(IconConstants.INFO_IMAGE);
        column.getColumn().setText(MONITORING_VALUE);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new TestresultSummaryViewColumnLabelProvider(){

            public String getText(Object element) {
                String monitoringValue = ((ITestResultSummaryPO)element).getMonitoringValue();
                String monitoringId = ((ITestResultSummaryPO)element).getInternalMonitoringId();
                String monitoringValueTyp = ((ITestResultSummaryPO)element).getMonitoringValueType();
                if (monitoringId != null && monitoringValue != null) {
                    if (monitoringValueTyp.equals("PERCENT")) {
                        DecimalFormat n = new DecimalFormat("0.0#%");
                        Double doubleValue = Double.valueOf(monitoringValue);
                        return StringUtils.defaultString((String)n.format(doubleValue));
                    }
                    if (monitoringValueTyp.equals("DOUBLE")) {
                        return String.format(Locale.getDefault(), "%f", monitoringValue);
                    }
                    return StringUtils.defaultString((String)monitoringValue);
                }
                return Messages.TestresultSummaryMonitoringValueNotAvailable;
            }
        });
        this.createMenuItem(this.m_headerMenu, column.getColumn());
        new ColumnViewerSorter((ColumnViewer)tableViewer, column){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return TestresultSummaryView.getCommonsComparator().compare(((ITestResultSummaryPO)e1).getMonitoringValue(), ((ITestResultSummaryPO)e2).getMonitoringValue());
            }
        };
    }

    private void showErrorDialog(String message) {
        ErrorHandlingUtil.createMessageDialog(new JBException(message, MessageIDs.E_PERSISTENCE_LOAD_FAILED), null, new String[]{message});
    }

    private void createMenuItem(Menu menu, final TableColumn column) {
        final MenuItem itemName = new MenuItem(menu, 32);
        itemName.setText(column.getText());
        itemName.setSelection(false);
        if (column.getWidth() > 0) {
            itemName.setSelection(true);
        }
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (itemName.getSelection()) {
                    column.setWidth(150);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
    }

    public void setFocus() {
        this.m_tableViewer.getControl().setFocus();
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeTestresultListener((DataEventDispatcher.ITestresultChangedListener)this);
        ded.removeTestresultSummaryEventListener((DataEventDispatcher.ITestresultSummaryEventListener)this);
        DatabaseStateDispatcher.removeDatabaseStateListener((IDatabaseStateListener)this);
        super.dispose();
    }

    public void clear() {
        this.m_tableViewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                TestresultSummaryView.this.m_tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                TestresultSummaryView.this.m_tableViewer.setInput((Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
                TestresultSummaryView.this.m_tableViewer.refresh(true);
            }
        });
    }

    public void handleTestresultChanged(DataEventDispatcher.TestresultState state) {
        switch (state) {
            case Clear: {
                this.clear();
                break;
            }
            case Refresh: {
                this.loadViewInput();
                break;
            }
        }
    }

    public void handleTestresultSummaryChanged(ITestResultSummaryPO summary, DataEventDispatcher.DataState state) {
        this.loadViewInput();
    }

    private static Comparator getCommonsComparator() {
        return ComparatorUtils.nullHighComparator((Comparator)ComparatorUtils.naturalComparator());
    }

    public void reactOnDatabaseEvent(DatabaseStateEvent e) {
        switch (e.getState()) {
            case DB_LOGIN_SUCCEEDED: {
                this.loadViewInput();
                break;
            }
            case DB_LOGOUT_SUCCEEDED: {
                this.clear();
                break;
            }
        }
    }

    private class TestresultFilterJob
    extends Job {
        private String m_filterText;

        public TestresultFilterJob(String name, String filterText) {
            super(name);
            this.m_filterText = "";
            this.m_filterText = filterText;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TestresultSummaryView.this.m_tableViewer.getTable().getDisplay().syncExec(new Runnable(){

                public void run() {
                    TestresultSummaryView.this.m_filter.setPattern(TestresultFilterJob.this.m_filterText);
                    TestresultSummaryView.this.m_tableViewer.refresh();
                }
            });
            return Status.OK_STATUS;
        }
    }

    private class TestresultSummaryFilter
    extends JBPatternFilter {
        private String m_filterType = "";

        private TestresultSummaryFilter() {
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            ITestResultSummaryPO m = (ITestResultSummaryPO)element;
            String metaValue = "";
            if (this.m_filterType.equals(TESTRESULT_SUMMARY_DATE)) {
                metaValue = DTF_DEFAULT.format(m.getTestsuiteDate());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TESTRUN_ID)) {
                metaValue = String.valueOf(m.getId());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TEST_JOB_START_TIME)) {
                Date date = m.getTestJobStartTime();
                metaValue = date != null ? DTF_LONG.format(date) : "";
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TEST_JOB)) {
                metaValue = m.getTestJobName();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TESTRUN_STATE)) {
                metaValue = m.getTestRunState();
            } else if (this.m_filterType.equals(TESTRESULT_ALM_REPORT_STATE)) {
                metaValue = TestresultSummaryView.this.getDescriptiveALMStatusDescription(m);
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_PROJECT_NAME)) {
                metaValue = m.getProjectName();
            } else if (this.m_filterType.equals(TESTRESULT_PROJECT_VERSION)) {
                metaValue = TestresultSummaryView.this.getProjectVersion(m);
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TESTSUITE)) {
                metaValue = m.getTestsuiteName();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TESTSUITE_STATUS)) {
                metaValue = m.getStatusString();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_AUT_NAME)) {
                metaValue = m.getAutName();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_AUT_ID)) {
                metaValue = m.getAutId();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_AUT_CONFIG)) {
                metaValue = m.getAutConfigName();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_AUT_AGENT_HOSTNAME)) {
                metaValue = m.getAutAgentName();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_AUT_HOSTNAME)) {
                metaValue = m.getAutHostname();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_AUT_OS)) {
                metaValue = m.getAutOS();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TOOLKIT)) {
                metaValue = m.getAutToolkit();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_LANGUAGE)) {
                metaValue = m.getTestsuiteLanguage();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_START_TIME)) {
                metaValue = DTF_LONG.format(m.getTestsuiteStartTime());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_END_TIME)) {
                metaValue = DTF_LONG.format(m.getTestsuiteEndTime());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_DURATION)) {
                metaValue = m.getTestsuiteDuration();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_EXPECTED_CAPS)) {
                metaValue = String.valueOf(m.getTestsuiteExpectedTeststeps());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_EXECUTED_CAPS)) {
                metaValue = String.valueOf(m.getTestsuiteExecutedTeststeps());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_HANDLER_CAPS)) {
                metaValue = String.valueOf(m.getTestsuiteEventHandlerTeststeps());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_CMD_PARAM)) {
                metaValue = m.getAutCmdParameter();
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_TESTRUN_RELEVANT)) {
                metaValue = String.valueOf(m.isTestsuiteRelevant());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_DETAILS_AVAILABLE)) {
                metaValue = String.valueOf(TestresultSummaryView.this.m_detailedSummaryIds.contains(m.getId()));
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_NUMBER_OF_FAILED_CAPS)) {
                metaValue = String.valueOf(m.getTestsuiteFailedTeststeps());
            } else if (this.m_filterType.equals(TESTRESULT_SUMMARY_COMMENT_TITLE)) {
                metaValue = StringUtils.defaultString((String)m.getCommentTitle());
            }
            return this.wordMatches(metaValue);
        }

        public void setFilterType(String filterType) {
            this.m_filterType = filterType;
        }
    }
}

