/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.wiki.ui.views;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.wiki.ui.i18n.Messages;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DescriptionView
extends ViewPart {
    private Browser m_browser;
    private MarkupParser m_markupParser;
    private ISelectionListener m_listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            if (sourcepart != DescriptionView.this) {
                this.showSelection(selection);
            }
        }

        private void showSelection(ISelection selection) {
            INodePO node;
            String comment;
            StructuredSelection structuredSelection;
            Object firstElement;
            if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof INodePO && StringUtils.isNotEmpty((String)(comment = (node = (INodePO)firstElement).getComment()))) {
                DescriptionView.this.m_browser.setText(DescriptionView.this.m_markupParser.parseToHtml(comment));
                return;
            }
            DescriptionView.this.m_browser.setText(Messages.NoDescriptionAvailable);
        }
    };

    public void createPartControl(Composite parent) {
        this.m_browser = new Browser(parent, 0);
        this.m_browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                event.doit = false;
            }

            public void changing(LocationEvent event) {
                if (event.location.matches("([a-zA-Z]{3,8})://?.*")) {
                    int idxOfSlashHash = event.location.indexOf("/#");
                    if (idxOfSlashHash != -1) {
                        if (!event.location.startsWith("file:///#")) {
                            event.doit = false;
                        }
                        return;
                    }
                    event.doit = false;
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().createBrowser("org.eclipse.ui.browser").openURL(new URL(event.location));
                    }
                    catch (Exception exception) {
                        new URLHyperlink((IRegion)new Region(0, 1), event.location).open();
                    }
                }
            }
        });
        this.m_markupParser = new MarkupParser();
        this.m_markupParser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.m_listener);
    }

    public void setFocus() {
        this.m_browser.setFocus();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.m_listener);
        super.dispose();
    }
}

