/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.launch.rcp.ui;

import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.launch.ui.tab.AutLaunchConfigurationTab;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RcpAutLaunchConfigurationTab
extends AutLaunchConfigurationTab {
    private static final Logger LOG = LoggerFactory.getLogger(RcpAutLaunchConfigurationTab.class);
    private Text m_keyboardLayoutText;
    private Button m_generateNamesFlag;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        super.createControl(composite);
        Composite additionalComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)additionalComposite);
        additionalComposite.setLayout((Layout)new GridLayout(2, false));
        UIComponentHelper.createLabel((Composite)additionalComposite, (String)org.eclipse.jubula.launch.rcp.i18n.Messages.LaunchTab_KeyboardLayoutLabel, (int)0);
        this.m_keyboardLayoutText = new Text(additionalComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.m_keyboardLayoutText);
        this.m_keyboardLayoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RcpAutLaunchConfigurationTab.this.setDirty(true);
                RcpAutLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite workaroundComposite = new Composite(additionalComposite, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)workaroundComposite);
        workaroundComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(workaroundComposite, 0);
        label.setText(Messages.AUTPropertiesDialogGenerateNames);
        ControlDecorator.createInfo((Control)label, (String)I18n.getString((String)"AUTPropertiesDialog.generateNamesDescription"), (boolean)false);
        this.m_generateNamesFlag = new Button(additionalComposite, 32);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.m_generateNamesFlag);
        this.m_generateNamesFlag.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RcpAutLaunchConfigurationTab.this.setDirty(true);
                RcpAutLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setControl((Control)composite);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.m_keyboardLayoutText.setText(configuration.getAttribute("org.eclipse.jubula.launch.swt.KEYBOARD_LAYOUT", Locale.getDefault().toString()));
        }
        catch (CoreException ce) {
            LOG.error("An error occurred while initializing Keyboard Layout text field.", (Throwable)ce);
        }
        try {
            this.m_generateNamesFlag.setSelection(configuration.getAttribute("TEST_GENERATE_NAMES_PROPERTY", true));
        }
        catch (CoreException ce) {
            LOG.error("An error occurred while initializing Generate Names check box.", (Throwable)ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("org.eclipse.jubula.launch.swt.KEYBOARD_LAYOUT", this.m_keyboardLayoutText.getText());
        configuration.setAttribute("TEST_GENERATE_NAMES_PROPERTY", this.m_generateNamesFlag.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.jubula.launch.swt.KEYBOARD_LAYOUT", Locale.getDefault().toString());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean isValid = super.isValid(launchConfig);
        if (isValid) {
            try {
                String keyboardLayoutString = launchConfig.getAttribute("org.eclipse.jubula.launch.swt.KEYBOARD_LAYOUT", "");
                isValid = this.isKeyboardLayoutValid(keyboardLayoutString);
                if (!isValid) {
                    this.setErrorMessage(NLS.bind((String)org.eclipse.jubula.launch.rcp.i18n.Messages.LaunchTab_KeyboardLayout_InvalidLocale, (Object)keyboardLayoutString));
                }
            }
            catch (CoreException ce) {
                LOG.error("An error occurred during validation.", (Throwable)ce);
                this.setErrorMessage(org.eclipse.jubula.launch.rcp.i18n.Messages.LaunchTab_KeyboardLayout_ErrorDuringValidation);
                return false;
            }
        }
        return isValid;
    }

    private boolean isKeyboardLayoutValid(String keyboardLayout) {
        try {
            return LocaleUtils.toLocale((String)keyboardLayout) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

