/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.KeyTyper;
import org.eclipse.jubula.rc.common.exception.ExecutionEvent;
import org.eclipse.jubula.rc.common.exception.OsNotSupportedException;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.interfaces.ITester;
import org.eclipse.jubula.rc.common.util.Comparer;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.ExternalCommandExecutor;
import org.eclipse.jubula.tools.utils.TimeUtil;

public abstract class AbstractApplicationTester
implements ITester {
    public static final String RENAME = "rename";
    public static final String OVERWRITE = "overwrite";
    protected static final String DEFAULT_IMAGE_FORMAT = "png";
    protected static final String EXTENSION_SEPARATOR = ".";
    private static AutServerLogger log = new AutServerLogger(AbstractApplicationTester.class);

    public void rcInputText(String text) {
        this.getRobot().type(this.getFocusOwner(), text);
    }

    public void rcExecuteExternalCommand(String cmd, int expectedExitCode, boolean local, int timeout) {
        if (!local) {
            ExternalCommandExecutor.MonitorTask mt = new ExternalCommandExecutor().executeCommand(null, cmd, timeout);
            if (!mt.wasCmdValid()) {
                throw new StepExecutionException("Command not found.", EventFactory.createActionError((String)"TestErrorEvent.NoSuchCommand"));
            }
            if (mt.hasTimeoutOccurred()) {
                throw new StepExecutionException("Timeout received before completing execution of script.", EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
            }
            int actualExitValue = mt.getExitCode();
            if (actualExitValue != expectedExitCode) {
                throw new StepExecutionException("Verification of exit code failed.", EventFactory.createVerifyFailed((String)String.valueOf(expectedExitCode), (String)String.valueOf(actualExitValue)));
            }
        }
    }

    public void setComponent(Object graphicsComponent) {
    }

    public void rcTakeScreenshot(String destination, int delay, String fileAccess, int scaling, boolean createDirs) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        if (screenWidth % 2 != 0) {
            --screenWidth;
        }
        if (screenHeight % 2 != 0) {
            --screenHeight;
        }
        screenSize.setSize(screenWidth, screenHeight);
        Rectangle screenRect = new Rectangle(screenSize);
        this.takeScreenshot(destination, delay, fileAccess, scaling, createDirs, screenRect);
    }

    public void rcTakeScreenshotOfActiveWindow(String destination, int delay, String fileAccess, int scaling, boolean createDirs, int marginTop, int marginRight, int marginBottom, int marginLeft) {
        Rectangle activeWindowBounds = this.getActiveWindowBounds();
        if (activeWindowBounds == null) {
            throw new StepExecutionException("No active window found", EventFactory.createActionError((String)"TestErrorEvent.NoActiveWindow"));
        }
        int x = activeWindowBounds.x - marginLeft;
        int y = activeWindowBounds.y - marginTop;
        int width = activeWindowBounds.width + marginLeft + marginRight;
        int height = activeWindowBounds.height + marginTop + marginBottom;
        if (width < 1 || height < 1) {
            throw new StepExecutionException("Margin parameter lead to negative height or width", EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
        }
        Rectangle screenRect = new Rectangle(x, y, width, height);
        this.takeScreenshot(destination, delay, fileAccess, scaling, createDirs, screenRect);
    }

    public abstract Rectangle getActiveWindowBounds();

    private void takeScreenshot(String destination, int delay, String fileAccess, int scaling, boolean createDirs, Rectangle screenShotRect) {
        File pic;
        if (scaling <= 0 || scaling > 200) {
            throw new StepExecutionException("Invalid scaling factor: Must be between 1 and 200", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        double scaleFactor = (double)scaling * 0.01;
        String outFileName = destination;
        String imageExtension = this.getExtension(outFileName);
        if (imageExtension.length() == 0) {
            imageExtension = DEFAULT_IMAGE_FORMAT;
            outFileName = String.valueOf(outFileName) + EXTENSION_SEPARATOR + imageExtension;
        }
        if (delay > 0) {
            TimeUtil.delay((long)delay);
        }
        if ((pic = new File(outFileName)).getParent() == null) {
            throw new StepExecutionException("Invalid file name: specify a file name", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        File path = new File(pic.getParent());
        if (createDirs && !path.exists() && !path.mkdirs()) {
            throw new StepExecutionException("Directory path does not exist and could not be created", EventFactory.createActionError((String)"TestErrorEvent.FileIOError"));
        }
        if (fileAccess.equals(RENAME)) {
            String completeExtension = EXTENSION_SEPARATOR + imageExtension.toLowerCase();
            int extensionIndex = pic.getName().toLowerCase().lastIndexOf(completeExtension);
            String fileName = pic.getName().substring(0, extensionIndex);
            int i = 1;
            while (pic.exists()) {
                pic = new File(pic.getParent(), String.valueOf(fileName) + "_" + i + completeExtension);
                ++i;
            }
        }
        this.takeScreenshot(screenShotRect, scaleFactor, pic);
    }

    public void takeScreenshot(Rectangle captureRect, double scaleFactor, File outputFile) {
        File out = outputFile;
        try {
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(captureRect);
            int scaledWidth = (int)Math.floor((double)image.getWidth() * scaleFactor);
            int scaledHeight = (int)Math.floor((double)image.getHeight() * scaleFactor);
            BufferedImage imageOut = new BufferedImage(scaledWidth, scaledHeight, 1);
            Graphics2D graphics2D = imageOut.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
            String extension = this.getExtension(out.getName());
            if (!(extension.length() != 0 && ImageIO.getImageWritersBySuffix(extension).hasNext() && ImageIO.write((RenderedImage)imageOut, extension, out) || ImageIO.write((RenderedImage)imageOut, DEFAULT_IMAGE_FORMAT, out = new File(String.valueOf(outputFile.getPath()) + EXTENSION_SEPARATOR + DEFAULT_IMAGE_FORMAT)))) {
                log.error("Screenshot could not be saved. Default image format (png) is not supported.");
            }
        }
        catch (AWTException e) {
            throw new RobotException(e);
        }
        catch (IOException iOException) {
            throw new StepExecutionException("Screenshot could not be saved", EventFactory.createActionError((String)"TestErrorEvent.FileIOError"));
        }
    }

    public void rcWait(int timeMilliSec) {
        TimeUtil.delay((long)timeMilliSec);
    }

    public void rcPause() {
        throw new ExecutionEvent(31);
    }

    public void rcRestart() {
    }

    public void rcPrepareForShutdown() {
    }

    public void rcSyncShutdownAndRestart(int timeout) {
    }

    public void rcNativeInputText(String text) {
        try {
            KeyTyper.getInstance().nativeTypeString(text);
        }
        catch (AWTException e) {
            throw new RobotException(e);
        }
    }

    public void rcManualTestStep(String actionToPerform, String expectedBehavior, int timeout) {
    }

    public void rcNativeKeyStroke(String modifierSpec, String keySpec) {
        if (keySpec == null || keySpec.trim().length() == 0) {
            throw new StepExecutionException("The base key of the key stroke must not be null or empty", EventFactory.createActionError());
        }
        try {
            KeyTyper typer = KeyTyper.getInstance();
            String keyStrokeSpec = keySpec.trim().toUpperCase();
            String mod = KeyStrokeUtil.getModifierString(modifierSpec);
            if (mod.length() > 0) {
                keyStrokeSpec = String.valueOf(mod) + " " + keyStrokeSpec;
            }
            typer.type(keyStrokeSpec, null, null, null);
        }
        catch (AWTException e) {
            throw new RobotException(e);
        }
    }

    public String rcSetValue(String variable, String value) {
        return value;
    }

    protected abstract IRobot getRobot();

    protected String getExtension(String filename) {
        File file = new File(filename);
        int extensionIndex = file.getName().lastIndexOf(EXTENSION_SEPARATOR);
        return extensionIndex == -1 || extensionIndex == file.getName().length() - 1 ? "" : file.getName().substring(extensionIndex + 1);
    }

    public void rcCopyToClipboard(String text) {
        StringSelection strSel = new StringSelection(text);
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(strSel, null);
        }
        catch (IllegalStateException illegalStateException) {
            throw new StepExecutionException("Clipboard not available.", EventFactory.createActionError((String)"TestErrorEvent.ClipboardNotAvailable"));
        }
    }

    public void rcCheckValues(String value1, String comparisonMethod, String value2) {
        Comparer.compare(value1, value2, comparisonMethod);
    }

    public void rcCheckStringValues(String value1, String operator, String value2) {
        Verifier.match(value1, value2, operator);
    }

    public void rcStartTimer(String timerName, String variableName) {
    }

    public void rcReadTimer(String timerName, String variableName) {
    }

    public void rcActivate(String method) {
        this.getRobot().activateApplication(method);
    }

    public void rcClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        Object activeWindow = this.getActiveWindow();
        if (activeWindow == null) {
            throw new StepExecutionException("No active window.", EventFactory.createActionError((String)"TestErrorEvent.NoActiveWindow"));
        }
        this.getRobot().click(activeWindow, null, ClickOptions.create().setClickCount(count).setConfirmClick(false).setMouseButton(button), xPos, xUnits.equalsIgnoreCase("Pixel"), yPos, yUnits.equalsIgnoreCase("Pixel"));
    }

    public void rcKeyType(int keyCode) {
        this.getRobot().keyType(null, keyCode);
    }

    public void rcToggle(int key, boolean activated) {
        int event = this.getEventCode(key);
        if (event != 0) {
            try {
                this.getRobot().keyToggle(this.getFocusOwner(), event, activated);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new StepExecutionException("TestErrorEvent.UnsupportedOperation", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedOperation"));
            }
            catch (OsNotSupportedException osNotSupportedException) {
                throw new StepExecutionException("TestErrorEvent.UnsupportedOperation", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedOperation"));
            }
        }
    }

    public abstract void rcKeyStroke(String var1, String var2);

    protected abstract Object getFocusOwner();

    protected abstract int getEventCode(int var1);

    protected abstract Object getActiveWindow();
}

